/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import de.myzelyam.api.vanish.PlayerHideEvent;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Feature;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class NightVision
extends Feature
implements Runnable {
    public static final int INFINITE_POTION_EFFECT_LENGTH = Short.MAX_VALUE;

    public NightVision(SuperVanish plugin) {
        super(plugin);
    }

    @Override
    public void onEnable() {
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 2400L, 2400L);
    }

    @Override
    public boolean isActive() {
        return this.plugin.getSettings().getBoolean("InvisibilityFeatures.NightVisionEffect");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVanish(PlayerHideEvent e) {
        Player p = e.getPlayer();
        this.sendAddPotionEffect(p, new PotionEffect(PotionEffectType.NIGHT_VISION, Short.MAX_VALUE, 0));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        Player p = e.getPlayer();
        this.sendRemovePotionEffect(p, PotionEffectType.NIGHT_VISION);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
            return;
        }
        this.sendAddPotionEffect(p, new PotionEffect(PotionEffectType.NIGHT_VISION, Short.MAX_VALUE, 0));
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
            return;
        }
        this.sendAddPotionEffect(p, new PotionEffect(PotionEffectType.NIGHT_VISION, Short.MAX_VALUE, 0));
    }

    @Override
    public void run() {
        for (UUID uuid : this.plugin.getVanishStateMgr().getOnlineVanishedPlayers()) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null) continue;
            this.sendRemovePotionEffect(p, PotionEffectType.NIGHT_VISION);
            this.sendAddPotionEffect(p, new PotionEffect(PotionEffectType.NIGHT_VISION, Short.MAX_VALUE, 0));
        }
    }

    private void sendAddPotionEffect(Player p, PotionEffect effect) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EFFECT);
        int effectID = effect.getType().getId();
        int amplifier = effect.getAmplifier();
        int duration = effect.getDuration();
        int entityID = p.getEntityId();
        packet.getIntegers().write(0, (Object)entityID);
        packet.getBytes().write(0, (Object)((byte)effectID));
        packet.getBytes().write(1, (Object)((byte)amplifier));
        packet.getIntegers().write(1, (Object)duration);
        packet.getBytes().write(2, (Object)0);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(p, packet);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot send packet", e);
        }
    }

    private void sendRemovePotionEffect(Player p, PotionEffectType type) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.REMOVE_ENTITY_EFFECT);
        int effectID = type.getId();
        int entityID = p.getEntityId();
        if (!this.plugin.getVersionUtil().isOneDotXOrHigher(8)) {
            packet.getIntegers().write(0, (Object)entityID);
            packet.getBytes().write(0, (Object)((byte)effectID));
        } else if (this.plugin.getVersionUtil().isOneDotX(8)) {
            packet.getIntegers().write(0, (Object)entityID);
            packet.getIntegers().write(1, (Object)effectID);
        } else {
            packet.getEffectTypes().write(0, (Object)type);
            packet.getIntegers().write(0, (Object)entityID);
        }
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(p, packet);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot send packet", e);
        }
    }
}

