/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.events;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.commands.CommandAction;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

public class LoginEvent
implements Listener {
    private final SuperVanish plugin;

    public LoginEvent(SuperVanish plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLogin(PlayerLoginEvent e) {
        try {
            if (e.getResult() != PlayerLoginEvent.Result.ALLOWED) {
                return;
            }
            Player p = e.getPlayer();
            boolean vanished = this.plugin.getVanishStateMgr().isVanished(p.getUniqueId());
            boolean itemPickUps = this.plugin.getPlayerData().getBoolean("PlayerData." + p.getUniqueId() + ".itemPickUps", this.plugin.getSettings().getBoolean("InvisibilityFeatures.DefaultPickUpItemsOption"));
            this.plugin.createVanishPlayer(p, itemPickUps);
            if (vanished && this.plugin.getSettings().getBoolean("VanishStateFeatures.CheckPermissionOnLogin", false) && !CommandAction.VANISH_SELF.checkPermission((CommandSender)p, this.plugin)) {
                vanished = false;
            }
            if (!vanished && p.hasPermission("sv.joinvanished") && this.plugin.getSettings().getBoolean("VanishStateFeatures.AutoVanishOnJoin", false)) {
                this.plugin.getVanishStateMgr().setVanishedState(p.getUniqueId(), p.getName(), true, null);
                vanished = true;
            }
            if (vanished) {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (this.plugin.hasPermissionToSee(onlinePlayer, p)) continue;
                    this.plugin.getVisibilityChanger().getHider().setHidden(p, onlinePlayer, true);
                }
            }
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!this.plugin.getVanishStateMgr().isVanished(onlinePlayer.getUniqueId()) || this.plugin.hasPermissionToSee(p, onlinePlayer)) continue;
                this.plugin.getVisibilityChanger().getHider().setHidden(onlinePlayer, p, true);
            }
        }
        catch (Exception er) {
            this.plugin.logException(er);
        }
    }
}

