/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.config;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.SuperVanishPlugin;
import de.myzelyam.supervanish.config.ConfigurableFile;
import de.myzelyam.supervanish.config.PluginFile;
import de.myzelyam.supervanish.config.StorageFile;
import java.util.HashMap;
import java.util.Map;

public class FileMgr {
    private final SuperVanishPlugin plugin;
    private Map<String, PluginFile<?>> files;

    public FileMgr(SuperVanishPlugin plugin) {
        this.plugin = plugin;
        this.files = new HashMap();
    }

    public PluginFile<?> addFile(String name, FileType type) {
        if (name == null) {
            throw new IllegalArgumentException("The file name cannot be null!");
        }
        if (type == FileType.STORAGE) {
            StorageFile file = new StorageFile(name, (SuperVanish)this.plugin);
            this.files.put(name, file);
            return file;
        }
        if (type == FileType.CONFIG) {
            ConfigurableFile file = new ConfigurableFile(name, (SuperVanish)this.plugin);
            this.files.put(name, file);
            return file;
        }
        throw new IllegalArgumentException("The FileType cannot be null!");
    }

    public void reloadFile(String fileName) {
        PluginFile<?> file = this.files.get(fileName);
        if (file == null) {
            throw new IllegalArgumentException("Specified file doesn't exist!");
        }
        file.reload();
    }

    public void reloadAll() {
        for (String fileName : this.files.keySet()) {
            this.reloadFile(fileName);
        }
    }

    public static enum FileType {
        STORAGE,
        CONFIG;

    }
}

