/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.commands.subcommands;

import com.google.common.collect.ImmutableList;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.commands.CommandAction;
import de.myzelyam.supervanish.commands.SubCommand;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class VanishedList
extends SubCommand {
    public VanishedList(SuperVanish plugin) {
        super(plugin);
    }

    @Override
    public void execute(Command cmd, CommandSender sender, String[] args, String label) {
        if (this.canDo(sender, CommandAction.VANISHED_LIST, true)) {
            String listMessage = this.plugin.getMessage("ListMessagePrefix");
            StringBuilder stringBuilder = new StringBuilder();
            ImmutableList allInvisiblePlayerUUIDs = ImmutableList.copyOf(this.getAllVanishedPlayers());
            if (allInvisiblePlayerUUIDs.isEmpty()) {
                stringBuilder.append("none");
            }
            for (int i = 0; i < allInvisiblePlayerUUIDs.size(); ++i) {
                UUID playerUUID = (UUID)allInvisiblePlayerUUIDs.get(i);
                String name = Bukkit.getOfflinePlayer((UUID)playerUUID).getName();
                if (Bukkit.getPlayer((UUID)playerUUID) == null) {
                    name = name + ChatColor.RED + "[offline]" + ChatColor.WHITE;
                }
                stringBuilder.append(name);
                if (i == allInvisiblePlayerUUIDs.size() - 1) continue;
                stringBuilder.append(ChatColor.GREEN).append(", ").append(ChatColor.WHITE);
            }
            listMessage = listMessage.replace("%l", stringBuilder.toString());
            this.plugin.sendMessage(sender, listMessage, sender);
        }
    }
}

