/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.commands.subcommands;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.commands.CommandAction;
import de.myzelyam.supervanish.commands.SubCommand;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VanishOther
extends SubCommand {
    private Player specifiedPlayer;

    public VanishOther(SuperVanish plugin) {
        this(null, plugin);
    }

    public VanishOther(Player specifiedPlayer, SuperVanish plugin) {
        super(plugin);
        this.specifiedPlayer = specifiedPlayer;
    }

    @Override
    public void execute(Command cmd, CommandSender sender, String[] args, String label) {
        if (this.canDo(sender, CommandAction.VANISH_OTHER, true)) {
            UUID uuid;
            String name;
            Player target;
            boolean hide = false;
            boolean offline = false;
            boolean silent = false;
            if (this.specifiedPlayer == null) {
                if (args[0].equalsIgnoreCase("on") || args[0].equalsIgnoreCase("enable") || args[0].equalsIgnoreCase("vanish")) {
                    hide = true;
                }
                name = (target = Bukkit.getPlayer((String)args[1])) == null ? args[1] : target.getName();
            } else {
                target = this.specifiedPlayer;
                name = this.specifiedPlayer.getName();
                boolean bl = hide = !this.isVanished(target.getUniqueId());
            }
            if (target == null) {
                offline = true;
                uuid = this.plugin.getVanishStateMgr().getVanishedUUIDFromNameOnFile(name);
                if (uuid == null) {
                    this.plugin.sendMessage(sender, "PlayerNonExistent", sender, name);
                    return;
                }
            } else {
                name = target.getName();
                uuid = target.getUniqueId();
            }
            if (!offline && sender instanceof Player && sender != target && target.hasPermission("sv.notoggle")) {
                this.plugin.sendMessage(sender, "CannotHideOtherPlayer", sender, name);
                return;
            }
            if (this.plugin.getSettings().getBoolean("IndicationFeatures.LayeredPermissions.HideInvisibleInCommands", false) && target != null && sender instanceof Player && !this.plugin.hasPermissionToSee((Player)sender, target)) {
                this.plugin.sendMessage(sender, "PlayerNonExistent", sender, name);
                return;
            }
            if (hide && (offline ? this.isVanished(uuid) : this.isVanished(uuid))) {
                this.plugin.sendMessage(sender, "AlreadyInvisibleMessage", sender, name);
                return;
            }
            if (!hide && !(!offline ? this.isVanished(uuid) : this.isVanished(uuid))) {
                this.plugin.sendMessage(sender, "AlreadyVisibleMessage", sender, name);
                return;
            }
            if (args.length == 3) {
                silent = args[2].equalsIgnoreCase("-s");
            } else if (args.length == 2) {
                silent = args[1].equalsIgnoreCase("-s");
            }
            if (!offline) {
                if (hide) {
                    this.plugin.getVisibilityChanger().hidePlayer(target, sender.getName(), silent);
                    this.plugin.sendMessage(sender, "HideOtherMessage", sender, name);
                } else {
                    this.plugin.getVisibilityChanger().showPlayer(target, sender.getName());
                    this.plugin.sendMessage(sender, "ShowOtherMessage", sender, name, silent);
                }
            } else if (hide) {
                this.plugin.getVanishStateMgr().setVanishedState(uuid, name, true, sender.getName());
                this.plugin.sendMessage(sender, "HideOtherMessage", sender, name);
            } else {
                this.plugin.getVanishStateMgr().setVanishedState(uuid, name, false, sender.getName());
                this.plugin.sendMessage(sender, "ShowOtherMessage", sender, name);
            }
        }
    }
}

