/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.hooks.PlaceholderAPIHook;
import de.myzelyam.supervanish.utils.Validation;
import java.util.Arrays;
import java.util.List;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class PlaceholderConverter {
    private final SuperVanish plugin;

    public PlaceholderConverter(SuperVanish plugin) {
        this.plugin = plugin;
    }

    public String replacePlaceholders(String msg, Object ... additionalPlayerInfo) {
        Validation.checkIsTrue("Failed to replace variables (Illegal arguments)", msg != null, additionalPlayerInfo != null);
        Validation.checkIsTrue(additionalPlayerInfo.length > 0);
        List<Object> additionalPlayerInfoList = Arrays.asList(additionalPlayerInfo);
        Object unspecifiedPlayer = additionalPlayerInfoList.get(0);
        String unspecifiedOtherPlayersName = null;
        if (additionalPlayerInfoList.size() > 1 && (additionalPlayerInfoList.get(1) instanceof String || additionalPlayerInfoList.get(1) instanceof Player)) {
            unspecifiedOtherPlayersName = (String)(additionalPlayerInfoList.get(1) instanceof Player ? ((Player)additionalPlayerInfoList.get(1)).getName() : additionalPlayerInfoList.get(1));
        }
        msg = msg.replace("\\n", "\n");
        if (unspecifiedPlayer instanceof OfflinePlayer && !(unspecifiedPlayer instanceof Player)) {
            OfflinePlayer specifiedPlayer = (OfflinePlayer)unspecifiedPlayer;
            if (Bukkit.getPluginManager().isPluginEnabled("MVdWPlaceholderAPI") && this.plugin.getSettings().getBoolean("HookOptions.EnableMVdWPlaceholderAPIHook", true)) {
                String replaced = PlaceholderAPI.replacePlaceholders((OfflinePlayer)specifiedPlayer, (String)msg);
                String string = msg = replaced == null ? msg : replaced;
            }
            if (Bukkit.getPluginManager().getPlugin("Essentials") != null) {
                msg = msg.replace("%nick%", specifiedPlayer.getName());
            }
            msg = msg.replace("%d%", specifiedPlayer.getName()).replace("%p%", specifiedPlayer.getName()).replace("%tab%", specifiedPlayer.getName());
            msg = msg.replace("%other%", unspecifiedOtherPlayersName != null ? unspecifiedOtherPlayersName : "UNKNOWN");
        } else if (unspecifiedPlayer instanceof Player) {
            Essentials ess;
            User u;
            String replaced;
            Player specifiedPlayer = (Player)unspecifiedPlayer;
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") && this.plugin.getSettings().getBoolean("HookOptions.EnablePlaceholderAPIHook", true)) {
                replaced = PlaceholderAPIHook.translatePlaceholders(msg, specifiedPlayer);
                String string = msg = replaced == null ? msg : replaced;
            }
            if (Bukkit.getPluginManager().isPluginEnabled("MVdWPlaceholderAPI") && this.plugin.getSettings().getBoolean("HookOptions.EnableMVdWPlaceholderAPIHook", true)) {
                replaced = PlaceholderAPI.replacePlaceholders((OfflinePlayer)specifiedPlayer, (String)msg);
                String string = msg = replaced == null ? msg : replaced;
            }
            if (Bukkit.getPluginManager().getPlugin("Essentials") != null && (u = (ess = (Essentials)Bukkit.getServer().getPluginManager().getPlugin("Essentials")).getUser(specifiedPlayer)) != null && u.getNickname() != null) {
                msg = msg.replace("%nick%", u.getNickname());
            }
            if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
                RegisteredServiceProvider permService = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
                RegisteredServiceProvider chatService = this.plugin.getServer().getServicesManager().getRegistration(Chat.class);
                Permission permAPI = permService != null ? (Permission)permService.getProvider() : null;
                Chat chatAPI = chatService != null ? (Chat)chatService.getProvider() : null;
                try {
                    String group;
                    if (permAPI != null && (group = permAPI.getPrimaryGroup(specifiedPlayer)) != null) {
                        msg = msg.replace("%group%", group);
                    }
                    if (chatAPI != null) {
                        String prefix = chatAPI.getPlayerPrefix(specifiedPlayer);
                        String suffix = chatAPI.getPlayerSuffix(specifiedPlayer);
                        if (prefix != null) {
                            msg = msg.replace("%prefix%", prefix);
                        }
                        if (suffix != null) {
                            msg = msg.replace("%suffix%", suffix);
                        }
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            msg = msg.replace("%d%", "" + specifiedPlayer.getDisplayName()).replace("%p%", "" + specifiedPlayer.getName()).replace("%tab%", "" + specifiedPlayer.getPlayerListName());
            msg = msg.replace("%other%", unspecifiedOtherPlayersName != null ? unspecifiedOtherPlayersName : "UNKNOWN");
        } else if (unspecifiedPlayer instanceof CommandSender) {
            msg = msg.replace("%d%", "Console").replace("%p%", "Console").replace("%tab%", "Console");
            msg = msg.replace("%other%", unspecifiedOtherPlayersName != null ? unspecifiedOtherPlayersName : "UNKNOWN");
        }
        msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        return msg;
    }
}

