/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TimePicker;

public class AMPMTimePicker
extends TimePicker {
    private static final String TAG = "AMPMTimePicker";
    private TimePicker.OnTimeChangedListener onTimeChangedListener;

    public AMPMTimePicker(Context context) {
        super(context);
    }

    public AMPMTimePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AMPMTimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public AMPMTimePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        ViewParent p;
        if (ev.getActionMasked() == 0 && (p = this.getParent()) != null) {
            p.requestDisallowInterceptTouchEvent(true);
        }
        return false;
    }

    public void setOnTimeChangedListener(TimePicker.OnTimeChangedListener onTimeChangedListener) {
        super.setOnTimeChangedListener(onTimeChangedListener);
        this.onTimeChangedListener = onTimeChangedListener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.init();
    }

    private void init() {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                ViewGroup amPmView;
                ViewGroup v2;
                ViewGroup v1 = (ViewGroup)this.getChildAt(0);
                if (Build.VERSION.SDK_INT < 23) {
                    v2 = (ViewGroup)v1.getChildAt(0);
                    ViewGroup v3 = (ViewGroup)v2.getChildAt(0);
                    if (this.getResources().getConfiguration().orientation == 2) {
                        ViewGroup v4 = (ViewGroup)v3.getChildAt(0);
                        amPmView = (ViewGroup)v4.getChildAt(3);
                    } else {
                        amPmView = (ViewGroup)v3.getChildAt(3);
                    }
                } else if (this.getResources().getConfiguration().orientation == 2) {
                    v2 = (ViewGroup)v1.getChildAt(1);
                    amPmView = (ViewGroup)v2.getChildAt(1);
                } else {
                    v2 = (ViewGroup)v1.getChildAt(0);
                    amPmView = (ViewGroup)v2.getChildAt(3);
                }
                View am = amPmView.getChildAt(0);
                View pm = amPmView.getChildAt(1);
                View.OnTouchListener listener = new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        int minute;
                        int hour;
                        if (Build.VERSION.SDK_INT < 23) {
                            hour = AMPMTimePicker.this.getCurrentHour();
                            minute = AMPMTimePicker.this.getCurrentMinute();
                        } else {
                            hour = AMPMTimePicker.this.getHour();
                            minute = AMPMTimePicker.this.getMinute();
                        }
                        hour = hour >= 12 ? hour - 12 : hour + 12;
                        AMPMTimePicker.this.onTimeChangedListener.onTimeChanged((TimePicker)AMPMTimePicker.this, hour, minute);
                        return false;
                    }
                };
                am.setOnTouchListener(listener);
                pm.setOnTouchListener(listener);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("TimePicker is not defined for this Android version : " + e.getMessage()));
        }
    }
}

