/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.signers;

import io.ethers.core.FastHex;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Signature;
import io.ethers.crypto.Secp256k1;
import io.ethers.signers.Signer;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lio/ethers/signers/PrivateKeySigner;", "Lio/ethers/signers/Signer;", "privateKey", "", "(Ljava/lang/String;)V", "Lio/ethers/core/types/Bytes;", "(Lio/ethers/core/types/Bytes;)V", "", "([B)V", "signingKey", "Lio/ethers/crypto/Secp256k1$SigningKey;", "(Lio/ethers/crypto/Secp256k1$SigningKey;)V", "address", "Lio/ethers/core/types/Address;", "getAddress", "()Lio/ethers/core/types/Address;", "getSigningKey", "()Lio/ethers/crypto/Secp256k1$SigningKey;", "signHash", "Lio/ethers/core/types/Signature;", "hash", "Companion", "ethers-signers"})
public final class PrivateKeySigner
implements Signer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Secp256k1.SigningKey signingKey;
    @NotNull
    private final Address address;

    public PrivateKeySigner(@NotNull Secp256k1.SigningKey signingKey) {
        this.signingKey = signingKey;
        this.address = new Address(Secp256k1.INSTANCE.publicKeyToAddress(this.signingKey.getPublicKey()));
    }

    @NotNull
    public final Secp256k1.SigningKey getSigningKey() {
        return this.signingKey;
    }

    @Override
    @NotNull
    public Address getAddress() {
        return this.address;
    }

    public PrivateKeySigner(@NotNull String privateKey) {
        this(PrivateKeySigner.Companion.validHexToKey(privateKey));
    }

    public PrivateKeySigner(@NotNull Bytes privateKey) {
        this(PrivateKeySigner.Companion.validByteArrayToKey(privateKey.getValue()));
    }

    public PrivateKeySigner(@NotNull byte[] privateKey) {
        this(PrivateKeySigner.Companion.validByteArrayToKey(privateKey));
    }

    @Override
    @NotNull
    public Signature signHash(@NotNull byte[] hash) {
        BigInteger[] sig = this.signingKey.signHash(hash);
        return new Signature(sig[0], sig[1], sig[2].longValue());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lio/ethers/signers/PrivateKeySigner$Companion;", "", "()V", "validByteArrayToKey", "Lio/ethers/crypto/Secp256k1$SigningKey;", "bytes", "", "validHexToKey", "hex", "", "ethers-signers"})
    public static final class Companion {
        private Companion() {
        }

        private final Secp256k1.SigningKey validHexToKey(String hex) {
            if (!FastHex.isValidHex((CharSequence)hex)) {
                throw new IllegalArgumentException("Invalid private key format. Should be hex string.");
            }
            return this.validByteArrayToKey(FastHex.decode((CharSequence)hex));
        }

        private final Secp256k1.SigningKey validByteArrayToKey(byte[] bytes) {
            if (bytes.length != 32) {
                throw new IllegalArgumentException("Invalid private key length. Should be exactly 32 bytes, got " + bytes.length);
            }
            return new Secp256k1.SigningKey(bytes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

