/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/ethers/crypto/Hashing;", "", "()V", "MESSAGE_PREFIX", "", "VERSIONED_HASH_VERSION_KZG", "", "blobVersionedHash", "commitment", "hashMessage", "message", "hmacSha512", "key", "input", "keccak256", "data", "sha256ripe160", "ethers-crypto"})
public final class Hashing {
    @NotNull
    public static final Hashing INSTANCE = new Hashing();
    @NotNull
    private static final byte[] MESSAGE_PREFIX;
    private static final byte VERSIONED_HASH_VERSION_KZG = 1;

    private Hashing() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] hashMessage(@NotNull byte[] message) {
        String string = String.valueOf(message.length);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] messageSizeString = byArray;
        byte[] input = new byte[MESSAGE_PREFIX.length + messageSizeString.length + message.length];
        System.arraycopy(MESSAGE_PREFIX, 0, input, 0, MESSAGE_PREFIX.length);
        System.arraycopy(messageSizeString, 0, input, MESSAGE_PREFIX.length, messageSizeString.length);
        System.arraycopy(message, 0, input, MESSAGE_PREFIX.length + messageSizeString.length, message.length);
        return new Keccak.Digest256().digest(input);
    }

    @JvmStatic
    @NotNull
    public static final byte[] keccak256(@NotNull byte[] data) {
        return new Keccak.Digest256().digest(data);
    }

    @JvmStatic
    @NotNull
    public static final byte[] hmacSha512(@NotNull byte[] key, @NotNull byte[] input) {
        byte[] out = new byte[64];
        HMac $this$hmacSha512_u24lambda_u240 = new HMac((Digest)new SHA512Digest());
        boolean bl = false;
        $this$hmacSha512_u24lambda_u240.init((CipherParameters)new KeyParameter(key));
        $this$hmacSha512_u24lambda_u240.update(input, 0, input.length);
        $this$hmacSha512_u24lambda_u240.doFinal(out, 0);
        return out;
    }

    @NotNull
    public final byte[] sha256ripe160(@NotNull byte[] input) {
        byte[] out = new byte[20];
        RIPEMD160Digest $this$sha256ripe160_u24lambda_u241 = new RIPEMD160Digest();
        boolean bl = false;
        byte[] sha256 = new SHA256.Digest().digest(input);
        $this$sha256ripe160_u24lambda_u241.update(sha256, 0, sha256.length);
        $this$sha256ripe160_u24lambda_u241.doFinal(out, 0);
        return out;
    }

    @JvmStatic
    @NotNull
    public static final byte[] blobVersionedHash(@NotNull byte[] commitment) {
        byte[] hash = new SHA256.Digest().digest(commitment);
        hash[0] = 1;
        return hash;
    }

    static {
        String string = "\u0019Ethereum Signed Message:\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        MESSAGE_PREFIX = byArray;
    }
}

