/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto;

import io.ethers.crypto.ECDSASignerRecoverableKt;
import java.math.BigInteger;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DSAExt;
import org.bouncycastle.crypto.constraints.ConstraintUtils;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.RandomDSAKCalculator;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0004J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\b\u0010 \u001a\u00020\fH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010\nH\u0004J \u0010)\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/ethers/crypto/ECDSASignerRecoverable;", "Lorg/bouncycastle/math/ec/ECConstants;", "Lorg/bouncycastle/crypto/DSAExt;", "()V", "kCalculator", "Lorg/bouncycastle/crypto/signers/DSAKCalculator;", "(Lorg/bouncycastle/crypto/signers/DSAKCalculator;)V", "key", "Lorg/bouncycastle/crypto/params/ECKeyParameters;", "random", "Ljava/security/SecureRandom;", "calculateE", "Ljava/math/BigInteger;", "n", "message", "", "createBasePointMultiplier", "Lorg/bouncycastle/math/ec/ECMultiplier;", "generateSignature", "", "([B)[Ljava/math/BigInteger;", "generateSignatureInternal", "includeY", "", "([BZ)[Ljava/math/BigInteger;", "generateSignatureWithY", "getDenominator", "Lorg/bouncycastle/math/ec/ECFieldElement;", "coordinateSystem", "", "p", "Lorg/bouncycastle/math/ec/ECPoint;", "getOrder", "init", "", "forSigning", "param", "Lorg/bouncycastle/crypto/CipherParameters;", "initSecureRandom", "needed", "provided", "verifySignature", "r", "s", "ethers-crypto"})
public final class ECDSASignerRecoverable
implements ECConstants,
DSAExt {
    @NotNull
    private final DSAKCalculator kCalculator;
    @Nullable
    private ECKeyParameters key;
    @Nullable
    private SecureRandom random;

    public ECDSASignerRecoverable() {
        this.kCalculator = (DSAKCalculator)new RandomDSAKCalculator();
    }

    public ECDSASignerRecoverable(@NotNull DSAKCalculator kCalculator) {
        this.kCalculator = kCalculator;
    }

    public void init(boolean forSigning, @NotNull CipherParameters param) {
        SecureRandom providedRandom = null;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                CipherParameters rParam = param;
                CipherParameters cipherParameters = ((ParametersWithRandom)rParam).getParameters();
                Intrinsics.checkNotNull((Object)cipherParameters, (String)"null cannot be cast to non-null type org.bouncycastle.crypto.params.ECPrivateKeyParameters");
                this.key = (ECKeyParameters)((ECPrivateKeyParameters)cipherParameters);
                providedRandom = ((ParametersWithRandom)rParam).getRandom();
            } else {
                Intrinsics.checkNotNull((Object)param, (String)"null cannot be cast to non-null type org.bouncycastle.crypto.params.ECPrivateKeyParameters");
                this.key = (ECKeyParameters)((ECPrivateKeyParameters)param);
            }
        } else {
            Intrinsics.checkNotNull((Object)param, (String)"null cannot be cast to non-null type org.bouncycastle.crypto.params.ECPublicKeyParameters");
            this.key = (ECKeyParameters)((ECPublicKeyParameters)param);
        }
        ECKeyParameters eCKeyParameters = this.key;
        Intrinsics.checkNotNull((Object)eCKeyParameters);
        DefaultServiceProperties props = new DefaultServiceProperties("ECDSA", ConstraintUtils.bitsOfSecurityFor((ECCurve)eCKeyParameters.getParameters().getCurve()), (Object)this.key, forSigning ? CryptoServicePurpose.SIGNING : CryptoServicePurpose.VERIFYING);
        CryptoServicesRegistrar.checkConstraints((CryptoServiceProperties)((CryptoServiceProperties)props));
        this.random = this.initSecureRandom(forSigning && !this.kCalculator.isDeterministic(), providedRandom);
    }

    @NotNull
    public BigInteger getOrder() {
        ECKeyParameters eCKeyParameters = this.key;
        Intrinsics.checkNotNull((Object)eCKeyParameters);
        return eCKeyParameters.getParameters().getN();
    }

    @NotNull
    public BigInteger[] generateSignature(@NotNull byte[] message) {
        return this.generateSignatureInternal(message, false);
    }

    @NotNull
    public final BigInteger[] generateSignatureWithY(@NotNull byte[] message) {
        return this.generateSignatureInternal(message, true);
    }

    private final BigInteger[] generateSignatureInternal(byte[] message, boolean includeY) {
        BigInteger[] bigIntegerArray;
        BigInteger k;
        ECKeyParameters eCKeyParameters = this.key;
        Intrinsics.checkNotNull((Object)eCKeyParameters);
        ECDomainParameters ec = eCKeyParameters.getParameters();
        BigInteger n = ec.getN();
        BigInteger e = this.calculateE(n, message);
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)this.key;
        Intrinsics.checkNotNull((Object)eCPrivateKeyParameters);
        BigInteger d = eCPrivateKeyParameters.getD();
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(n, d, message);
        } else {
            this.kCalculator.init(n, this.random);
        }
        BigInteger r = null;
        BigInteger s = null;
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        ECPoint p = null;
        do {
            k = null;
            do {
                k = this.kCalculator.nextK();
            } while (Intrinsics.areEqual((Object)(r = (p = basePointMultiplier.multiply(ec.getG(), k).normalize()).getAffineXCoord().toBigInteger().mod(n)), (Object)ECConstants.ZERO));
        } while (Intrinsics.areEqual((Object)(s = BigIntegers.modOddInverse((BigInteger)n, (BigInteger)k).multiply(e.add(d.multiply(r))).mod(n)), (Object)ECConstants.ZERO));
        if (includeY) {
            bigIntegerArray = new BigInteger[3];
            bigIntegerArray[0] = r;
            bigIntegerArray[1] = s;
            ECPoint eCPoint = p;
            Intrinsics.checkNotNull((Object)eCPoint);
            bigIntegerArray[2] = eCPoint.getAffineYCoord().toBigInteger();
            return bigIntegerArray;
        }
        bigIntegerArray = new BigInteger[]{r, s};
        return bigIntegerArray;
    }

    public boolean verifySignature(@NotNull byte[] message, @NotNull BigInteger r, @NotNull BigInteger s) {
        ECFieldElement D;
        BigInteger cofactor;
        BigInteger r2 = r;
        ECKeyParameters eCKeyParameters = this.key;
        Intrinsics.checkNotNull((Object)eCKeyParameters);
        ECDomainParameters ec = eCKeyParameters.getParameters();
        BigInteger n = ec.getN();
        BigInteger e = this.calculateE(n, message);
        if (r2.compareTo(ECConstants.ONE) < 0 || r2.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ECConstants.ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger c = BigIntegers.modOddInverseVar((BigInteger)n, (BigInteger)s);
        BigInteger u1 = e.multiply(c).mod(n);
        BigInteger u2 = r2.multiply(c).mod(n);
        ECPoint G = ec.getG();
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)this.key;
        Intrinsics.checkNotNull((Object)eCPublicKeyParameters);
        ECPoint Q = eCPublicKeyParameters.getQ();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies((ECPoint)G, (BigInteger)u1, (ECPoint)Q, (BigInteger)u2);
        if (point.isInfinity()) {
            return false;
        }
        ECCurve curve = point.getCurve();
        if (curve != null && (cofactor = curve.getCofactor()) != null && cofactor.compareTo(ECConstants.EIGHT) <= 0 && (D = this.getDenominator(curve.getCoordinateSystem(), point)) != null && !D.isZero()) {
            ECFieldElement X = point.getXCoord();
            while (curve.isValidFieldElement(r2)) {
                ECFieldElement R = curve.fromBigInteger(r2).multiply(D);
                if (Intrinsics.areEqual((Object)R, (Object)X)) {
                    return true;
                }
                r2 = r2.add(n);
            }
            return false;
        }
        BigInteger v = point.normalize().getAffineXCoord().toBigInteger().mod(n);
        return Intrinsics.areEqual((Object)v, (Object)r2);
    }

    @NotNull
    protected final BigInteger calculateE(@NotNull BigInteger n, @NotNull byte[] message) {
        int log2n = n.bitLength();
        int messageBitLength = message.length * 8;
        BigInteger e = new BigInteger(1, message);
        if (log2n < messageBitLength) {
            e = e.shiftRight(messageBitLength - log2n);
        }
        return e;
    }

    @NotNull
    protected final ECMultiplier createBasePointMultiplier() {
        return (ECMultiplier)ECDSASignerRecoverableKt.access$getMULTIPLIER$p();
    }

    @Nullable
    protected final ECFieldElement getDenominator(int coordinateSystem, @NotNull ECPoint p) {
        ECFieldElement eCFieldElement;
        switch (coordinateSystem) {
            case 1: 
            case 6: 
            case 7: {
                eCFieldElement = p.getZCoord(0);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                eCFieldElement = p.getZCoord(0).square();
                break;
            }
            default: {
                eCFieldElement = null;
            }
        }
        return eCFieldElement;
    }

    @Nullable
    protected final SecureRandom initSecureRandom(boolean needed, @Nullable SecureRandom provided) {
        return needed ? CryptoServicesRegistrar.getSecureRandom((SecureRandom)provided) : null;
    }
}

