/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/ethers/crypto/Base58;", "", "()V", "ALPHABET", "", "INDEXES", "", "copyOfRange", "", "source", "from", "", "to", "decode", "input", "", "decodeChecked", "decodeToBigInteger", "Ljava/math/BigInteger;", "divmod256", "", "number58", "startAt", "divmod58", "number", "doubleDigest", "encode", "ethers-crypto"})
@SourceDebugExtension(value={"SMAP\nBase58.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base58.kt\nio/ethers/crypto/Base58\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1#2:198\n*E\n"})
public final class Base58 {
    @NotNull
    public static final Base58 INSTANCE;
    @NotNull
    private static final char[] ALPHABET;
    @NotNull
    private static final int[] INDEXES;

    private Base58() {
    }

    @NotNull
    public final String encode(@NotNull byte[] input) {
        int zeroCount;
        byte[] input2 = input;
        if (input2.length == 0) {
            return "";
        }
        input2 = this.copyOfRange(input2, 0, input2.length);
        for (zeroCount = 0; zeroCount < input2.length && input2[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input2.length * 2];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input2.length) {
            byte mod = this.divmod58(input2, startAt);
            if (input2[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = (byte)ALPHABET[mod];
        }
        while (j < temp.length && temp[j] == (byte)ALPHABET[0]) {
            ++j;
        }
        while (--zeroCount >= 0) {
            temp[--j] = (byte)ALPHABET[0];
        }
        byte[] output = this.copyOfRange(temp, j, temp.length);
        return new String(output, StandardCharsets.US_ASCII);
    }

    @NotNull
    public final byte[] decode(@NotNull String input) {
        int zeroCount;
        if (((CharSequence)input).length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char c = input.charAt(i);
            int digit58 = -1;
            char c2 = c;
            boolean bl = '\u0000' <= c2 ? c2 < '\u0080' : false;
            if (bl) {
                digit58 = INDEXES[c];
            }
            if (!(digit58 >= 0)) {
                boolean bl2 = false;
                String string = "Illegal character " + c + " at " + i;
                throw new IllegalArgumentException(string.toString());
            }
            input58[i] = (byte)digit58;
        }
        for (zeroCount = 0; zeroCount < input58.length && input58[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length()];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input58.length) {
            byte mod = this.divmod256(input58, startAt);
            if (input58[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = mod;
        }
        while (j < temp.length && temp[j] == 0) {
            ++j;
        }
        return this.copyOfRange(temp, j - zeroCount, temp.length);
    }

    @NotNull
    public final BigInteger decodeToBigInteger(@NotNull String input) {
        return new BigInteger(1, this.decode(input));
    }

    @NotNull
    public final byte[] decodeChecked(@NotNull String input) {
        byte[] hash;
        byte[] tmp = this.decode(input);
        if (!(tmp.length >= 4)) {
            boolean $i$a$-require-Base58$decodeChecked$22 = false;
            String $i$a$-require-Base58$decodeChecked$22 = "Input to short";
            throw new IllegalArgumentException($i$a$-require-Base58$decodeChecked$22.toString());
        }
        byte[] bytes = this.copyOfRange(tmp, 0, tmp.length - 4);
        byte[] checksum = this.copyOfRange(tmp, tmp.length - 4, tmp.length);
        if (!Arrays.equals(checksum, hash = this.copyOfRange(tmp = this.doubleDigest(bytes), 0, 4))) {
            throw new RuntimeException("Checksum does not validate");
        }
        return bytes;
    }

    private final byte[] doubleDigest(byte[] input) {
        SHA256.Digest digest = new SHA256.Digest();
        digest.reset();
        digest.update(input);
        byte[] first = digest.digest();
        return digest.digest(first);
    }

    private final byte divmod58(byte[] number, int startAt) {
        int remainder = 0;
        int n = number.length;
        for (int i = startAt; i < n; ++i) {
            int digit256 = number[i] & 0xFF;
            int temp = remainder * 256 + digit256;
            number[i] = (byte)(temp / 58);
            remainder = temp % 58;
        }
        return (byte)remainder;
    }

    private final byte divmod256(byte[] number58, int startAt) {
        int remainder = 0;
        int n = number58.length;
        for (int i = startAt; i < n; ++i) {
            int digit58 = number58[i] & 0xFF;
            int temp = remainder * 58 + digit58;
            number58[i] = (byte)(temp / 256);
            remainder = temp % 256;
        }
        return (byte)remainder;
    }

    private final byte[] copyOfRange(byte[] source, int from, int to) {
        byte[] range = new byte[to - from];
        System.arraycopy(source, from, range, 0, range.length);
        return range;
    }

    static {
        int i;
        INSTANCE = new Base58();
        char[] cArray = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        ALPHABET = cArray;
        INDEXES = new int[128];
        int n = INDEXES.length;
        for (i = 0; i < n; ++i) {
            Base58.INDEXES[i] = -1;
        }
        n = ALPHABET.length;
        for (i = 0; i < n; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

