/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abigen.reader;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.ethers.abigen.JsonAbi;
import io.ethers.abigen.JsonAbiItem;
import io.ethers.abigen.reader.JsonAbiReader;
import io.ethers.core.Jackson;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lio/ethers/abigen/reader/FoundryAbiReader;", "Lio/ethers/abigen/reader/JsonAbiReader;", "()V", "read", "Lio/ethers/abigen/JsonAbi;", "abi", "Ljava/net/URL;", "Artifact", "ethers-abigen"})
public final class FoundryAbiReader
implements JsonAbiReader {
    @NotNull
    public static final FoundryAbiReader INSTANCE = new FoundryAbiReader();

    private FoundryAbiReader() {
    }

    @Override
    @NotNull
    public JsonAbi read(@NotNull URL abi) {
        Artifact artifact = (Artifact)Jackson.MAPPER.readValue(abi, Artifact.class);
        Artifact.Bytecode bytecode = artifact.getBytecode();
        return new JsonAbi(artifact.getAbi(), bytecode != null ? bytecode.getObject() : null);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0083\b\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J%\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/ethers/abigen/reader/FoundryAbiReader$Artifact;", "", "abi", "", "Lio/ethers/abigen/JsonAbiItem;", "bytecode", "Lio/ethers/abigen/reader/FoundryAbiReader$Artifact$Bytecode;", "(Ljava/util/List;Lio/ethers/abigen/reader/FoundryAbiReader$Artifact$Bytecode;)V", "getAbi", "()Ljava/util/List;", "getBytecode", "()Lio/ethers/abigen/reader/FoundryAbiReader$Artifact$Bytecode;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Bytecode", "ethers-abigen"})
    private static final class Artifact {
        @NotNull
        private final List<JsonAbiItem> abi;
        @Nullable
        private final Bytecode bytecode;

        public Artifact(@NotNull List<JsonAbiItem> abi, @Nullable Bytecode bytecode) {
            this.abi = abi;
            this.bytecode = bytecode;
        }

        @NotNull
        public final List<JsonAbiItem> getAbi() {
            return this.abi;
        }

        @Nullable
        public final Bytecode getBytecode() {
            return this.bytecode;
        }

        @NotNull
        public final List<JsonAbiItem> component1() {
            return this.abi;
        }

        @Nullable
        public final Bytecode component2() {
            return this.bytecode;
        }

        @NotNull
        public final Artifact copy(@NotNull List<JsonAbiItem> abi, @Nullable Bytecode bytecode) {
            return new Artifact(abi, bytecode);
        }

        public static /* synthetic */ Artifact copy$default(Artifact artifact, List list, Bytecode bytecode, int n, Object object) {
            if ((n & 1) != 0) {
                list = artifact.abi;
            }
            if ((n & 2) != 0) {
                bytecode = artifact.bytecode;
            }
            return artifact.copy(list, bytecode);
        }

        @NotNull
        public String toString() {
            return "Artifact(abi=" + this.abi + ", bytecode=" + this.bytecode + ")";
        }

        public int hashCode() {
            int result = ((Object)this.abi).hashCode();
            result = result * 31 + (this.bytecode == null ? 0 : this.bytecode.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Artifact)) {
                return false;
            }
            Artifact artifact = (Artifact)other;
            if (!Intrinsics.areEqual(this.abi, artifact.abi)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.bytecode, (Object)artifact.bytecode);
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/ethers/abigen/reader/FoundryAbiReader$Artifact$Bytecode;", "", "object", "", "(Ljava/lang/String;)V", "getObject", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "ethers-abigen"})
        public static final class Bytecode {
            @NotNull
            private final String object;

            public Bytecode(@NotNull String object) {
                this.object = object;
            }

            @NotNull
            public final String getObject() {
                return this.object;
            }

            @NotNull
            public final String component1() {
                return this.object;
            }

            @NotNull
            public final Bytecode copy(@NotNull String object) {
                return new Bytecode(object);
            }

            public static /* synthetic */ Bytecode copy$default(Bytecode bytecode, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = bytecode.object;
                }
                return bytecode.copy(string);
            }

            @NotNull
            public String toString() {
                return "Bytecode(object=" + this.object + ")";
            }

            public int hashCode() {
                return this.object.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Bytecode)) {
                    return false;
                }
                Bytecode bytecode = (Bytecode)other;
                return Intrinsics.areEqual((Object)this.object, (Object)bytecode.object);
            }
        }
    }
}

