/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abigen;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.ethers.abigen.JsonAbiConstructor;
import io.ethers.abigen.JsonAbiError;
import io.ethers.abigen.JsonAbiEvent;
import io.ethers.abigen.JsonAbiFallback;
import io.ethers.abigen.JsonAbiFunction;
import io.ethers.abigen.JsonAbiItem;
import io.ethers.abigen.JsonAbiReceive;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J%\u0010\"\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006)"}, d2={"Lio/ethers/abigen/JsonAbi;", "", "abi", "", "Lio/ethers/abigen/JsonAbiItem;", "bytecode", "", "(Ljava/util/List;Ljava/lang/String;)V", "getBytecode", "()Ljava/lang/String;", "constructor", "Lio/ethers/abigen/JsonAbiConstructor;", "getConstructor", "()Lio/ethers/abigen/JsonAbiConstructor;", "errors", "Lio/ethers/abigen/JsonAbiError;", "getErrors", "()Ljava/util/List;", "events", "Lio/ethers/abigen/JsonAbiEvent;", "getEvents", "fallback", "Lio/ethers/abigen/JsonAbiFallback;", "getFallback", "()Lio/ethers/abigen/JsonAbiFallback;", "functions", "Lio/ethers/abigen/JsonAbiFunction;", "getFunctions", "receive", "Lio/ethers/abigen/JsonAbiReceive;", "getReceive", "()Lio/ethers/abigen/JsonAbiReceive;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ethers-abigen"})
@SourceDebugExtension(value={"SMAP\nJsonAbi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonAbi.kt\nio/ethers/abigen/JsonAbi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1855#2,2:143\n*S KotlinDebug\n*F\n+ 1 JsonAbi.kt\nio/ethers/abigen/JsonAbi\n*L\n25#1:143,2\n*E\n"})
public final class JsonAbi {
    @NotNull
    private final List<JsonAbiItem> abi;
    @Nullable
    private final String bytecode;
    @NotNull
    private final List<JsonAbiFunction> functions;
    @NotNull
    private final List<JsonAbiEvent> events;
    @NotNull
    private final List<JsonAbiError> errors;
    @Nullable
    private final JsonAbiConstructor constructor;
    @Nullable
    private final JsonAbiReceive receive;
    @Nullable
    private final JsonAbiFallback fallback;

    public JsonAbi(@NotNull List<JsonAbiItem> abi, @Nullable String bytecode) {
        this.abi = abi;
        this.bytecode = bytecode;
        ArrayList<JsonAbiFunction> functions = new ArrayList<JsonAbiFunction>();
        ArrayList<JsonAbiEvent> events = new ArrayList<JsonAbiEvent>();
        ArrayList<JsonAbiError> errors = new ArrayList<JsonAbiError>();
        JsonAbiConstructor constructor = null;
        JsonAbiReceive receive = null;
        JsonAbiFallback fallback = null;
        Iterable $this$forEach$iv = this.abi;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonAbiItem it = (JsonAbiItem)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                case 1: {
                    String string = it.getName();
                    Intrinsics.checkNotNull((Object)string);
                    List<JsonAbiItem.Component> list = it.getInputs();
                    Intrinsics.checkNotNull(list);
                    List<JsonAbiItem.Component> list2 = it.getOutputs();
                    Intrinsics.checkNotNull(list2);
                    functions.add(new JsonAbiFunction(string, list, list2, it.isPayable(), it.isReadOnly()));
                    break;
                }
                case 2: {
                    String string = it.getName();
                    Intrinsics.checkNotNull((Object)string);
                    List<JsonAbiItem.Component> list = it.getInputs();
                    Intrinsics.checkNotNull(list);
                    Boolean bl2 = it.getAnonymous();
                    Intrinsics.checkNotNull((Object)bl2);
                    events.add(new JsonAbiEvent(string, list, bl2));
                    break;
                }
                case 3: {
                    String string = it.getName();
                    Intrinsics.checkNotNull((Object)string);
                    List<JsonAbiItem.Component> list = it.getInputs();
                    Intrinsics.checkNotNull(list);
                    errors.add(new JsonAbiError(string, list));
                    break;
                }
                case 4: {
                    List<JsonAbiItem.Component> list = it.getInputs();
                    Intrinsics.checkNotNull(list);
                    constructor = new JsonAbiConstructor(list, it.isPayable());
                    break;
                }
                case 5: {
                    receive = JsonAbiReceive.INSTANCE;
                    break;
                }
                case 6: {
                    fallback = new JsonAbiFallback(it.isPayable());
                }
            }
        }
        this.functions = functions;
        this.events = events;
        this.errors = errors;
        this.constructor = constructor;
        this.receive = receive;
        this.fallback = fallback;
    }

    public /* synthetic */ JsonAbi(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(list, string);
    }

    @Nullable
    public final String getBytecode() {
        return this.bytecode;
    }

    @NotNull
    public final List<JsonAbiFunction> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final List<JsonAbiEvent> getEvents() {
        return this.events;
    }

    @NotNull
    public final List<JsonAbiError> getErrors() {
        return this.errors;
    }

    @Nullable
    public final JsonAbiConstructor getConstructor() {
        return this.constructor;
    }

    @Nullable
    public final JsonAbiReceive getReceive() {
        return this.receive;
    }

    @Nullable
    public final JsonAbiFallback getFallback() {
        return this.fallback;
    }

    private final List<JsonAbiItem> component1() {
        return this.abi;
    }

    @Nullable
    public final String component2() {
        return this.bytecode;
    }

    @NotNull
    public final JsonAbi copy(@NotNull List<JsonAbiItem> abi, @Nullable String bytecode) {
        return new JsonAbi(abi, bytecode);
    }

    public static /* synthetic */ JsonAbi copy$default(JsonAbi jsonAbi, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = jsonAbi.abi;
        }
        if ((n & 2) != 0) {
            string = jsonAbi.bytecode;
        }
        return jsonAbi.copy(list, string);
    }

    @NotNull
    public String toString() {
        return "JsonAbi(abi=" + this.abi + ", bytecode=" + this.bytecode + ")";
    }

    public int hashCode() {
        int result = ((Object)this.abi).hashCode();
        result = result * 31 + (this.bytecode == null ? 0 : this.bytecode.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonAbi)) {
            return false;
        }
        JsonAbi jsonAbi = (JsonAbi)other;
        if (!Intrinsics.areEqual(this.abi, jsonAbi.abi)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bytecode, (Object)jsonAbi.bytecode);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonAbiItem.Type.values().length];
            try {
                nArray[JsonAbiItem.Type.FUNCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonAbiItem.Type.EVENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonAbiItem.Type.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonAbiItem.Type.CONSTRUCTOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonAbiItem.Type.RECEIVE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonAbiItem.Type.FALLBACK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

