/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abigen.plugin.task;

import io.ethers.abigen.AbiContractBuilder;
import io.ethers.abigen.JsonAbi;
import io.ethers.abigen.plugin.source.AbiSource;
import io.ethers.abigen.reader.JsonAbiReaderRegistry;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/ethers/abigen/plugin/task/AbigenWork;", "Lorg/gradle/workers/WorkAction;", "Lio/ethers/abigen/plugin/task/AbigenWork$Parameters;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "execute", "", "Parameters", "ethers-abigen-plugin"})
public abstract class AbigenWork
implements WorkAction<Parameters> {
    private final Logger logger = LoggerFactory.getLogger(AbigenWork.class);

    public void execute() {
        AbiSource source = (AbiSource)((Parameters)this.getParameters()).getAbi().get();
        JsonAbi abi = JsonAbiReaderRegistry.INSTANCE.readAbi(source.getAbiUrl());
        if (abi == null) {
            this.logger.error("Failed to read ABI from " + source.getAbiUrl());
            throw new GradleException("Failed to read ABI from " + source.getAbiUrl());
        }
        this.logger.info("Generating Kotlin wrapper for " + source.getContractName());
        String canonicalName = new AbiContractBuilder(source.getContractName(), source.getDestinationPackage(), (File)((Parameters)this.getParameters()).getDestination().get(), abi, (Map)((Parameters)this.getParameters()).getFunctionRenames().get()).build((String)((Parameters)this.getParameters()).getErrorLoaderName().get());
        FilesKt.writeText$default((File)((RegularFile)((Parameters)this.getParameters()).getCanonicalNameFile().get()).getAsFile(), (String)canonicalName, null, (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u001e\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lio/ethers/abigen/plugin/task/AbigenWork$Parameters;", "Lorg/gradle/workers/WorkParameters;", "abi", "Lorg/gradle/api/provider/Property;", "Lio/ethers/abigen/plugin/source/AbiSource;", "getAbi", "()Lorg/gradle/api/provider/Property;", "canonicalNameFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCanonicalNameFile", "()Lorg/gradle/api/file/RegularFileProperty;", "destination", "Ljava/io/File;", "getDestination", "errorLoaderName", "", "getErrorLoaderName", "functionRenames", "Lorg/gradle/api/provider/MapProperty;", "getFunctionRenames", "()Lorg/gradle/api/provider/MapProperty;", "ethers-abigen-plugin"})
    public static interface Parameters
    extends WorkParameters {
        @NotNull
        public Property<AbiSource> getAbi();

        @NotNull
        public Property<File> getDestination();

        @NotNull
        public MapProperty<String, String> getFunctionRenames();

        @NotNull
        public Property<String> getErrorLoaderName();

        @NotNull
        public RegularFileProperty getCanonicalNameFile();
    }
}

