/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.ContractEvent;
import io.ethers.abi.EventFactory;
import io.ethers.core.Result;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Log;
import io.ethers.core.types.LogFilter;
import io.ethers.core.types.Topic;
import io.ethers.providers.RpcError;
import io.ethers.providers.SubscriptionStream;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.FilterPoller;
import io.ethers.providers.types.RpcRequest;
import io.ethers.providers.types.RpcSubscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00002\u00020\u0004B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0011\u001a\u00028\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0002\u0010!J\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\"\u00a2\u0006\u0002\u0010#J\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0002\u0010$J\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020\"2\u0006\u0010 \u001a\u00020\"\u00a2\u0006\u0002\u0010%J\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020&2\u0006\u0010 \u001a\u00020&\u00a2\u0006\u0002\u0010'J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0015H\u0002J\u0018\u0010+\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0015\u0012\u0004\u0012\u00020-0,J\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020-0/J\u0013\u00100\u001a\u00028\u00012\u0006\u00101\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0013\u00100\u001a\u00028\u00012\u0006\u00101\u001a\u000202\u00a2\u0006\u0002\u00103J\u001f\u00100\u001a\u00028\u00012\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b04\"\u00020\u001b\u00a2\u0006\u0002\u00105J\u0013\u00106\u001a\u00028\u00012\u0006\u00101\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0013\u00106\u001a\u00028\u00012\u0006\u00101\u001a\u000202\u00a2\u0006\u0002\u00103J\u001f\u00106\u001a\u00028\u00012\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b04\"\u00020\u001b\u00a2\u0006\u0002\u00105J\u0013\u00107\u001a\u00028\u00012\u0006\u00101\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0013\u00107\u001a\u00028\u00012\u0006\u00101\u001a\u000202\u00a2\u0006\u0002\u00103J\u001f\u00107\u001a\u00028\u00012\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b04\"\u00020\u001b\u00a2\u0006\u0002\u00105J\u0018\u00108\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u000009\u0012\u0004\u0012\u00020-0,R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00028\u0001X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006:"}, d2={"Lio/ethers/abi/EventFilterBase;", "T", "Lio/ethers/abi/ContractEvent;", "F", "", "provider", "Lio/ethers/providers/middleware/Middleware;", "factory", "Lio/ethers/abi/EventFactory;", "(Lio/ethers/providers/middleware/Middleware;Lio/ethers/abi/EventFactory;)V", "filter", "Lio/ethers/core/types/LogFilter;", "getFilter", "()Lio/ethers/core/types/LogFilter;", "self", "getSelf", "()Lio/ethers/abi/EventFilterBase;", "address", "Lio/ethers/core/types/Address;", "(Lio/ethers/core/types/Address;)Lio/ethers/abi/EventFilterBase;", "addresses", "", "(Ljava/util/List;)Lio/ethers/abi/EventFilterBase;", "atBlock", "hash", "Lio/ethers/core/types/BlockId$Hash;", "(Lio/ethers/core/types/BlockId$Hash;)Lio/ethers/abi/EventFilterBase;", "Lio/ethers/core/types/Hash;", "(Lio/ethers/core/types/Hash;)Lio/ethers/abi/EventFilterBase;", "blockRange", "from", "Lio/ethers/core/types/BlockId$Name;", "to", "(Lio/ethers/core/types/BlockId$Name;Lio/ethers/core/types/BlockId$Name;)Lio/ethers/abi/EventFilterBase;", "Lio/ethers/core/types/BlockId$Number;", "(Lio/ethers/core/types/BlockId$Name;Lio/ethers/core/types/BlockId$Number;)Lio/ethers/abi/EventFilterBase;", "(Lio/ethers/core/types/BlockId$Number;Lio/ethers/core/types/BlockId$Name;)Lio/ethers/abi/EventFilterBase;", "(Lio/ethers/core/types/BlockId$Number;Lio/ethers/core/types/BlockId$Number;)Lio/ethers/abi/EventFilterBase;", "", "(JJ)Lio/ethers/abi/EventFilterBase;", "decodeMatchingLogs", "logs", "Lio/ethers/core/types/Log;", "query", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/providers/RpcError;", "subscribe", "Lio/ethers/providers/types/RpcSubscribe;", "topic1", "value", "Lio/ethers/core/types/Topic;", "(Lio/ethers/core/types/Topic;)Lio/ethers/abi/EventFilterBase;", "", "([Lio/ethers/core/types/Hash;)Lio/ethers/abi/EventFilterBase;", "topic2", "topic3", "watch", "Lio/ethers/providers/types/FilterPoller;", "ethers-abi"})
public abstract class EventFilterBase<T extends ContractEvent, F extends EventFilterBase<T, F>> {
    @NotNull
    private final Middleware provider;
    @NotNull
    private final EventFactory<T> factory;
    @NotNull
    private final LogFilter filter;

    public EventFilterBase(@NotNull Middleware provider, @NotNull EventFactory<T> factory) {
        this.provider = provider;
        this.factory = factory;
        this.filter = new LogFilter();
    }

    @NotNull
    protected final LogFilter getFilter() {
        return this.filter;
    }

    @NotNull
    public final RpcRequest<FilterPoller<T>, RpcError> watch() {
        return this.provider.watchLogs(this.filter).map(arg_0 -> EventFilterBase.watch$lambda$0(this, arg_0));
    }

    @NotNull
    public final RpcSubscribe<T, RpcError> subscribe() {
        return this.provider.subscribeLogs(this.filter).map(arg_0 -> EventFilterBase.subscribe$lambda$3(this, arg_0));
    }

    @NotNull
    public final RpcRequest<List<T>, RpcError> query() {
        return this.provider.getLogs(this.filter).map(new Result.Transformer(this){
            final /* synthetic */ EventFilterBase<T, F> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final List<T> invoke(@NotNull List<Log> p0) {
                return EventFilterBase.access$decodeMatchingLogs(this.$tmp0, p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, EventFilterBase.class, "decodeMatchingLogs", "decodeMatchingLogs(Ljava/util/List;)Ljava/util/List;", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Result.Transformer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    private final List<T> decodeMatchingLogs(List<Log> logs) {
        ArrayList<T> ret = new ArrayList<T>(logs.size());
        int n = logs.size();
        for (int i = 0; i < n; ++i) {
            T event;
            if (this.factory.decode(logs.get(i)) == null) continue;
            ret.add(event);
        }
        return ret;
    }

    @NotNull
    protected abstract F getSelf();

    @NotNull
    public final F blockRange(long from, long to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F blockRange(@NotNull BlockId.Number from, @NotNull BlockId.Number to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F blockRange(@NotNull BlockId.Name from, @NotNull BlockId.Name to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F blockRange(@NotNull BlockId.Number from, @NotNull BlockId.Name to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F blockRange(@NotNull BlockId.Name from, @NotNull BlockId.Number to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F atBlock(@NotNull Hash hash) {
        this.filter.atBlock(hash);
        return this.getSelf();
    }

    @NotNull
    public final F atBlock(@NotNull BlockId.Hash hash) {
        this.filter.atBlock(hash);
        return this.getSelf();
    }

    @NotNull
    public final F address(@NotNull Address address) {
        this.filter.address(address);
        return this.getSelf();
    }

    @NotNull
    public final F address(@NotNull List<Address> addresses) {
        this.filter.address(addresses);
        return this.getSelf();
    }

    @NotNull
    public final F topic1(@NotNull Hash value) {
        this.filter.topic1(value);
        return this.getSelf();
    }

    @NotNull
    public final F topic1(Hash ... value) {
        this.filter.topic1(Arrays.copyOf(value, value.length));
        return this.getSelf();
    }

    @NotNull
    public final F topic1(@NotNull Topic value) {
        this.filter.topic1(value);
        return this.getSelf();
    }

    @NotNull
    public final F topic2(@NotNull Hash value) {
        this.filter.topic2(value);
        return this.getSelf();
    }

    @NotNull
    public final F topic2(Hash ... value) {
        this.filter.topic2(Arrays.copyOf(value, value.length));
        return this.getSelf();
    }

    @NotNull
    public final F topic2(@NotNull Topic value) {
        this.filter.topic2(value);
        return this.getSelf();
    }

    @NotNull
    public final F topic3(@NotNull Hash value) {
        this.filter.topic3(value);
        return this.getSelf();
    }

    @NotNull
    public final F topic3(Hash ... value) {
        this.filter.topic3(Arrays.copyOf(value, value.length));
        return this.getSelf();
    }

    @NotNull
    public final F topic3(@NotNull Topic value) {
        this.filter.topic3(value);
        return this.getSelf();
    }

    private static final FilterPoller watch$lambda$0(EventFilterBase this$0, FilterPoller it) {
        return it.mapPoller(this$0::decodeMatchingLogs);
    }

    private static final ContractEvent subscribe$lambda$3$lambda$1(EventFilterBase this$0, Log it) {
        return this$0.factory.decode(it);
    }

    private static final boolean subscribe$lambda$3$lambda$2(ContractEvent it) {
        return it != null;
    }

    private static final SubscriptionStream subscribe$lambda$3(EventFilterBase this$0, SubscriptionStream stream) {
        SubscriptionStream subscriptionStream = stream.map(arg_0 -> EventFilterBase.subscribe$lambda$3$lambda$1(this$0, arg_0)).filter(EventFilterBase::subscribe$lambda$3$lambda$2);
        Intrinsics.checkNotNull((Object)subscriptionStream, (String)"null cannot be cast to non-null type io.ethers.providers.SubscriptionStream<T of io.ethers.abi.EventFilterBase.subscribe$lambda$3>");
        return subscriptionStream;
    }

    public static final /* synthetic */ List access$decodeMatchingLogs(EventFilterBase $this, List logs) {
        return $this.decodeMatchingLogs(logs);
    }
}

