/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.AbiCodecKt;
import io.ethers.abi.AbiType;
import io.ethers.abi.Utf8;
import io.ethers.core.FastHex;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J)\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J)\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0012J1\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0007J+\u0010\u0016\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\bH\u0007\u00a2\u0006\u0002\u0010\u0017J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J+\u0010\u0018\u001a\u00020\u001c2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\bH\u0007\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J \u0010 \u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002J3\u0010!\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\"\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010#J9\u0010!\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\"\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010$J3\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\bH\u0007\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002J\u0018\u0010)\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002J#\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010-J \u0010.\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JJ\u0010/\u001a\u0002H0\"\u0004\b\u0000\u001002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H002H\u0082\b\u00a2\u0006\u0002\u00103\u00a8\u00064"}, d2={"Lio/ethers/abi/AbiCodec;", "", "()V", "decode", "type", "Lio/ethers/abi/AbiType;", "data", "", "", "types", "", "(Ljava/util/List;[B)[Ljava/lang/Object;", "decodeToken", "buff", "Ljava/nio/ByteBuffer;", "currOffset", "", "decodeTokens", "(Ljava/util/List;Ljava/nio/ByteBuffer;)[Ljava/lang/Object;", "decodeWithPrefix", "prefixSize", "(ILjava/util/List;[B)[Ljava/lang/Object;", "encode", "(Ljava/util/List;[Ljava/lang/Object;)[B", "encodePacked", "", "inArray", "", "Lio/ethers/core/types/Bytes;", "(Ljava/util/List;[Ljava/lang/Object;)Lio/ethers/core/types/Bytes;", "encodeTokenHead", "headOffset", "encodeTokenTail", "encodeTokensHeadTail", "headLength", "(Ljava/nio/ByteBuffer;Lio/ethers/abi/AbiType;[Ljava/lang/Object;I)V", "(Ljava/nio/ByteBuffer;Ljava/util/List;[Ljava/lang/Object;I)V", "encodeWithPrefix", "prefix", "([BLjava/util/List;[Ljava/lang/Object;)[B", "getTokenHeadLength", "getTokenTailLength", "getTypedArrayForElementType", "elementType", "size", "(Lio/ethers/abi/AbiType;I)[Ljava/lang/Object;", "packEncodedSize", "withHeadTailLengths", "R", "consumer", "Lkotlin/Function2;", "(Ljava/util/List;[Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "ethers-abi"})
@SourceDebugExtension(value={"SMAP\nAbiCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiCodec.kt\nio/ethers/abi/AbiCodec\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,836:1\n373#1,7:837\n373#1,7:844\n26#2:851\n*S KotlinDebug\n*F\n+ 1 AbiCodec.kt\nio/ethers/abi/AbiCodec\n*L\n32#1:837,7\n68#1:844,7\n95#1:851\n*E\n"})
public final class AbiCodec {
    @NotNull
    public static final AbiCodec INSTANCE = new AbiCodec();

    private AbiCodec() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] encodeWithPrefix(@NotNull byte[] prefix, @NotNull List<? extends AbiType> types, @NotNull Object[] data) {
        void tail;
        if (types.isEmpty()) {
            return prefix;
        }
        if (types.size() != data.length) {
            throw new IllegalArgumentException("Expected " + types.size() + " arguments, got " + data.length);
        }
        AbiCodec this_$iv = INSTANCE;
        boolean $i$f$withHeadTailLengths = false;
        int head$iv = 0;
        int tail$iv = 0;
        int n = types.size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            head$iv += this_$iv.getTokenHeadLength(types.get(i$iv), data[i$iv]);
            tail$iv += this_$iv.getTokenTailLength(types.get(i$iv), data[i$iv]);
        }
        int n2 = tail$iv;
        int head = head$iv;
        boolean bl = false;
        ByteBuffer ret = ByteBuffer.allocate(prefix.length + head + tail);
        ret.put(prefix);
        INSTANCE.encodeTokensHeadTail(ret, types, data, head);
        return ret.array();
    }

    @JvmStatic
    @NotNull
    public static final byte[] encode(@NotNull AbiType type, @NotNull Object data) {
        int head = INSTANCE.getTokenHeadLength(type, data);
        int tail = INSTANCE.getTokenTailLength(type, data);
        ByteBuffer ret = ByteBuffer.allocate(head + tail);
        INSTANCE.encodeTokenHead(ret, type, data, head);
        INSTANCE.encodeTokenTail(ret, type, data);
        return ret.array();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] encode(@NotNull List<? extends AbiType> types, @NotNull Object[] data) {
        void tail;
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Cannot encode empty tokens");
        }
        if (types.size() != data.length) {
            throw new IllegalArgumentException("Expected " + types.size() + " arguments, got " + data.length);
        }
        AbiCodec this_$iv = INSTANCE;
        boolean $i$f$withHeadTailLengths = false;
        int head$iv = 0;
        int tail$iv = 0;
        int n = types.size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            head$iv += this_$iv.getTokenHeadLength(types.get(i$iv), data[i$iv]);
            tail$iv += this_$iv.getTokenTailLength(types.get(i$iv), data[i$iv]);
        }
        int n2 = tail$iv;
        int head = head$iv;
        boolean bl = false;
        ByteBuffer ret = ByteBuffer.allocate(head + tail);
        INSTANCE.encodeTokensHeadTail(ret, types, data, head);
        return ret.array();
    }

    @JvmStatic
    @NotNull
    public static final Object[] decodeWithPrefix(int prefixSize, @NotNull List<? extends AbiType> types, @NotNull byte[] data) {
        if (data.length < prefixSize) {
            throw new IllegalArgumentException("Data is too short: " + data.length);
        }
        if (types.isEmpty() && data.length > prefixSize) {
            throw new IllegalArgumentException("Expected empty input, got: " + FastHex.encodeWithoutPrefix((byte[])data));
        }
        if (!((Collection)types).isEmpty() && data.length == prefixSize) {
            throw new IllegalArgumentException("Expected input, got empty data");
        }
        if (types.isEmpty()) {
            boolean $i$f$emptyArray = false;
            return new Object[0];
        }
        ByteBuffer buff = ByteBuffer.wrap(data).position(prefixSize);
        return INSTANCE.decodeTokens(types, buff);
    }

    @JvmStatic
    @NotNull
    public static final Object decode(@NotNull AbiType type, @NotNull byte[] data) {
        if (data.length < 32) {
            throw new IllegalArgumentException("Cannot decode empty data: " + FastHex.encodeWithoutPrefix((byte[])data));
        }
        ByteBuffer buff = ByteBuffer.wrap(data);
        return INSTANCE.decodeToken(type, buff, 0);
    }

    @JvmStatic
    @NotNull
    public static final Object[] decode(@NotNull List<? extends AbiType> types, @NotNull byte[] data) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Cannot decode empty tokens");
        }
        if (data.length < 32) {
            throw new IllegalArgumentException("Cannot decode empty data: " + FastHex.encodeWithoutPrefix((byte[])data));
        }
        ByteBuffer buff = ByteBuffer.wrap(data);
        return INSTANCE.decodeTokens(types, buff);
    }

    private final void encodeTokensHeadTail(ByteBuffer buff, List<? extends AbiType> types, Object[] data, int headLength) {
        int i;
        int headOffset = headLength;
        int n = types.size();
        for (i = 0; i < n; ++i) {
            this.encodeTokenHead(buff, types.get(i), data[i], headOffset);
            headOffset += this.getTokenTailLength(types.get(i), data[i]);
        }
        n = types.size();
        for (i = 0; i < n; ++i) {
            this.encodeTokenTail(buff, types.get(i), data[i]);
        }
    }

    private final void encodeTokensHeadTail(ByteBuffer buff, AbiType type, Object[] data, int headLength) {
        int i;
        int headOffset = headLength;
        int n = data.length;
        for (i = 0; i < n; ++i) {
            this.encodeTokenHead(buff, type, data[i], headOffset);
            headOffset += this.getTokenTailLength(type, data[i]);
        }
        n = data.length;
        for (i = 0; i < n; ++i) {
            this.encodeTokenTail(buff, type, data[i]);
        }
    }

    private final void encodeTokenHead(ByteBuffer buff, AbiType type, Object data, int headOffset) {
        block22: {
            AbiType abiType;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block21: {
                                abiType = type;
                                if (!Intrinsics.areEqual((Object)abiType, (Object)AbiType.Address.INSTANCE)) break block21;
                                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Address");
                                Address value = (Address)data;
                                buff.position(buff.position() + 12);
                                buff.put(value.getValue());
                                break block22;
                            }
                            if (!Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bool.INSTANCE)) break block23;
                            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Boolean");
                            boolean value = (Boolean)data;
                            buff.position(buff.position() + 31);
                            buff.put(value ? (byte)1 : 0);
                            break block22;
                        }
                        if (!(abiType instanceof AbiType.Int)) break block24;
                        Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type java.math.BigInteger");
                        BigInteger v = (BigInteger)data;
                        if (v.bitLength() > ((AbiType.Int)type).getBitSize() - 1) {
                            throw new IllegalArgumentException("Provided INT value has more than " + (((AbiType.Int)type).getBitSize() - 1) + " bits: " + v.bitLength());
                        }
                        if (v.signum() == -1) {
                            byte[] arr = v.toByteArray();
                            buff.put(AbiCodecKt.access$getTWOS_COMPLEMENT_PADDING$p()[32 - arr.length]);
                            buff.put(arr);
                            return;
                        }
                        byte[] arr = v.toByteArray();
                        if (arr.length == 33 && arr[0] == 0) {
                            buff.put(arr, 1, 32);
                        } else {
                            buff.position(buff.position() + (32 - arr.length));
                            buff.put(arr);
                        }
                        break block22;
                    }
                    if (!(abiType instanceof AbiType.UInt)) break block25;
                    Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type java.math.BigInteger");
                    BigInteger v = (BigInteger)data;
                    if (v.signum() == -1) {
                        throw new IllegalArgumentException("Expected UINT, got INT: " + v);
                    }
                    if (v.bitLength() > ((AbiType.UInt)type).getBitSize()) {
                        throw new IllegalArgumentException("Provided UINT value has more than " + ((AbiType.UInt)type).getBitSize() + " bits: " + v.bitLength());
                    }
                    byte[] arr = v.toByteArray();
                    if (arr.length > 33 || arr.length == 33 && arr[0] != 0) {
                        throw new IllegalArgumentException("Provided value has more than 256 bits: " + v);
                    }
                    if (arr.length == 33 && arr[0] == 0) {
                        buff.put(arr, 1, 32);
                    } else {
                        buff.position(buff.position() + (32 - arr.length));
                        buff.put(arr);
                    }
                    break block22;
                }
                if (!(abiType instanceof AbiType.FixedBytes)) break block26;
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
                Bytes value = (Bytes)data;
                if (value.getSize() != ((AbiType.FixedBytes)type).getLength()) {
                    throw new IllegalArgumentException("Provided value has length " + value.getSize() + ", expected " + ((AbiType.FixedBytes)type).getLength());
                }
                int rem = 32 - value.getValue().length;
                buff.put(value.getValue());
                if (rem <= 0) break block22;
                buff.position(buff.position() + rem);
                break block22;
            }
            if ((Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bytes.INSTANCE) ? true : Intrinsics.areEqual((Object)abiType, (Object)AbiType.String.INSTANCE)) ? true : abiType instanceof AbiType.Array) {
                buff.position(buff.position() + 28);
                buff.putInt(headOffset);
            } else if (abiType instanceof AbiType.FixedArray) {
                if (type.isDynamic()) {
                    buff.position(buff.position() + 28);
                    buff.putInt(headOffset);
                    return;
                }
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                Object[] value = (Object[])data;
                if (value.length != ((AbiType.FixedArray)type).getLength()) {
                    throw new IllegalArgumentException("Provided value has length " + value.length + ", expected " + ((AbiType.FixedArray)type).getLength());
                }
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    AbiType abiType2 = ((AbiType.FixedArray)type).getType();
                    Object object = value[i];
                    Intrinsics.checkNotNull((Object)object);
                    this.encodeTokenHead(buff, abiType2, object, headOffset);
                }
            } else if (abiType instanceof AbiType.Tuple) {
                if (type.isDynamic()) {
                    buff.position(buff.position() + 28);
                    buff.putInt(headOffset);
                    return;
                }
                Object[] value = ((AbiType.Tuple)type).dataAsTuple(data);
                if (value.length != ((AbiType.Tuple)type).getTypes().size()) {
                    throw new IllegalArgumentException("Provided value has length " + value.length + ", expected " + ((AbiType.Tuple)type).getTypes().size());
                }
                int n = ((AbiType.Tuple)type).getTypes().size();
                for (int i = 0; i < n; ++i) {
                    this.encodeTokenHead(buff, ((AbiType.Tuple)type).getTypes().get(i), value[i], headOffset);
                }
            }
        }
    }

    private final void encodeTokenTail(ByteBuffer buff, AbiType type, Object data) {
        AbiType abiType = type;
        if (!((((Intrinsics.areEqual((Object)abiType, (Object)AbiType.Address.INSTANCE) ? true : Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bool.INSTANCE)) ? true : abiType instanceof AbiType.Int) ? true : abiType instanceof AbiType.UInt) ? true : abiType instanceof AbiType.FixedBytes)) {
            if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bytes.INSTANCE)) {
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
                byte[] value = ((Bytes)data).getValue();
                buff.position(buff.position() + 28);
                buff.putInt(value.length);
                int numOfWords = (value.length + 32 - 1) / 32;
                for (int i = 0; i < numOfWords; ++i) {
                    int start = i * 32;
                    int end = Math.min(start + 32, value.length);
                    int length = end - start;
                    buff.put(value, start, length);
                    if (length >= 32) continue;
                    buff.position(buff.position() + (32 - length));
                }
            } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.String.INSTANCE)) {
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.String");
                byte[] byArray = ((String)data).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] value = byArray;
                buff.position(buff.position() + 28);
                buff.putInt(value.length);
                int numOfWords = (value.length + 32 - 1) / 32;
                for (int i = 0; i < numOfWords; ++i) {
                    int start = i * 32;
                    int end = Math.min(start + 32, value.length);
                    int length = end - start;
                    buff.put(value, start, length);
                    if (length >= 32) continue;
                    buff.position(buff.position() + (32 - length));
                }
            } else if (abiType instanceof AbiType.Array) {
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
                Object[] value = (Object[])data;
                buff.position(buff.position() + 28);
                buff.putInt(value.length);
                if (!(value.length == 0)) {
                    int headLength = 0;
                    int n = value.length;
                    for (int i = 0; i < n; ++i) {
                        headLength += this.getTokenHeadLength(((AbiType.Array)type).getType(), value[i]);
                    }
                    this.encodeTokensHeadTail(buff, ((AbiType.Array)type).getType(), value, headLength);
                }
            } else if (abiType instanceof AbiType.FixedArray) {
                if (!type.isDynamic()) {
                    return;
                }
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
                Object[] value = (Object[])data;
                if (value.length != ((AbiType.FixedArray)type).getLength()) {
                    throw new IllegalArgumentException("Provided value has length " + value.length + ", expected " + ((AbiType.FixedArray)type).getLength());
                }
                int headLength = 0;
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    headLength += this.getTokenHeadLength(((AbiType.FixedArray)type).getType(), value[i]);
                }
                this.encodeTokensHeadTail(buff, ((AbiType.FixedArray)type).getType(), value, headLength);
            } else if (abiType instanceof AbiType.Tuple) {
                if (!type.isDynamic()) {
                    return;
                }
                Object[] value = ((AbiType.Tuple)type).dataAsTuple(data);
                if (value.length != ((AbiType.Tuple)type).getTypes().size()) {
                    throw new IllegalArgumentException("Provided value has length " + value.length + ", expected " + ((AbiType.Tuple)type).getTypes().size());
                }
                int headLength = 0;
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    headLength += this.getTokenHeadLength(((AbiType.Tuple)type).getTypes().get(i), value[i]);
                }
                this.encodeTokensHeadTail(buff, ((AbiType.Tuple)type).getTypes(), value, headLength);
            }
        }
    }

    private final <R> R withHeadTailLengths(List<? extends AbiType> types, Object[] data, Function2<? super Integer, ? super Integer, ? extends R> consumer) {
        boolean $i$f$withHeadTailLengths = false;
        int head = 0;
        int tail = 0;
        int n = types.size();
        for (int i = 0; i < n; ++i) {
            head += this.getTokenHeadLength(types.get(i), data[i]);
            tail += this.getTokenTailLength(types.get(i), data[i]);
        }
        return (R)consumer.invoke((Object)head, (Object)tail);
    }

    private final int getTokenHeadLength(AbiType type, Object data) {
        int n;
        AbiType abiType = type;
        if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Address.INSTANCE)) {
            n = 32;
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bool.INSTANCE)) {
            n = 32;
        } else if (abiType instanceof AbiType.FixedBytes) {
            n = 32;
        } else if (abiType instanceof AbiType.Int ? true : abiType instanceof AbiType.UInt) {
            n = 32;
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bytes.INSTANCE)) {
            n = 32;
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.String.INSTANCE)) {
            n = 32;
        } else if (abiType instanceof AbiType.Array) {
            n = 32;
        } else if (abiType instanceof AbiType.FixedArray) {
            if (type.isDynamic()) {
                return 32;
            }
            int headLength = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            int n2 = values.length;
            for (int i = 0; i < n2; ++i) {
                AbiType abiType2 = ((AbiType.FixedArray)type).getType();
                Object object = ((Object[])data)[i];
                Intrinsics.checkNotNull((Object)object);
                headLength += this.getTokenHeadLength(abiType2, object);
            }
            n = headLength;
        } else if (abiType instanceof AbiType.Tuple) {
            if (type.isDynamic()) {
                return 32;
            }
            int headLength = 0;
            Object[] value = ((AbiType.Tuple)type).dataAsTuple(data);
            int n3 = ((AbiType.Tuple)type).getTypes().size();
            for (int i = 0; i < n3; ++i) {
                headLength += this.getTokenHeadLength(((AbiType.Tuple)type).getTypes().get(i), value[i]);
            }
            n = headLength;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final int getTokenTailLength(AbiType type, Object data) {
        int n;
        AbiType abiType = type;
        if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Address.INSTANCE)) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bool.INSTANCE)) {
            n = 0;
        } else if (abiType instanceof AbiType.FixedBytes) {
            n = 0;
        } else if (abiType instanceof AbiType.Int ? true : abiType instanceof AbiType.UInt) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bytes.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
            Bytes value = (Bytes)data;
            int numOfWords = (value.getValue().length + 32 - 1) / 32;
            n = 32 + numOfWords * 32;
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.String");
            int utf8Length = Utf8.INSTANCE.encodedLength((String)data);
            int numOfWords = (utf8Length + 32 - 1) / 32;
            n = 32 + numOfWords * 32;
        } else if (abiType instanceof AbiType.Array) {
            int length = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] value = (Object[])data;
            int n2 = value.length;
            for (int i = 0; i < n2; ++i) {
                Object v;
                Intrinsics.checkNotNull((Object)value[i]);
                length += this.getTokenHeadLength(((AbiType.Array)type).getType(), v) + this.getTokenTailLength(((AbiType.Array)type).getType(), v);
            }
            n = 32 + length;
        } else if (abiType instanceof AbiType.FixedArray) {
            if (!type.isDynamic()) {
                return 0;
            }
            int length = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] value = (Object[])data;
            int n3 = value.length;
            for (int i = 0; i < n3; ++i) {
                Object v;
                Intrinsics.checkNotNull((Object)value[i]);
                length += this.getTokenHeadLength(((AbiType.FixedArray)type).getType(), v) + this.getTokenTailLength(((AbiType.FixedArray)type).getType(), v);
            }
            n = length;
        } else if (abiType instanceof AbiType.Tuple) {
            if (!type.isDynamic()) {
                return 0;
            }
            int length = 0;
            Object[] value = ((AbiType.Tuple)type).dataAsTuple(data);
            int n4 = ((AbiType.Tuple)type).getTypes().size();
            for (int i = 0; i < n4; ++i) {
                Object v = value[i];
                length += this.getTokenHeadLength(((AbiType.Tuple)type).getTypes().get(i), v) + this.getTokenTailLength(((AbiType.Tuple)type).getTypes().get(i), v);
            }
            n = length;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final Object[] decodeTokens(List<? extends AbiType> types, ByteBuffer buff) {
        int offset = buff.position();
        Object[] ret = new Object[types.size()];
        int n = types.size();
        for (int i = 0; i < n; ++i) {
            ret[i] = this.decodeToken(types.get(i), buff, offset);
        }
        return ret;
    }

    private final Object decodeToken(AbiType type, ByteBuffer buff, int currOffset) {
        AbiType abiType = type;
        if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Address.INSTANCE)) {
            byte[] arr = new byte[20];
            AbiCodecKt.access$skip(buff, 12).get(arr);
            return new Address(arr);
        }
        if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bool.INSTANCE)) {
            return AbiCodecKt.access$skip(buff, 31).get() == 1;
        }
        if (abiType instanceof AbiType.FixedBytes) {
            byte[] arr = new byte[((AbiType.FixedBytes)type).getLength()];
            AbiCodecKt.access$skip(buff.get(arr), 32 - ((AbiType.FixedBytes)type).getLength());
            return new Bytes(arr);
        }
        if (abiType instanceof AbiType.Int) {
            byte[] arr = new byte[32];
            buff.get(arr);
            BigInteger v = new BigInteger(arr);
            if (v.bitLength() > ((AbiType.Int)type).getBitSize() - 1) {
                throw new IllegalArgumentException("Provided INT value has more than " + ((AbiType.Int)type).getBitSize() + " bits: " + v.bitLength());
            }
            return v;
        }
        if (abiType instanceof AbiType.UInt) {
            byte firstByte = buff.get();
            buff.position(buff.position() - 1);
            byte[] arr = null;
            if (firstByte != 0) {
                arr = new byte[33];
                buff.get(arr, 1, 32);
            } else {
                arr = new byte[32];
                buff.get(arr);
            }
            return new BigInteger(arr);
        }
        if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bytes.INSTANCE)) {
            int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
            int endPosition = buff.position();
            int length = AbiCodecKt.access$skip(buff.position(offset), 28).getInt();
            byte[] arr = new byte[length];
            buff.get(arr).position(endPosition);
            return new Bytes(arr);
        }
        if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.String.INSTANCE)) {
            int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
            int endPosition = buff.position();
            int length = AbiCodecKt.access$skip(buff.position(offset), 28).getInt();
            byte[] arr = new byte[length];
            buff.get(arr).position(endPosition);
            return new String(arr, Charsets.UTF_8);
        }
        if (abiType instanceof AbiType.Array) {
            int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
            int endPosition = buff.position();
            int length = AbiCodecKt.access$skip(buff.position(offset), 28).getInt();
            offset += 32;
            Object[] arr = this.getTypedArrayForElementType(((AbiType.Array)type).getType(), length);
            for (int i = 0; i < length; ++i) {
                arr[i] = this.decodeToken(((AbiType.Array)type).getType(), buff, offset);
            }
            buff.position(endPosition);
            return arr;
        }
        if (abiType instanceof AbiType.FixedArray) {
            Object[] arr = this.getTypedArrayForElementType(((AbiType.FixedArray)type).getType(), ((AbiType.FixedArray)type).getLength());
            if (type.isDynamic()) {
                int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
                int endPosition = buff.position();
                buff.position(offset);
                int n = ((AbiType.FixedArray)type).getLength();
                for (int i = 0; i < n; ++i) {
                    arr[i] = this.decodeToken(((AbiType.FixedArray)type).getType(), buff, offset);
                }
                buff.position(endPosition);
            } else {
                int endPosition = ((AbiType.FixedArray)type).getLength();
                for (int i = 0; i < endPosition; ++i) {
                    arr[i] = this.decodeToken(((AbiType.FixedArray)type).getType(), buff, currOffset);
                }
            }
            return arr;
        }
        if (abiType instanceof AbiType.Tuple) {
            Object[] arr = new Object[((AbiType.Tuple)type).getTypes().size()];
            if (type.isDynamic()) {
                int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
                int endPosition = buff.position();
                buff.position(offset);
                int n = arr.length;
                for (int i = 0; i < n; ++i) {
                    arr[i] = this.decodeToken(((AbiType.Tuple)type).getTypes().get(i), buff, offset);
                }
                buff.position(endPosition);
            } else {
                int n = arr.length;
                for (int i = 0; i < n; ++i) {
                    arr[i] = this.decodeToken(((AbiType.Tuple)type).getTypes().get(i), buff, currOffset);
                }
            }
            return ((AbiType.Tuple)type).getFactory().apply(arr);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final Object[] getTypedArrayForElementType(AbiType elementType, int size) {
        Object[] objectArray;
        AbiType abiType = elementType;
        if (abiType instanceof AbiType.Address) {
            objectArray = new Address[size];
        } else if (abiType instanceof AbiType.String) {
            objectArray = new String[size];
        } else if (abiType instanceof AbiType.FixedBytes ? true : abiType instanceof AbiType.Bytes) {
            objectArray = (Object[])new byte[size][];
        } else if (abiType instanceof AbiType.Int ? true : abiType instanceof AbiType.UInt) {
            objectArray = new BigInteger[size];
        } else if (abiType instanceof AbiType.Bool) {
            objectArray = new Boolean[size];
        } else if (abiType instanceof AbiType.FixedArray) {
            Object object = Array.newInstance(elementType.getClassType(), size);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            objectArray = (Object[])object;
        } else if (abiType instanceof AbiType.Array) {
            Object object = Array.newInstance(elementType.getClassType(), size);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            objectArray = (Object[])object;
        } else if (abiType instanceof AbiType.Tuple) {
            Object object = Array.newInstance(elementType.getClassType(), size);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            objectArray = (Object[])object;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return objectArray;
    }

    @JvmStatic
    @NotNull
    public static final Bytes encodePacked(@NotNull List<? extends AbiType> types, @NotNull Object[] data) {
        int encodedSize = 0;
        int n = types.size();
        for (int i = 0; i < n; ++i) {
            encodedSize += INSTANCE.packEncodedSize(types.get(i), data[i], false);
        }
        ByteBuffer ret = ByteBuffer.allocate(encodedSize);
        int n2 = types.size();
        for (int i = 0; i < n2; ++i) {
            INSTANCE.encodePacked(ret, types.get(i), data[i], false);
        }
        return new Bytes(ret.array());
    }

    private final int packEncodedSize(AbiType type, Object data, boolean inArray) {
        int n;
        AbiType abiType = type;
        if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Address.INSTANCE)) {
            n = inArray ? 32 : 20;
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bool.INSTANCE)) {
            n = inArray ? 32 : 1;
        } else if (abiType instanceof AbiType.FixedBytes) {
            n = inArray ? 32 : ((AbiType.FixedBytes)type).getLength();
        } else if (abiType instanceof AbiType.Int) {
            n = inArray ? 32 : ((AbiType.Int)type).getBitSize() / 8;
        } else if (abiType instanceof AbiType.UInt) {
            n = inArray ? 32 : ((AbiType.UInt)type).getBitSize() / 8;
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bytes.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
            n = ((Bytes)data).getSize();
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.String");
            n = Utf8.INSTANCE.encodedLength((String)data);
        } else if (abiType instanceof AbiType.Array) {
            if (((AbiType.Array)type).getType().isDynamic() || ((AbiType.Array)type).getType() instanceof AbiType.Array) {
                throw new IllegalArgumentException("Cannot encode dynamic or nested arrays in packed format");
            }
            int size = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            int n2 = values.length;
            for (int i = 0; i < n2; ++i) {
                AbiType abiType2 = ((AbiType.Array)type).getType();
                Object object = values[i];
                Intrinsics.checkNotNull((Object)object);
                size += this.packEncodedSize(abiType2, object, true);
            }
            n = size;
        } else if (abiType instanceof AbiType.FixedArray) {
            if (((AbiType.FixedArray)type).getType().isDynamic() || ((AbiType.FixedArray)type).getType() instanceof AbiType.Array) {
                throw new IllegalArgumentException("Cannot encode dynamic or nested arrays in packed format");
            }
            int size = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            int n3 = values.length;
            for (int i = 0; i < n3; ++i) {
                AbiType abiType3 = ((AbiType.FixedArray)type).getType();
                Object object = values[i];
                Intrinsics.checkNotNull((Object)object);
                size += this.packEncodedSize(abiType3, object, true);
            }
            n = size;
        } else {
            if (abiType instanceof AbiType.Tuple) {
                throw new IllegalArgumentException("Cannot encode tuple in packed format");
            }
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final void encodePacked(ByteBuffer buff, AbiType type, Object data, boolean inArray) {
        AbiType abiType = type;
        if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Address.INSTANCE)) {
            if (inArray) {
                AbiCodecKt.access$skip(buff, 12);
            }
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Address");
            buff.put(((Address)data).getValue());
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bool.INSTANCE)) {
            if (inArray) {
                AbiCodecKt.access$skip(buff, 31);
            }
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Boolean");
            buff.put((Boolean)data != false ? (byte)1 : 0);
        } else if (abiType instanceof AbiType.FixedBytes) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
            Bytes value = (Bytes)data;
            if (value.getSize() != ((AbiType.FixedBytes)type).getLength()) {
                throw new IllegalArgumentException("Provided value has length " + value.getSize() + ", expected " + ((AbiType.FixedBytes)type).getLength());
            }
            buff.put(value.getValue());
            if (inArray) {
                AbiCodecKt.access$skip(buff, ((AbiType.FixedBytes)type).getLength() - value.getSize());
            }
        } else if (abiType instanceof AbiType.Int) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger v = (BigInteger)data;
            if (v.bitLength() > ((AbiType.Int)type).getBitSize() - 1) {
                throw new IllegalArgumentException("Provided INT value has more than " + (((AbiType.Int)type).getBitSize() - 1) + " bits: " + v.bitLength());
            }
            byte[] arr = v.toByteArray();
            if (v.signum() == -1) {
                if (inArray) {
                    buff.put(AbiCodecKt.access$getTWOS_COMPLEMENT_PADDING$p()[32 - arr.length]);
                } else {
                    buff.put(AbiCodecKt.access$getTWOS_COMPLEMENT_PADDING$p()[((AbiType.Int)type).getBitSize() / 8 - arr.length]);
                }
                buff.put(arr);
                return;
            }
            if (inArray) {
                AbiCodecKt.access$skip(buff, 32 - arr.length);
            } else {
                AbiCodecKt.access$skip(buff, ((AbiType.Int)type).getBitSize() / 8 - arr.length);
            }
            buff.put(arr);
        } else if (abiType instanceof AbiType.UInt) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger v = (BigInteger)data;
            if (v.signum() == -1) {
                throw new IllegalArgumentException("Expected UINT, got INT: " + v);
            }
            if (v.bitLength() > ((AbiType.UInt)type).getBitSize()) {
                throw new IllegalArgumentException("Provided UINT value has more than " + ((AbiType.UInt)type).getBitSize() + " bits: " + v.bitLength());
            }
            byte[] arr = v.toByteArray();
            if (arr.length > 33 || arr.length == 33 && arr[0] != 0) {
                throw new IllegalArgumentException("Provided value has more than 256 bits: " + v);
            }
            if (arr.length == 33 && arr[0] == 0) {
                buff.put(arr, 1, 32);
            } else {
                if (inArray) {
                    AbiCodecKt.access$skip(buff, 32 - arr.length);
                } else {
                    AbiCodecKt.access$skip(buff, ((AbiType.UInt)type).getBitSize() / 8 - arr.length);
                }
                buff.put(arr);
            }
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.Bytes.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
            buff.put(((Bytes)data).getValue());
        } else if (Intrinsics.areEqual((Object)abiType, (Object)AbiType.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.String");
            byte[] byArray = ((String)data).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            buff.put(byArray);
        } else if (abiType instanceof AbiType.Array) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                AbiType abiType2 = ((AbiType.Array)type).getType();
                Object object = values[i];
                Intrinsics.checkNotNull((Object)object);
                this.encodePacked(buff, abiType2, object, true);
            }
        } else if (abiType instanceof AbiType.FixedArray) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            if (values.length != ((AbiType.FixedArray)type).getLength()) {
                throw new IllegalArgumentException("Provided value has length " + values.length + ", expected " + ((AbiType.FixedArray)type).getLength());
            }
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                AbiType abiType3 = ((AbiType.FixedArray)type).getType();
                Object object = values[i];
                Intrinsics.checkNotNull((Object)object);
                this.encodePacked(buff, abiType3, object, true);
            }
        } else if (abiType instanceof AbiType.Tuple) {
            throw new IllegalArgumentException("Cannot encode tuple in packed format");
        }
    }
}

