/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.samples.vision.barcodereader;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.samples.vision.barcodereader.BarcodeGraphic;
import com.google.android.gms.samples.vision.barcodereader.BarcodeTrackerFactory;
import com.google.android.gms.samples.vision.barcodereader.ui.camera.CameraSource;
import com.google.android.gms.samples.vision.barcodereader.ui.camera.CameraSourcePreview;
import com.google.android.gms.samples.vision.barcodereader.ui.camera.GraphicOverlay;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.MultiProcessor;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import java.io.IOException;
import java.util.ArrayList;
import xyz.belvi.mobilevisionbarcodescanner.BarcodeFragment;
import xyz.belvi.mobilevisionbarcodescanner.R;

public final class BarcodeCapture
extends BarcodeFragment {
    private static final String TAG = "Barcode-reader";
    private static final int RC_HANDLE_GMS = 9001;
    private static final int RC_HANDLE_CAMERA_PERM = 2;
    public static final String BarcodeObject = "Barcode";
    private CameraSource mCameraSource;
    private CameraSourcePreview mPreview;
    private GraphicOverlay<BarcodeGraphic> mGraphicOverlay;
    private ScaleGestureDetector scaleGestureDetector;
    private GestureDetector gestureDetector;

    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(context, attrs, savedInstanceState);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.gvb);
        this.showFlash = a.getBoolean(R.styleable.gvb_gvb_flash, false);
        this.showDrawRect = a.getBoolean(R.styleable.gvb_gvb_draw, false);
        this.shouldShowText = a.getBoolean(R.styleable.gvb_gvb_show_text, false);
        this.shouldFocus = a.getBoolean(R.styleable.gvb_gvb_auto_focus, false);
        this.touchAsCallback = a.getBoolean(R.styleable.gvb_gvb_touch, false);
        this.multipleScan = a.getBoolean(R.styleable.gvb_gvb_multiple, false);
        int colors = a.getResourceId(R.styleable.gvb_gvb_rect_colors, R.array.rect_color);
        if (colors != 0) {
            TypedArray resourceArray = this.getResources().obtainTypedArray(colors);
            ArrayList<Integer> rectColorsList = new ArrayList<Integer>();
            for (int i = 0; i < resourceArray.length(); ++i) {
                int resourceId = resourceArray.getResourceId(i, 0);
                rectColorsList.add(resourceId);
            }
            this.rectColors = rectColorsList.toArray(new Integer[rectColorsList.size()]);
            resourceArray.recycle();
        }
        a.recycle();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.barcode_capture, container, false);
        this.mPreview = (CameraSourcePreview)rootView.findViewById(R.id.preview);
        this.mGraphicOverlay = (GraphicOverlay)rootView.findViewById(R.id.graphicOverlay);
        this.mGraphicOverlay.setShowText(this.shouldShowText);
        this.mGraphicOverlay.setRectColors(this.rectColors);
        this.mGraphicOverlay.setDrawRect(this.showDrawRect);
        int rc = ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA");
        if (rc == 0) {
            this.createCameraSource(this.shouldFocus, this.showFlash);
        } else {
            this.requestCameraPermission();
        }
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new CaptureGestureListener());
        this.scaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        rootView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent e) {
                boolean b = BarcodeCapture.this.scaleGestureDetector.onTouchEvent(e);
                boolean c = BarcodeCapture.this.gestureDetector.onTouchEvent(e);
                return b || c || view.onTouchEvent(e);
            }
        });
        return rootView;
    }

    private void requestCameraPermission() {
        Log.w((String)TAG, (String)"Camera permission is not granted. Requesting permission");
        final String[] permissions = new String[]{"android.permission.CAMERA"};
        if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)"android.permission.CAMERA")) {
            ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])permissions, (int)2);
            return;
        }
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View view) {
                ActivityCompat.requestPermissions((Activity)BarcodeCapture.this.getActivity(), (String[])permissions, (int)2);
            }
        };
        Snackbar.make(this.mGraphicOverlay, (int)R.string.permission_camera_rationale, (int)-2).setAction(R.string.ok, listener).show();
    }

    @SuppressLint(value={"InlinedApi"})
    private void createCameraSource(boolean autoFocus, boolean useFlash) {
        BarcodeDetector barcodeDetector = new BarcodeDetector.Builder(this.getContext()).build();
        BarcodeTrackerFactory barcodeFactory = new BarcodeTrackerFactory(this.mGraphicOverlay){

            @Override
            void onCodeDetected(Barcode barcode) {
                if (!BarcodeCapture.this.isTouchAsCallback() || !BarcodeCapture.this.isMultipleScan()) {
                    BarcodeCapture.this.barcodeRetriever.onRetrieved(barcode);
                }
            }
        };
        barcodeDetector.setProcessor((Detector.Processor)new MultiProcessor.Builder((MultiProcessor.Factory)barcodeFactory).build());
        if (!barcodeDetector.isOperational()) {
            boolean hasLowStorage;
            Log.w((String)TAG, (String)"Detector dependencies are not yet available.");
            IntentFilter lowstorageFilter = new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW");
            boolean bl = hasLowStorage = this.getActivity().registerReceiver(null, lowstorageFilter) != null;
            if (hasLowStorage) {
                Toast.makeText((Context)this.getContext(), (int)R.string.low_storage_error, (int)1).show();
                Log.w((String)TAG, (String)this.getString(R.string.low_storage_error));
            }
        }
        CameraSource.Builder builder = new CameraSource.Builder(this.getContext(), (Detector<?>)barcodeDetector).setFacing(0).setRequestedPreviewSize(1600, 1024).setRequestedFps(15.0f);
        if (Build.VERSION.SDK_INT >= 14) {
            builder = builder.setFocusMode(autoFocus ? "continuous-picture" : null);
        }
        this.mCameraSource = builder.setFlashMode(useFlash ? "torch" : null).build();
    }

    public void onResume() {
        super.onResume();
        this.startCameraSource();
    }

    public void onPause() {
        super.onPause();
        if (this.mPreview != null) {
            this.mPreview.stop();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPreview != null) {
            this.mPreview.release();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode != 2) {
            Log.d((String)TAG, (String)("Got unexpected permission result: " + requestCode));
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            return;
        }
        if (grantResults.length != 0 && grantResults[0] == 0) {
            Log.d((String)TAG, (String)"Camera permission granted - initialize the camera source");
            this.createCameraSource(this.shouldFocus, this.showFlash);
            return;
        }
        this.barcodeRetriever.onRetrievedFailed(this.getString(R.string.no_camera_permission));
    }

    private void startCameraSource() throws SecurityException {
        int code = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.getContext());
        if (code != 0) {
            Dialog dlg = GoogleApiAvailability.getInstance().getErrorDialog((Activity)this.getActivity(), code, 9001);
            dlg.show();
        }
        if (this.mCameraSource != null) {
            try {
                this.mPreview.start(this.mCameraSource, this.mGraphicOverlay);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to start camera source.", (Throwable)e);
                this.mCameraSource.release();
                this.mCameraSource = null;
            }
        }
    }

    private boolean onTap(float rawX, float rawY) {
        int[] location = new int[2];
        this.mGraphicOverlay.getLocationOnScreen(location);
        float x = (rawX - (float)location[0]) / this.mGraphicOverlay.getWidthScaleFactor();
        float y = (rawY - (float)location[1]) / this.mGraphicOverlay.getHeightScaleFactor();
        Barcode best = null;
        float bestDistance = Float.MAX_VALUE;
        ArrayList<Barcode> allRetrieved = new ArrayList<Barcode>();
        for (BarcodeGraphic graphic : this.mGraphicOverlay.getGraphics()) {
            float dy;
            Barcode barcode = graphic.getBarcode();
            allRetrieved.add(barcode);
            if (barcode.getBoundingBox().contains((int)x, (int)y)) {
                best = barcode;
                break;
            }
            float dx = x - (float)barcode.getBoundingBox().centerX();
            float distance = dx * dx + (dy = y - (float)barcode.getBoundingBox().centerY()) * dy;
            if (!(distance < bestDistance)) continue;
            best = barcode;
            bestDistance = distance;
        }
        if (best != null) {
            if (this.barcodeRetriever != null) {
                if (this.isMultipleScan()) {
                    this.barcodeRetriever.onRetrieved(best, this.mGraphicOverlay.getGraphics());
                } else {
                    this.barcodeRetriever.onRetrieved(best);
                }
            }
            return true;
        }
        return false;
    }

    private class ScaleListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            BarcodeCapture.this.mCameraSource.doZoom(detector.getScaleFactor());
        }
    }

    private class CaptureGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private CaptureGestureListener() {
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            return BarcodeCapture.this.onTap(e.getRawX(), e.getRawY()) || super.onSingleTapConfirmed(e);
        }
    }
}

