/*
 * Decompiled with CFR 0.152.
 */
package com.ypz.bangscreentools;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.RequiresApi;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import com.ypz.bangscreentools.BangScreenSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class VivoBangScreen
implements BangScreenSupport {
    private Class vivo;
    private Method vivoMethod;

    @Override
    @RequiresApi(api=26)
    public boolean hasNotBangScreen(Window window) {
        if (window == null) {
            return false;
        }
        if (this.vivo == null) {
            ClassLoader vivoLoader = window.getContext().getClassLoader();
            try {
                this.vivo = vivoLoader.loadClass("android.util.FtFeature");
                this.vivoMethod = this.vivo.getMethod("isFeatureSupport", Integer.TYPE);
                return (Boolean)this.vivoMethod.invoke((Object)this.vivo, 32);
            }
            catch (ClassNotFoundException e) {
                this.logError(e);
                return false;
            }
            catch (NoSuchMethodException e) {
                this.logError(e);
                return false;
            }
            catch (IllegalAccessException e) {
                this.logError(e);
                return false;
            }
            catch (InvocationTargetException e) {
                this.logError(e);
                return false;
            }
        }
        if (this.vivoMethod == null) {
            try {
                this.vivoMethod = this.vivo.getMethod("isFeatureSupport", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.logError(e);
                return false;
            }
            try {
                return (Boolean)this.vivoMethod.invoke((Object)this.vivo, 32);
            }
            catch (IllegalAccessException e) {
                this.logError(e);
                return false;
            }
            catch (InvocationTargetException e) {
                this.logError(e);
                return false;
            }
        }
        return false;
    }

    @Override
    @RequiresApi(api=26)
    public List<Rect> getBangSize(Window window) {
        ArrayList<Rect> result = new ArrayList<Rect>();
        if (window == null) {
            return result;
        }
        Rect rect = new Rect();
        DisplayMetrics displayMetrics = window.getContext().getResources().getDisplayMetrics();
        int notchWidth = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)displayMetrics);
        int notchHeight = (int)TypedValue.applyDimension((int)1, (float)27.0f, (DisplayMetrics)displayMetrics);
        rect.left = (displayMetrics.widthPixels - notchWidth) / 2;
        rect.right = rect.left + notchWidth;
        rect.top = 0;
        rect.bottom = notchHeight;
        result.add(rect);
        return result;
    }

    @Override
    @RequiresApi(api=26)
    public void extendStatusCutout(Window window, Context context) {
        if (window == null) {
            return;
        }
        Log.i((String)"BangScreenTools", (String)"next");
    }

    @Override
    @RequiresApi(api=26)
    public void setWindowLayoutBlockNotch(Window window) {
        if (window == null) {
            return;
        }
        window.clearFlags(1024);
        window.clearFlags(0x4000000);
        View view = window.getDecorView();
        int systemUiVisibility = view.getSystemUiVisibility();
        systemUiVisibility &= 0x400;
        view.setSystemUiVisibility(systemUiVisibility &= 0x100);
    }

    @Override
    public void transparentStatusCutout(Window window, Context context) {
    }

    @Override
    public void fullscreen(Window window, Context context) {
    }

    private void logError(Exception e) {
        Log.e((String)"BangScreenTools", (String)e.getMessage());
    }
}

