/*
 * Decompiled with CFR 0.152.
 */
package com.ypz.bangscreentools;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.Window;
import com.ypz.bangscreentools.BangScreenSupport;
import com.ypz.bangscreentools.HuaWeiBangScreen;
import com.ypz.bangscreentools.MiuiBangScreen;
import com.ypz.bangscreentools.OppoBangScreen;
import com.ypz.bangscreentools.PBangScreen;
import com.ypz.bangscreentools.PhoneManufacturersJudgeTools;
import com.ypz.bangscreentools.VivoBangScreen;
import java.util.ArrayList;
import java.util.List;

public class BangScreenTools {
    private static BangScreenTools bangScreenTools;
    protected static final String TAG = "BangScreenTools";
    private final int systemCode = Build.VERSION.SDK_INT;
    private BangScreenSupport bangScreenSupport = null;
    private boolean isHaveResult;
    private boolean isBangScree;
    private int statusBarHeight = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BangScreenTools getBangScreenTools() {
        if (bangScreenTools != null) return bangScreenTools;
        Class<BangScreenTools> clazz = BangScreenTools.class;
        synchronized (BangScreenTools.class) {
            bangScreenTools = new BangScreenTools();
            // ** MonitorExit[var0] (shouldn't be in output)
            return bangScreenTools;
        }
    }

    private BangScreenTools() {
    }

    public boolean hasBangScreen(Window Window2) {
        if (!this.isHaveResult) {
            if (this.bangScreenSupport == null) {
                this.checkScreenSupportInit();
            }
            if (this.bangScreenSupport == null) {
                this.isHaveResult = true;
                this.isBangScree = false;
                return false;
            }
            this.isBangScree = this.bangScreenSupport.hasNotBangScreen(Window2);
            return this.isBangScree;
        }
        return this.isBangScree;
    }

    private List<Rect> getDisplayCutoutSize(Window window) {
        if (this.bangScreenSupport == null) {
            this.checkScreenSupportInit();
        }
        if (this.bangScreenSupport == null) {
            return new ArrayList<Rect>();
        }
        return this.bangScreenSupport.getBangSize(window);
    }

    public void extendStatusCutout(Window window, Context context) {
        ActionBar actionBar;
        if (this.bangScreenSupport == null) {
            this.checkScreenSupportInit();
        }
        if (window == null) {
            return;
        }
        if (this.bangScreenSupport == null) {
            return;
        }
        if (context instanceof AppCompatActivity) {
            android.support.v7.app.ActionBar actionBar2 = ((AppCompatActivity)context).getSupportActionBar();
            Log.i((String)TAG, (String)"isAppCompatActivity");
            if (actionBar2 != null) {
                actionBar2.hide();
            }
        } else if (context instanceof Activity && (actionBar = ((Activity)context).getActionBar()) != null) {
            actionBar.hide();
        }
        window.setFlags(1024, 1024);
        window.getDecorView().setSystemUiVisibility(1792);
        this.bangScreenSupport.extendStatusCutout(window, context);
    }

    public void windowChangeExtendStatusCutout(Window window) {
        if (this.bangScreenSupport == null) {
            this.checkScreenSupportInit();
        }
        if (window == null) {
            return;
        }
        window.getDecorView().setSystemUiVisibility(5888);
    }

    public void transparentStatusCutout(Window window, Context context) {
        ActionBar actionBar;
        if (this.bangScreenSupport == null) {
            this.checkScreenSupportInit();
        }
        if (window == null) {
            return;
        }
        if (this.bangScreenSupport == null) {
            return;
        }
        if (context instanceof AppCompatActivity) {
            android.support.v7.app.ActionBar actionBar2 = ((AppCompatActivity)context).getSupportActionBar();
            Log.i((String)TAG, (String)"isAppCompatActivity");
            if (actionBar2 != null) {
                actionBar2.hide();
            }
        } else if (context instanceof Activity && (actionBar = ((Activity)context).getActionBar()) != null) {
            actionBar.hide();
        }
        window.getDecorView().setSystemUiVisibility(1280);
        window.setStatusBarColor(0);
        this.bangScreenSupport.transparentStatusCutout(window, context);
    }

    public void windowChangeTransparentStatusCutout(Window window) {
        if (this.bangScreenSupport == null) {
            this.checkScreenSupportInit();
        }
        if (window == null) {
            return;
        }
        window.getDecorView().setSystemUiVisibility(1280);
    }

    public void fullscreen(Window window, Context context) {
        ActionBar actionBar;
        if (this.bangScreenSupport == null) {
            this.checkScreenSupportInit();
        }
        if (window == null) {
            return;
        }
        if (this.bangScreenSupport == null) {
            return;
        }
        if (context instanceof AppCompatActivity) {
            android.support.v7.app.ActionBar actionBar2 = ((AppCompatActivity)context).getSupportActionBar();
            Log.i((String)TAG, (String)"isAppCompatActivity");
            if (actionBar2 != null) {
                actionBar2.hide();
            }
        } else if (context instanceof Activity && (actionBar = ((Activity)context).getActionBar()) != null) {
            actionBar.hide();
        }
        window.getDecorView().setSystemUiVisibility(1798);
        this.bangScreenSupport.fullscreen(window, context);
    }

    public void windowChangeFullscreen(Window window) {
        if (window == null) {
            return;
        }
        window.getDecorView().setSystemUiVisibility(5894);
    }

    public void blockDisplayCutout(Window window) {
        if (this.bangScreenSupport == null) {
            this.checkScreenSupportInit();
        }
        if (this.bangScreenSupport != null) {
            this.bangScreenSupport.setWindowLayoutBlockNotch(window);
        }
    }

    private void checkScreenSupportInit() {
        if (this.bangScreenSupport == null) {
            if (this.systemCode < 26) {
                this.bangScreenSupport = new BangScreenSupport(){

                    @Override
                    public boolean hasNotBangScreen(Window window) {
                        return false;
                    }

                    @Override
                    public List<Rect> getBangSize(Window window) {
                        return new ArrayList<Rect>();
                    }

                    @Override
                    public void extendStatusCutout(Window window, Context context) {
                    }

                    @Override
                    public void setWindowLayoutBlockNotch(Window window) {
                    }

                    @Override
                    public void transparentStatusCutout(Window window, Context context) {
                    }

                    @Override
                    public void fullscreen(Window window, Context context) {
                    }
                };
            } else if (this.systemCode < 28) {
                PhoneManufacturersJudgeTools PMJ = PhoneManufacturersJudgeTools.getPMJTools();
                if (PMJ.isHuaWei()) {
                    Log.i((String)TAG, (String)"HuaWei");
                    this.bangScreenSupport = new HuaWeiBangScreen();
                } else if (PMJ.isMiui()) {
                    Log.i((String)TAG, (String)"Miui");
                    this.bangScreenSupport = new MiuiBangScreen();
                } else if (PMJ.isVivo()) {
                    Log.i((String)TAG, (String)"Vivo");
                    this.bangScreenSupport = new VivoBangScreen();
                } else if (PMJ.isOppo()) {
                    Log.i((String)TAG, (String)"Oppo");
                    this.bangScreenSupport = new OppoBangScreen();
                }
            } else {
                Log.i((String)TAG, (String)"PB");
                this.bangScreenSupport = new PBangScreen();
            }
        }
    }

    protected final int getStatusBarHeight(Context context) {
        if (this.statusBarHeight != -1) {
            return this.statusBarHeight;
        }
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            this.statusBarHeight = context.getResources().getDimensionPixelSize(resId);
        }
        return this.statusBarHeight;
    }
}

