/*
 * Decompiled with CFR 0.152.
 */
package com.kennyc.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.kennyc.multistateview.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MultiStateView
extends FrameLayout {
    public static final int VIEW_STATE_UNKNOWN = -1;
    public static final int VIEW_STATE_CONTENT = 0;
    public static final int VIEW_STATE_ERROR = 1;
    public static final int VIEW_STATE_EMPTY = 2;
    public static final int VIEW_STATE_LOADING = 3;
    private LayoutInflater mInflater;
    private View mContentView;
    private View mLoadingView;
    private View mErrorView;
    private View mEmptyView;
    private boolean mAnimateViewChanges = false;
    @Nullable
    private StateListener mListener;
    private int mViewState = -1;

    public MultiStateView(Context context) {
        this(context, null);
    }

    public MultiStateView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MultiStateView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        int errorViewResId;
        int emptyViewResId;
        this.mInflater = LayoutInflater.from((Context)this.getContext());
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MultiStateView);
        int loadingViewResId = a.getResourceId(R.styleable.MultiStateView_msv_loadingView, -1);
        if (loadingViewResId > -1) {
            this.mLoadingView = this.mInflater.inflate(loadingViewResId, (ViewGroup)this, false);
            this.addView(this.mLoadingView, this.mLoadingView.getLayoutParams());
        }
        if ((emptyViewResId = a.getResourceId(R.styleable.MultiStateView_msv_emptyView, -1)) > -1) {
            this.mEmptyView = this.mInflater.inflate(emptyViewResId, (ViewGroup)this, false);
            this.addView(this.mEmptyView, this.mEmptyView.getLayoutParams());
        }
        if ((errorViewResId = a.getResourceId(R.styleable.MultiStateView_msv_errorView, -1)) > -1) {
            this.mErrorView = this.mInflater.inflate(errorViewResId, (ViewGroup)this, false);
            this.addView(this.mErrorView, this.mErrorView.getLayoutParams());
        }
        int viewState = a.getInt(R.styleable.MultiStateView_msv_viewState, 0);
        this.mAnimateViewChanges = a.getBoolean(R.styleable.MultiStateView_msv_animateViewChanges, false);
        switch (viewState) {
            case 0: {
                this.mViewState = 0;
                break;
            }
            case 1: {
                this.mViewState = 1;
                break;
            }
            case 2: {
                this.mViewState = 2;
                break;
            }
            case 3: {
                this.mViewState = 3;
                break;
            }
            default: {
                this.mViewState = -1;
            }
        }
        a.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mContentView == null) {
            throw new IllegalArgumentException("Content view is not defined");
        }
        this.setView(-1);
    }

    public void addView(View child) {
        if (this.isValidContentView(child)) {
            this.mContentView = child;
        }
        super.addView(child);
    }

    public void addView(View child, int index) {
        if (this.isValidContentView(child)) {
            this.mContentView = child;
        }
        super.addView(child, index);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.isValidContentView(child)) {
            this.mContentView = child;
        }
        super.addView(child, index, params);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.isValidContentView(child)) {
            this.mContentView = child;
        }
        super.addView(child, params);
    }

    public void addView(View child, int width, int height) {
        if (this.isValidContentView(child)) {
            this.mContentView = child;
        }
        super.addView(child, width, height);
    }

    protected boolean addViewInLayout(View child, int index, ViewGroup.LayoutParams params) {
        if (this.isValidContentView(child)) {
            this.mContentView = child;
        }
        return super.addViewInLayout(child, index, params);
    }

    protected boolean addViewInLayout(View child, int index, ViewGroup.LayoutParams params, boolean preventRequestLayout) {
        if (this.isValidContentView(child)) {
            this.mContentView = child;
        }
        return super.addViewInLayout(child, index, params, preventRequestLayout);
    }

    @Nullable
    public View getView(int state) {
        switch (state) {
            case 3: {
                return this.mLoadingView;
            }
            case 0: {
                return this.mContentView;
            }
            case 2: {
                return this.mEmptyView;
            }
            case 1: {
                return this.mErrorView;
            }
        }
        return null;
    }

    public int getViewState() {
        return this.mViewState;
    }

    public void setViewState(int state) {
        if (state != this.mViewState) {
            int previous = this.mViewState;
            this.mViewState = state;
            this.setView(previous);
            if (this.mListener != null) {
                this.mListener.onStateChanged(this.mViewState);
            }
        }
    }

    private void setView(int previousState) {
        switch (this.mViewState) {
            case 3: {
                if (this.mLoadingView == null) {
                    throw new NullPointerException("Loading View");
                }
                if (this.mContentView != null) {
                    this.mContentView.setVisibility(8);
                }
                if (this.mErrorView != null) {
                    this.mErrorView.setVisibility(8);
                }
                if (this.mEmptyView != null) {
                    this.mEmptyView.setVisibility(8);
                }
                if (this.mAnimateViewChanges) {
                    this.animateLayoutChange(this.getView(previousState));
                    break;
                }
                this.mLoadingView.setVisibility(0);
                break;
            }
            case 2: {
                if (this.mEmptyView == null) {
                    throw new NullPointerException("Empty View");
                }
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mErrorView != null) {
                    this.mErrorView.setVisibility(8);
                }
                if (this.mContentView != null) {
                    this.mContentView.setVisibility(8);
                }
                if (this.mAnimateViewChanges) {
                    this.animateLayoutChange(this.getView(previousState));
                    break;
                }
                this.mEmptyView.setVisibility(0);
                break;
            }
            case 1: {
                if (this.mErrorView == null) {
                    throw new NullPointerException("Error View");
                }
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mContentView != null) {
                    this.mContentView.setVisibility(8);
                }
                if (this.mEmptyView != null) {
                    this.mEmptyView.setVisibility(8);
                }
                if (this.mAnimateViewChanges) {
                    this.animateLayoutChange(this.getView(previousState));
                    break;
                }
                this.mErrorView.setVisibility(0);
                break;
            }
            default: {
                if (this.mContentView == null) {
                    throw new NullPointerException("Content View");
                }
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mErrorView != null) {
                    this.mErrorView.setVisibility(8);
                }
                if (this.mEmptyView != null) {
                    this.mEmptyView.setVisibility(8);
                }
                if (this.mAnimateViewChanges) {
                    this.animateLayoutChange(this.getView(previousState));
                    break;
                }
                this.mContentView.setVisibility(0);
            }
        }
    }

    private boolean isValidContentView(View view) {
        if (this.mContentView != null && this.mContentView != view) {
            return false;
        }
        return view != this.mLoadingView && view != this.mErrorView && view != this.mEmptyView;
    }

    public void setViewForState(View view, int state, boolean switchToState) {
        switch (state) {
            case 3: {
                if (this.mLoadingView != null) {
                    this.removeView(this.mLoadingView);
                }
                this.mLoadingView = view;
                this.addView(this.mLoadingView);
                break;
            }
            case 2: {
                if (this.mEmptyView != null) {
                    this.removeView(this.mEmptyView);
                }
                this.mEmptyView = view;
                this.addView(this.mEmptyView);
                break;
            }
            case 1: {
                if (this.mErrorView != null) {
                    this.removeView(this.mErrorView);
                }
                this.mErrorView = view;
                this.addView(this.mErrorView);
                break;
            }
            case 0: {
                if (this.mContentView != null) {
                    this.removeView(this.mContentView);
                }
                this.mContentView = view;
                this.addView(this.mContentView);
            }
        }
        this.setView(-1);
        if (switchToState) {
            this.setViewState(state);
        }
    }

    public void setViewForState(View view, int state) {
        this.setViewForState(view, state, false);
    }

    public void setViewForState(@LayoutRes int layoutRes, int state, boolean switchToState) {
        if (this.mInflater == null) {
            this.mInflater = LayoutInflater.from((Context)this.getContext());
        }
        View view = this.mInflater.inflate(layoutRes, (ViewGroup)this, false);
        this.setViewForState(view, state, switchToState);
    }

    public void setViewForState(@LayoutRes int layoutRes, int state) {
        this.setViewForState(layoutRes, state, false);
    }

    public void setAnimateLayoutChanges(boolean animate) {
        this.mAnimateViewChanges = animate;
    }

    public void setStateListener(StateListener listener) {
        this.mListener = listener;
    }

    private void animateLayoutChange(final @Nullable View previousView) {
        if (previousView == null) {
            this.getView(this.mViewState).setVisibility(0);
            return;
        }
        previousView.setVisibility(0);
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)previousView, (String)"alpha", (float[])new float[]{1.0f, 0.0f}).setDuration(250L);
        anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                previousView.setVisibility(8);
                MultiStateView.this.getView(MultiStateView.this.mViewState).setVisibility(0);
                ObjectAnimator.ofFloat((Object)MultiStateView.this.getView(MultiStateView.this.mViewState), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(250L).start();
            }
        });
        anim.start();
    }

    public static interface StateListener {
        public void onStateChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ViewState {
    }
}

