/*
 * Decompiled with CFR 0.152.
 */
package com.kennyc.bottomsheet.adapters;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.kennyc.bottomsheet.R;
import com.kennyc.bottomsheet.adapters.ViewHolder;
import java.util.List;

public class GridAdapter
extends BaseAdapter {
    private final List<MenuItem> items;
    private final LayoutInflater inflater;
    private boolean isGrid;

    public GridAdapter(Context context, List<MenuItem> items, boolean isGrid) {
        this.items = items;
        this.isGrid = isGrid;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return this.items.size();
    }

    public MenuItem getItem(int position) {
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return this.getItem(position).getItemId();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        MenuItem item = this.getItem(position);
        if (convertView == null) {
            convertView = this.inflater.inflate(this.isGrid ? R.layout.bottom_sheet_grid_item : R.layout.bottom_sheet_list_item, parent, false);
            holder = new ViewHolder(convertView);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        Drawable menuIcon = item.getIcon();
        holder.icon.setImageDrawable(menuIcon);
        holder.icon.setVisibility(menuIcon != null ? 0 : 8);
        holder.title.setText(item.getTitle());
        return convertView;
    }
}

