/*
 * Decompiled with CFR 0.152.
 */
package com.kennyc.bottomsheet;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class CollapsingView
extends FrameLayout {
    private ViewDragHelper mDragHelper;
    private int mMinCollapseHeight;
    private int mHeight;
    private CollapseListener mListener;

    public CollapsingView(Context context) {
        super(context);
    }

    public CollapsingView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CollapsingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)0.8f, (ViewDragHelper.Callback)new DragCallback());
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.mDragHelper.shouldInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mDragHelper.processTouchEvent(event);
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mHeight = h;
        this.mMinCollapseHeight = h / 2;
    }

    public void setCollapseListener(CollapseListener listener) {
        this.mListener = listener;
    }

    static interface CollapseListener {
        public void onCollapse();
    }

    private class DragCallback
    extends ViewDragHelper.Callback {
        private static final float CLOSE_VELOCITY = 800.0f;

        private DragCallback() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            return true;
        }

        public int getViewVerticalDragRange(View child) {
            return CollapsingView.this.getMeasuredHeight();
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return top > 0 ? top : 0;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            if (yvel >= 800.0f || releasedChild.getTop() >= CollapsingView.this.mMinCollapseHeight) {
                CollapsingView.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), CollapsingView.this.mHeight);
            } else {
                CollapsingView.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), 0);
            }
            CollapsingView.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if (top >= CollapsingView.this.mHeight && CollapsingView.this.mListener != null) {
                CollapsingView.this.mListener.onCollapse();
            }
        }
    }
}

