/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.gyroscope;

import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.BaseFilter;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationGyroscope
extends BaseFilter {
    private static final String tag = OrientationGyroscope.class.getSimpleName();
    private static final float NS2S = 1.0E-9f;
    private static final float EPSILON = 1.0E-9f;
    private Quaternion rotationVectorGyroscope;
    private float[] output = new float[3];
    private long timestamp = 0L;

    @Override
    public float[] getOutput() {
        return this.output;
    }

    public float[] calculateOrientation(float[] gyroscope, long timestamp) {
        if (this.rotationVectorGyroscope != null) {
            if (this.timestamp != 0L) {
                float dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                this.rotationVectorGyroscope = RotationUtil.integrateGyroscopeRotation(this.rotationVectorGyroscope, gyroscope, dT, 1.0E-9f);
            }
            this.timestamp = timestamp;
            float[] fusedVector = new float[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            float[] fusedMatrix = new float[9];
            SensorManager.getRotationMatrixFromVector((float[])fusedMatrix, (float[])fusedVector);
            SensorManager.getOrientation((float[])fusedMatrix, (float[])this.output);
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }

    public void setBaseOrientation(Quaternion baseOrientation) {
        this.rotationVectorGyroscope = baseOrientation;
    }

    public void reset() {
        this.rotationVectorGyroscope = null;
        this.timestamp = 0L;
    }

    public boolean isBaseOrientationSet() {
        return this.rotationVectorGyroscope != null;
    }
}

