/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.gyroscope.fusion.complementary;

import com.kircherelectronics.fsensor.filter.gyroscope.fusion.OrientationFused;
import com.kircherelectronics.fsensor.util.angle.AngleUtils;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationFusedComplementary
extends OrientationFused {
    private static final String TAG = OrientationFusedComplementary.class.getSimpleName();

    public OrientationFusedComplementary() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationFusedComplementary(float timeConstant) {
        super(timeConstant);
    }

    @Override
    public float[] calculateFusedOrientation(float[] gyroscope, long timestamp, float[] acceleration, float[] magnetic) {
        if (this.isBaseOrientationSet()) {
            if (this.timestamp != 0L) {
                float dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                float alpha = this.timeConstant / (this.timeConstant + dT);
                float oneMinusAlpha = 1.0f - alpha;
                Quaternion rotationVectorAccelerationMagnetic = RotationUtil.getOrientationVectorFromAccelerationMagnetic(acceleration, magnetic);
                if (rotationVectorAccelerationMagnetic != null) {
                    this.rotationVectorGyroscope = RotationUtil.integrateGyroscopeRotation(this.rotationVectorGyroscope, gyroscope, dT, 1.0E-9f);
                    Quaternion scaledRotationVectorAccelerationMagnetic = rotationVectorAccelerationMagnetic.multiply((double)oneMinusAlpha);
                    Quaternion scaledRotationVectorGyroscope = this.rotationVectorGyroscope.multiply((double)alpha);
                    this.rotationVectorGyroscope = scaledRotationVectorGyroscope.add(scaledRotationVectorAccelerationMagnetic);
                }
                this.output = AngleUtils.getAngles(this.rotationVectorGyroscope.getQ0(), this.rotationVectorGyroscope.getQ1(), this.rotationVectorGyroscope.getQ2(), this.rotationVectorGyroscope.getQ3());
            }
            this.timestamp = timestamp;
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }
}

