/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.linearacceleration;

import com.kircherelectronics.fsensor.filter.BaseFilter;

public abstract class LinearAcceleration {
    private static final String tag = LinearAcceleration.class.getSimpleName();
    private float[] output = new float[]{0.0f, 0.0f, 0.0f};
    protected BaseFilter filter;

    public LinearAcceleration(BaseFilter filter) {
        this.filter = filter;
    }

    public float[] filter(float[] values) {
        float[] gravity = this.getGravity();
        this.output[0] = values[0] - gravity[0];
        this.output[1] = values[1] - gravity[1];
        this.output[2] = values[2] - gravity[2];
        return this.output;
    }

    public void setTimeConstant(float timeConstant) {
        this.filter.setTimeConstant(timeConstant);
    }

    public abstract float[] getGravity();

    public void reset() {
        this.filter.reset();
    }
}

