/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.fusion;

import android.hardware.SensorManager;
import android.util.Log;
import com.kircherelectronics.fsensor.filter.fusion.OrientationComplimentaryFusion;
import com.kircherelectronics.fsensor.filter.fusion.OrientationFusion;
import com.kircherelectronics.fsensor.filter.kalman.RotationKalmanFilter;
import com.kircherelectronics.fsensor.filter.kalman.RotationMeasurementModel;
import com.kircherelectronics.fsensor.filter.kalman.RotationProcessModel;
import java.util.Arrays;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationKalmanFusion
extends OrientationFusion {
    private static final String tag = OrientationComplimentaryFusion.class.getSimpleName();
    private RotationKalmanFilter kalmanFilter;
    private RotationProcessModel pm;
    private RotationMeasurementModel mm;
    private volatile boolean run;
    private volatile float dt;
    private volatile float[] fusedOrientation = new float[3];
    private volatile float[] acceleration = new float[3];
    private volatile float[] magnetic = new float[3];
    private volatile float[] gyroscope = new float[4];
    private Thread thread;

    public OrientationKalmanFusion() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationKalmanFusion(float timeConstant) {
        super(timeConstant);
        this.pm = new RotationProcessModel();
        this.mm = new RotationMeasurementModel();
        this.kalmanFilter = new RotationKalmanFilter(this.pm, this.mm);
    }

    @Override
    public void startFusion() {
        if (!this.run && this.thread == null) {
            this.run = true;
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (OrientationKalmanFusion.this.run && !Thread.interrupted()) {
                        OrientationKalmanFusion.this.calculate();
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            Log.e((String)tag, (String)"Kalman Thread Run", (Throwable)e);
                        }
                    }
                }
            });
            this.thread.start();
        }
    }

    @Override
    public void stopFusion() {
        if (this.run && this.thread != null) {
            this.run = false;
            this.thread.interrupt();
            this.thread = null;
        }
    }

    private float[] calculate() {
        float[] baseOrientation = this.getBaseOrientation(this.acceleration, this.magnetic);
        if (baseOrientation != null) {
            Quaternion rotationVectorAccelerationMagnetic = this.getAccelerationMagneticRotationVector(baseOrientation);
            this.initializeRotationVectorGyroscopeIfRequired(rotationVectorAccelerationMagnetic);
            this.rotationVectorGyroscope = this.getGyroscopeRotationVector(this.rotationVectorGyroscope, this.gyroscope, this.dt);
            this.dt = 0.0f;
            double[] vectorGyroscope = new double[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            double[] vectorAccelerationMagnetic = new double[]{(float)rotationVectorAccelerationMagnetic.getVectorPart()[0], (float)rotationVectorAccelerationMagnetic.getVectorPart()[1], (float)rotationVectorAccelerationMagnetic.getVectorPart()[2], (float)rotationVectorAccelerationMagnetic.getScalarPart()};
            this.kalmanFilter.predict(vectorGyroscope);
            this.kalmanFilter.correct(vectorAccelerationMagnetic);
            this.rotationVectorGyroscope = new Quaternion(this.kalmanFilter.getStateEstimation()[3], Arrays.copyOfRange(this.kalmanFilter.getStateEstimation(), 0, 3));
            float[] fusedVector = new float[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            float[] fusedMatrix = new float[9];
            SensorManager.getRotationMatrixFromVector((float[])fusedMatrix, (float[])fusedVector);
            SensorManager.getOrientation((float[])fusedMatrix, (float[])this.fusedOrientation);
            return this.fusedOrientation;
        }
        Log.w((String)tag, (String)"Base Device Orientation could not be computed!");
        return null;
    }

    @Override
    protected float[] calculateFusedOrientation(float[] gyroscope, float dt, float[] acceleration, float[] magnetic) {
        this.gyroscope = gyroscope;
        this.dt += dt;
        this.acceleration = acceleration;
        this.magnetic = magnetic;
        return this.fusedOrientation;
    }
}

