/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.fusion;

import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.BaseFilter;
import java.util.Arrays;
import org.apache.commons.math3.complex.Quaternion;

public abstract class OrientationFusion
implements BaseFilter {
    private static final float EPSILON = 1.0E-9f;
    private static final float NS2S = 1.0E-9f;
    private static final String tag = OrientationFusion.class.getSimpleName();
    public static float DEFAULT_TIME_CONSTANT = 0.18f;
    public float timeConstant;
    protected Quaternion rotationVectorGyroscope;
    private float[] acceleration;
    private boolean accelerationUpdated;
    private float[] magnetic;
    private boolean magneticUpdated;
    private long timestamp;

    public OrientationFusion() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationFusion(float timeConstant) {
        this.timeConstant = timeConstant;
        this.reset();
    }

    @Override
    public float[] filter(float[] values) {
        return this.getFusedOrientation(values);
    }

    @Override
    public void reset() {
        this.accelerationUpdated = false;
        this.magneticUpdated = false;
        this.timestamp = 0L;
        this.magnetic = new float[3];
        this.acceleration = new float[3];
        this.rotationVectorGyroscope = null;
    }

    public void setAcceleration(float[] acceleration) {
        this.acceleration = Arrays.copyOf(acceleration, acceleration.length);
        this.accelerationUpdated = true;
    }

    public void setMagneticField(float[] magnetic) {
        this.magnetic = magnetic;
        this.magneticUpdated = true;
    }

    @Override
    public void setTimeConstant(float timeConstant) {
        this.timeConstant = timeConstant;
    }

    public abstract void startFusion();

    public abstract void stopFusion();

    protected abstract float[] calculateFusedOrientation(float[] var1, float var2, float[] var3, float[] var4);

    protected Quaternion getAccelerationMagneticRotationVector(float[] orientation) {
        double c1 = Math.cos(orientation[0] / 2.0f);
        double s1 = Math.sin(orientation[0] / 2.0f);
        double c2 = Math.cos(-orientation[1] / 2.0f);
        double s2 = Math.sin(-orientation[1] / 2.0f);
        double c3 = Math.cos(orientation[2] / 2.0f);
        double s3 = Math.sin(orientation[2] / 2.0f);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        return new Quaternion(w, z, x, y);
    }

    protected float[] getBaseOrientation(float[] acceleration, float[] magnetic) {
        float[] rotationMatrix = new float[9];
        if (SensorManager.getRotationMatrix((float[])rotationMatrix, null, (float[])acceleration, (float[])magnetic)) {
            float[] baseOrientation = new float[3];
            SensorManager.getOrientation((float[])rotationMatrix, (float[])baseOrientation);
            return baseOrientation;
        }
        return null;
    }

    protected Quaternion getGyroscopeRotationVector(Quaternion previousRotationVector, float[] rateOfRotation, float dt) {
        float magnitude = (float)Math.sqrt(Math.pow(rateOfRotation[0], 2.0) + Math.pow(rateOfRotation[1], 2.0) + Math.pow(rateOfRotation[2], 2.0));
        if (magnitude > 1.0E-9f) {
            rateOfRotation[0] = rateOfRotation[0] / magnitude;
            rateOfRotation[1] = rateOfRotation[1] / magnitude;
            rateOfRotation[2] = rateOfRotation[2] / magnitude;
        }
        float thetaOverTwo = magnitude * dt / 2.0f;
        float sinThetaOverTwo = (float)Math.sin(thetaOverTwo);
        float cosThetaOverTwo = (float)Math.cos(thetaOverTwo);
        double[] deltaVector = new double[]{sinThetaOverTwo * rateOfRotation[0], sinThetaOverTwo * rateOfRotation[1], sinThetaOverTwo * rateOfRotation[2], cosThetaOverTwo};
        return previousRotationVector.multiply(new Quaternion(deltaVector[3], Arrays.copyOfRange(deltaVector, 0, 3)));
    }

    protected void initializeRotationVectorGyroscopeIfRequired(Quaternion rotationVectorAccelerationMagnetic) {
        this.rotationVectorGyroscope = new Quaternion(rotationVectorAccelerationMagnetic.getScalarPart(), rotationVectorAccelerationMagnetic.getVectorPart());
    }

    private float[] getFusedOrientation(float[] gyroscope) {
        long timestamp = System.nanoTime();
        if (this.accelerationUpdated && this.magneticUpdated) {
            if (this.timestamp == 0L) {
                this.timestamp = System.nanoTime();
            }
            float dt = (float)(timestamp - this.timestamp) * 1.0E-9f;
            this.timestamp = timestamp;
            return this.calculateFusedOrientation(gyroscope, dt, this.acceleration, this.magnetic);
        }
        return new float[3];
    }
}

