/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.math.magnetic.tilt;

public class TiltCompensation {
    public static float[] getRotationFromAcceleration(float[] acceleration) {
        float gpx = acceleration[0];
        float gpy = acceleration[1];
        float gpz = acceleration[2];
        float phi = (float)Math.atan2(gpy, gpz);
        float the = (float)Math.atan2(-gpx, gpz);
        return new float[]{phi, the, 0.0f};
    }

    public static float[] compensateTilt(float[] magnetic, float[] rotation) {
        float bpx = magnetic[0];
        float bpy = magnetic[1];
        float bpz = magnetic[2];
        float sin = (float)Math.sin(rotation[0]);
        float cos = (float)Math.cos(rotation[0]);
        float bfy = bpy * cos - bpz * sin;
        bpz = bpy * sin + bpz * cos;
        sin = (float)Math.sin(rotation[1]);
        cos = (float)Math.cos(rotation[1]);
        float bfx = bpx * cos + bpz * sin;
        float bfz = -bpx * sin + bpz * cos;
        return new float[]{bfx, bfy, bfz};
    }
}

