/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.rotation.raw;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.tracqi.fsensor.filter.LowPassFilter;
import com.tracqi.fsensor.math.gravity.Gravity;
import com.tracqi.fsensor.rotation.Rotation;

public class AccelerationRotation
implements Rotation {
    private final float[] rotation = new float[3];
    private final SensorEventListener sensorEventListener = new SensorListener();
    private final SensorManager sensorManager;
    private final LowPassFilter lowPassFilter;

    public AccelerationRotation(SensorManager sensorManager, LowPassFilter lowPassFilter) {
        this.sensorManager = sensorManager;
        this.lowPassFilter = lowPassFilter;
    }

    @Override
    public void start(int sensorDelay) {
        this.sensorManager.registerListener(this.sensorEventListener, this.sensorManager.getDefaultSensor(1), sensorDelay);
    }

    @Override
    public void stop() {
        this.sensorManager.unregisterListener(this.sensorEventListener);
    }

    @Override
    public float[] getOrientation() {
        return this.rotation;
    }

    private class SensorListener
    implements SensorEventListener {
        private SensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                float[] rotation = Gravity.getOrientationFromGravity(AccelerationRotation.this.lowPassFilter.filter(event.values));
                AccelerationRotation.this.rotation[0] = rotation[0];
                AccelerationRotation.this.rotation[1] = rotation[1];
                AccelerationRotation.this.rotation[2] = rotation[2];
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

