/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.math.offset;

import android.util.Log;
import com.tracqi.fsensor.math.offset.Calibration;
import com.tracqi.fsensor.math.offset.FitPoints;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;

public class CalibrationUtil {
    private static final String TAG = CalibrationUtil.class.getSimpleName();

    public static Calibration getCalibration(FitPoints fitPoints) {
        int i;
        Array2DRowRealMatrix scalar = new Array2DRowRealMatrix(3, 3);
        double max = fitPoints.riv.getEntry(0);
        double min = fitPoints.riv.getEntry(0);
        int maxi = 0;
        int midi = 0;
        int mini = 0;
        for (i = 0; i < fitPoints.riv.getDimension(); ++i) {
            if (fitPoints.riv.getEntry(i) > max) {
                max = fitPoints.riv.getEntry(i);
                mini = i;
            }
            if (!(fitPoints.riv.getEntry(i) < min)) continue;
            min = fitPoints.riv.getEntry(i);
            maxi = i;
        }
        for (i = 0; i < fitPoints.riv.getDimension(); ++i) {
            if (!(fitPoints.riv.getEntry(i) < max) || !(fitPoints.riv.getEntry(i) > min)) continue;
            midi = i;
        }
        scalar.setEntry(0, 0, 1.0 / fitPoints.radii.getEntry(mini));
        scalar.setEntry(1, 1, 1.0 / fitPoints.radii.getEntry(midi));
        scalar.setEntry(2, 2, 1.0 / fitPoints.radii.getEntry(maxi));
        return new Calibration((RealMatrix)scalar, fitPoints.center);
    }

    public static float[] calibrate(float[] vector, Calibration calibration) {
        ArrayRealVector point = new ArrayRealVector(3);
        point.setEntry(0, (double)vector[0]);
        point.setEntry(1, (double)vector[1]);
        point.setEntry(2, (double)vector[2]);
        point = calibration.scalar.operate(point.subtract(calibration.offset));
        vector[0] = (float)point.getEntry(0);
        vector[1] = (float)point.getEntry(1);
        vector[2] = (float)point.getEntry(2);
        return vector;
    }

    private void log(double maxi, double midi, double mini) {
        Log.d((String)TAG, (String)("max :" + maxi));
        Log.d((String)TAG, (String)("mid :" + midi));
        Log.d((String)TAG, (String)("min :" + mini));
    }
}

