/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.filter;

import com.tracqi.fsensor.filter.SensorFilter;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;

public class MedianFilter
extends SensorFilter {
    private static final String tag = MedianFilter.class.getSimpleName();
    private final ArrayDeque<float[]> values = new ArrayDeque();

    public MedianFilter() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public MedianFilter(float timeConstant) {
        this.timeConstant = timeConstant;
    }

    @Override
    public float[] filter(float[] data) {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
        float hz = (float)this.count++ / ((float)(System.nanoTime() - this.startTime) / 1.0E9f);
        int filterWindow = (int)Math.ceil(hz * this.timeConstant);
        this.values.addLast(Arrays.copyOf(data, data.length));
        while (this.values.size() > filterWindow) {
            this.values.removeFirst();
        }
        if (!this.values.isEmpty()) {
            float[] median = this.getMedian(this.values);
            System.arraycopy(median, 0, this.output, 0, this.output.length);
        } else {
            System.arraycopy(data, 0, this.output, 0, data.length);
        }
        return this.output;
    }

    private float[] getMedian(ArrayDeque<float[]> data) {
        float[] mean = new float[data.getFirst().length];
        double[][] values = new double[data.getFirst().length][data.size()];
        int index = 0;
        for (float[] axis : data) {
            for (int i = 0; i < axis.length; ++i) {
                values[i][index] = axis[i];
            }
            ++index;
        }
        for (int i = 0; i < mean.length; ++i) {
            mean[i] = (float)StatUtils.percentile((double[])values[i], (double)50.0);
        }
        return mean;
    }
}

