/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.math.offset;

import android.util.Log;
import com.tracqi.fsensor.math.offset.ThreeSpacePoint;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class FitPoints {
    private static final String TAG = FitPoints.class.getSimpleName();
    public RealVector center;
    public double[] evals;
    public RealVector radii;
    public RealVector evecs;
    public RealVector evecs1;
    public RealVector evecs2;
    public RealVector riv;

    public FitPoints(ArrayList<ThreeSpacePoint> points) {
        RealVector v = this.solveSystem(points);
        RealMatrix a = this.formAlgebraicMatrix(v);
        this.center = this.findCenter(a);
        RealMatrix r = this.translateToCenter(this.center, a);
        RealMatrix subr = r.getSubMatrix(0, 2, 0, 2);
        this.riv = this.generateRIV(subr);
        double divr = -r.getEntry(3, 3);
        for (int i = 0; i < subr.getRowDimension(); ++i) {
            for (int j = 0; j < subr.getRowDimension(); ++j) {
                subr.setEntry(i, j, subr.getEntry(i, j) / divr);
            }
        }
        EigenDecomposition ed = new EigenDecomposition(subr, 0.0);
        this.evals = ed.getRealEigenvalues();
        this.evecs = ed.getEigenvector(0);
        this.evecs1 = ed.getEigenvector(1);
        this.evecs2 = ed.getEigenvector(2);
        this.radii = this.findRadii(this.evals);
    }

    private RealVector solveSystem(ArrayList<ThreeSpacePoint> points) {
        int numPoints = points.size();
        Array2DRowRealMatrix d = new Array2DRowRealMatrix(numPoints, 9);
        for (int i = 0; i < d.getRowDimension(); ++i) {
            double xx = Math.pow(points.get((int)i).x, 2.0);
            double yy = Math.pow(points.get((int)i).y, 2.0);
            double zz = Math.pow(points.get((int)i).z, 2.0);
            double xy = 2.0 * (points.get((int)i).x * points.get((int)i).y);
            double xz = 2.0 * (points.get((int)i).x * points.get((int)i).z);
            double yz = 2.0 * (points.get((int)i).y * points.get((int)i).z);
            double x = 2.0 * points.get((int)i).x;
            double y = 2.0 * points.get((int)i).y;
            double z = 2.0 * points.get((int)i).z;
            d.setEntry(i, 0, xx);
            d.setEntry(i, 1, yy);
            d.setEntry(i, 2, zz);
            d.setEntry(i, 3, xy);
            d.setEntry(i, 4, xz);
            d.setEntry(i, 5, yz);
            d.setEntry(i, 6, x);
            d.setEntry(i, 7, y);
            d.setEntry(i, 8, z);
        }
        RealMatrix dtd = d.transpose().multiply((RealMatrix)d);
        ArrayRealVector ones = new ArrayRealVector(numPoints);
        ones.mapAddToSelf(1.0);
        RealVector dtOnes = d.transpose().operate((RealVector)ones);
        DecompositionSolver solver = new SingularValueDecomposition(dtd).getSolver();
        RealMatrix dtdi = solver.getInverse();
        return dtdi.operate(dtOnes);
    }

    private RealMatrix formAlgebraicMatrix(RealVector v) {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(4, 4);
        a.setEntry(0, 0, v.getEntry(0));
        a.setEntry(0, 1, v.getEntry(3));
        a.setEntry(0, 2, v.getEntry(4));
        a.setEntry(0, 3, v.getEntry(6));
        a.setEntry(1, 0, v.getEntry(3));
        a.setEntry(1, 1, v.getEntry(1));
        a.setEntry(1, 2, v.getEntry(5));
        a.setEntry(1, 3, v.getEntry(7));
        a.setEntry(2, 0, v.getEntry(4));
        a.setEntry(2, 1, v.getEntry(5));
        a.setEntry(2, 2, v.getEntry(2));
        a.setEntry(2, 3, v.getEntry(8));
        a.setEntry(3, 0, v.getEntry(6));
        a.setEntry(3, 1, v.getEntry(7));
        a.setEntry(3, 2, v.getEntry(8));
        a.setEntry(3, 3, -1.0);
        return a;
    }

    private RealVector findCenter(RealMatrix a) {
        RealMatrix subA = a.getSubMatrix(0, 2, 0, 2);
        for (int q = 0; q < subA.getRowDimension(); ++q) {
            for (int s = 0; s < subA.getColumnDimension(); ++s) {
                subA.multiplyEntry(q, s, -1.0);
            }
        }
        RealVector subV = a.getRowVector(3).getSubVector(0, 3);
        DecompositionSolver solver = new SingularValueDecomposition(subA).getSolver();
        RealMatrix subAi = solver.getInverse();
        return subAi.operate(subV);
    }

    private RealMatrix translateToCenter(RealVector center, RealMatrix a) {
        RealMatrix t = MatrixUtils.createRealIdentityMatrix((int)4);
        Array2DRowRealMatrix centerMatrix = new Array2DRowRealMatrix(1, 3);
        centerMatrix.setRowVector(0, center);
        t.setSubMatrix(centerMatrix.getData(), 3, 0);
        return t.multiply(a).multiply(t.transpose());
    }

    private RealVector generateRIV(RealMatrix subr) {
        this.riv = new ArrayRealVector(3);
        this.riv.setEntry(0, Math.abs(subr.getEntry(0, 0)));
        this.riv.setEntry(1, Math.abs(subr.getEntry(1, 1)));
        this.riv.setEntry(2, Math.abs(subr.getEntry(2, 2)));
        return this.riv;
    }

    private RealVector findRadii(double[] evals) {
        ArrayRealVector radii = new ArrayRealVector(evals.length);
        for (int i = 0; i < evals.length; ++i) {
            radii.setEntry(i, Math.sqrt(1.0 / evals[i]));
        }
        return radii;
    }

    public void printLog() {
        Log.d((String)TAG, (String)this.riv.toString());
        for (double eval : this.evals) {
            Log.d((String)TAG, (String)Arrays.toString(this.evals));
        }
        Log.d((String)TAG, (String)this.evecs.toString());
        Log.d((String)TAG, (String)this.evecs1.toString());
        Log.d((String)TAG, (String)this.evecs2.toString());
        Log.d((String)TAG, (String)("Center: " + this.center.toString()));
        Log.d((String)TAG, (String)(" Radii: " + this.radii.toString()));
    }
}

