/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.sensor.acceleration;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.averaging.LowPassFilter;
import com.kircherelectronics.fsensor.linearacceleration.LinearAcceleration;
import com.kircherelectronics.fsensor.linearacceleration.LinearAccelerationAveraging;
import com.kircherelectronics.fsensor.observer.SensorSubject;
import com.kircherelectronics.fsensor.sensor.FSensor;

public class LowPassLinearAccelerationSensor
implements FSensor {
    private static final String TAG = LowPassLinearAccelerationSensor.class.getSimpleName();
    private final SensorManager sensorManager;
    private final SimpleSensorListener listener;
    private float startTime = 0.0f;
    private int count = 0;
    private float[] rawAcceleration = new float[3];
    private float[] acceleration = new float[3];
    private float[] output = new float[4];
    private LinearAcceleration linearAccelerationFilterLpf;
    private LowPassFilter lpfGravity;
    private int sensorDelay = 0;
    private final SensorSubject sensorSubject;

    public LowPassLinearAccelerationSensor(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.listener = new SimpleSensorListener();
        this.sensorSubject = new SensorSubject();
        this.initializeFSensorFusions();
    }

    @Override
    public void start() {
        this.startTime = 0.0f;
        this.count = 0;
        this.registerSensors(this.sensorDelay);
    }

    @Override
    public void stop() {
        this.unregisterSensors();
    }

    @Override
    public void register(SensorSubject.SensorObserver sensorObserver) {
        this.sensorSubject.register(sensorObserver);
    }

    @Override
    public void unregister(SensorSubject.SensorObserver sensorObserver) {
        this.sensorSubject.unregister(sensorObserver);
    }

    public void setSensorDelay(int sensorDelay) {
        if (sensorDelay != 0 && sensorDelay != 1 && sensorDelay != 3 && sensorDelay != 2) {
            throw new IllegalStateException("Sensor Frequency must be SensorManager.SENSOR_DELAY_FASTEST, SensorManager.SENSOR_DELAY_GAME, SensorManager.SENSOR_DELAY_NORMAL or SensorManager.SENSOR_DELAY_UI");
        }
        this.sensorDelay = sensorDelay;
    }

    public void setFSensorLpfLinearAccelerationTimeConstant(float timeConstant) {
        this.lpfGravity.setTimeConstant(timeConstant);
    }

    @Override
    public void reset() {
        this.stop();
        this.acceleration = new float[3];
        this.rawAcceleration = new float[3];
        this.output = new float[4];
        this.start();
    }

    private float calculateSensorFrequency() {
        if (this.startTime == 0.0f) {
            this.startTime = System.nanoTime();
        }
        long timestamp = System.nanoTime();
        return (float)this.count++ / (((float)timestamp - this.startTime) / 1.0E9f);
    }

    private float[] invert(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = -values[i];
        }
        return values;
    }

    private void initializeFSensorFusions() {
        this.lpfGravity = new LowPassFilter();
        this.linearAccelerationFilterLpf = new LinearAccelerationAveraging(this.lpfGravity);
    }

    private void processRawAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.rawAcceleration, 0, this.rawAcceleration.length);
    }

    private void processAcceleration(float[] acceleration) {
        System.arraycopy(acceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void registerSensors(int sensorDelay) {
        this.lpfGravity.reset();
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(1), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener((SensorEventListener)this.listener);
    }

    private void setOutput(float[] value) {
        System.arraycopy(value, 0, this.output, 0, value.length);
        this.output[3] = this.calculateSensorFrequency();
        this.sensorSubject.onNext(this.output);
    }

    private class SimpleSensorListener
    implements SensorEventListener {
        private SimpleSensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                LowPassLinearAccelerationSensor.this.processRawAcceleration(event.values);
                LowPassLinearAccelerationSensor.this.lpfGravity.filter(LowPassLinearAccelerationSensor.this.rawAcceleration);
                LowPassLinearAccelerationSensor.this.processAcceleration(LowPassLinearAccelerationSensor.this.linearAccelerationFilterLpf.filter(LowPassLinearAccelerationSensor.this.rawAcceleration));
                LowPassLinearAccelerationSensor.this.setOutput(LowPassLinearAccelerationSensor.this.acceleration);
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

