/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.averaging;

import com.kircherelectronics.fsensor.filter.averaging.AveragingFilter;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;

public class MedianFilter
extends AveragingFilter {
    private static final String tag = MedianFilter.class.getSimpleName();
    private final ArrayDeque<float[]> values;
    private float[] output;

    public MedianFilter() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public MedianFilter(float timeConstant) {
        this.timeConstant = timeConstant;
        this.values = new ArrayDeque();
        this.reset();
    }

    @Override
    public float[] filter(float[] data) {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
        this.timestamp = System.nanoTime();
        float hz = (float)this.count++ / ((float)(this.timestamp - this.startTime) / 1.0E9f);
        int filterWindow = (int)Math.ceil(hz * this.timeConstant);
        this.values.addLast(Arrays.copyOf(data, data.length));
        while (this.values.size() > filterWindow) {
            this.values.removeFirst();
        }
        if (!this.values.isEmpty()) {
            this.output = this.getMean(this.values);
        } else {
            this.output = new float[data.length];
            System.arraycopy(data, 0, this.output, 0, data.length);
        }
        return this.output;
    }

    @Override
    public float[] getOutput() {
        return this.output;
    }

    private float[] getMean(ArrayDeque<float[]> data) {
        float[] mean = new float[data.getFirst().length];
        double[][] values = new double[data.getFirst().length][data.size()];
        int index = 0;
        for (float[] axis : data) {
            for (int i = 0; i < axis.length; ++i) {
                values[i][index] = axis[i];
            }
            ++index;
        }
        for (int i = 0; i < mean.length; ++i) {
            mean[i] = (float)StatUtils.percentile((double[])values[i], (double)50.0);
        }
        return mean;
    }

    public void setTimeConstant(float timeConstant) {
        this.timeConstant = timeConstant;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.values != null) {
            this.values.clear();
        }
    }
}

