/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.sensor.gyroscope;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.complimentary.OrientationFusedComplimentary;
import com.kircherelectronics.fsensor.sensor.FSensor;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import io.reactivex.subjects.PublishSubject;

public class ComplimentaryGyroscopeSensor
implements FSensor {
    private static final String TAG = ComplimentaryGyroscopeSensor.class.getSimpleName();
    private SensorManager sensorManager;
    private SimpleSensorListener listener;
    private float startTime = 0.0f;
    private int count = 0;
    private boolean hasAcceleration = false;
    private boolean hasMagnetic = false;
    private float[] magnetic = new float[3];
    private float[] acceleration = new float[3];
    private float[] rotation = new float[3];
    private float[] output = new float[4];
    private OrientationFusedComplimentary orientationFusionComplimentary;
    private int sensorFrequency = 0;
    private PublishSubject<float[]> publishSubject;

    public ComplimentaryGyroscopeSensor(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.listener = new SimpleSensorListener();
        this.publishSubject = PublishSubject.create();
        this.initializeFSensorFusions();
    }

    @Override
    public PublishSubject<float[]> getPublishSubject() {
        return this.publishSubject;
    }

    public void onStart() {
        this.startTime = 0.0f;
        this.count = 0;
        this.registerSensors(this.sensorFrequency);
    }

    public void onStop() {
        this.unregisterSensors();
    }

    public void setSensorFrequency(int sensorFrequency) {
        this.sensorFrequency = sensorFrequency;
    }

    public void setFSensorComplimentaryTimeConstant(float timeConstant) {
        this.orientationFusionComplimentary.setTimeConstant(timeConstant);
    }

    public void reset() {
        this.onStop();
        this.magnetic = new float[3];
        this.acceleration = new float[3];
        this.rotation = new float[3];
        this.output = new float[4];
        this.hasAcceleration = false;
        this.hasMagnetic = false;
        this.onStart();
    }

    private float calculateSensorFrequency() {
        if (this.startTime == 0.0f) {
            this.startTime = System.nanoTime();
        }
        long timestamp = System.nanoTime();
        return (float)this.count++ / (((float)timestamp - this.startTime) / 1.0E9f);
    }

    private void initializeFSensorFusions() {
        this.orientationFusionComplimentary = new OrientationFusedComplimentary();
    }

    private void processAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void processMagnetic(float[] magnetic) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, this.magnetic.length);
    }

    private void processRotation(float[] rotation) {
        System.arraycopy(rotation, 0, this.rotation, 0, this.rotation.length);
    }

    private void registerSensors(int sensorDelay) {
        this.orientationFusionComplimentary.reset();
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(16), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener((SensorEventListener)this.listener);
    }

    private void setValue(float[] value) {
        System.arraycopy(value, 0, this.output, 0, value.length);
        this.output[3] = this.calculateSensorFrequency();
        this.publishSubject.onNext((Object)this.output);
    }

    private class SimpleSensorListener
    implements SensorEventListener {
        private int sensorEventThreshold = 100;
        private int numAccelerationEvents = 0;
        private int numMagneticEvents = 0;

        private SimpleSensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                ComplimentaryGyroscopeSensor.this.processAcceleration(event.values);
                if (this.numAccelerationEvents++ > this.sensorEventThreshold) {
                    ComplimentaryGyroscopeSensor.this.hasAcceleration = true;
                }
            } else if (event.sensor.getType() == 2) {
                ComplimentaryGyroscopeSensor.this.processMagnetic(event.values);
                if (this.numMagneticEvents++ > this.sensorEventThreshold) {
                    ComplimentaryGyroscopeSensor.this.hasMagnetic = true;
                }
            } else if (event.sensor.getType() == 16) {
                ComplimentaryGyroscopeSensor.this.processRotation(event.values);
                if (!ComplimentaryGyroscopeSensor.this.orientationFusionComplimentary.isBaseOrientationSet()) {
                    if (ComplimentaryGyroscopeSensor.this.hasAcceleration && ComplimentaryGyroscopeSensor.this.hasMagnetic) {
                        ComplimentaryGyroscopeSensor.this.orientationFusionComplimentary.setBaseOrientation(RotationUtil.getOrientationVectorFromAccelerationMagnetic(ComplimentaryGyroscopeSensor.this.acceleration, ComplimentaryGyroscopeSensor.this.magnetic));
                    }
                } else {
                    ComplimentaryGyroscopeSensor.this.setValue(ComplimentaryGyroscopeSensor.this.orientationFusionComplimentary.calculateFusedOrientation(ComplimentaryGyroscopeSensor.this.rotation, event.timestamp, ComplimentaryGyroscopeSensor.this.acceleration, ComplimentaryGyroscopeSensor.this.magnetic));
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

