/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.download.library.DownloadException;
import com.download.library.DownloadListener;
import com.download.library.DownloadNotifier;
import com.download.library.DownloadTask;
import com.download.library.DownloadingListener;
import com.download.library.ExecuteTask;
import com.download.library.ExecuteTasksMap;
import com.download.library.IDownloader;
import com.download.library.Runtime;
import com.download.library.SerialExecutor;
import com.download.library.StorageEngine;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class Downloader
extends AsyncTask<Void, Integer, Integer>
implements IDownloader<DownloadTask>,
ExecuteTask {
    protected volatile DownloadTask mDownloadTask;
    private volatile long mLoaded = 0L;
    protected volatile long mTotals = -1L;
    private long mLastLoaded = 0L;
    private long mUsedTime = 0L;
    private long mLastTime = 0L;
    private volatile long mBeginTime = 0L;
    private volatile long mAverageSpeed = 0L;
    protected volatile Throwable mThrowable;
    protected long mDownloadTimeOut = Long.MAX_VALUE;
    protected long mConnectTimeOut = 10000L;
    private DownloadNotifier mDownloadNotifier;
    private static final String TAG = "Download-" + Downloader.class.getSimpleName();
    protected AtomicBoolean mIsCanceled = new AtomicBoolean(false);
    protected AtomicBoolean mIsPaused = new AtomicBoolean(false);
    protected AtomicBoolean mIsShutdown = new AtomicBoolean(false);
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_REDIRECTS = 7;
    private static final int HTTP_TEMP_REDIRECT = 307;
    public static final int ERROR_NETWORK_CONNECTION = 1024;
    public static final int ERROR_RESPONSE_STATUS = 1025;
    public static final int ERROR_STORAGE = 1026;
    public static final int ERROR_TIME_OUT = 1027;
    public static final int ERROR_USER_PAUSE = 1028;
    public static final int ERROR_USER_CANCEL = 1030;
    public static final int ERROR_SHUTDOWN = 1031;
    public static final int ERROR_TOO_MANY_REDIRECTS = 1032;
    public static final int ERROR_LOAD = 1033;
    public static final int ERROR_RESOURCE_NOT_FOUND = 1040;
    public static final int ERROR_MD5 = 1041;
    public static final int ERROR_SERVICE = 1283;
    public static final int SUCCESSFUL = 512;
    public static final int HTTP_RANGE_NOT_SATISFIABLE = 416;
    protected static final SparseArray<String> DOWNLOAD_MESSAGE = new SparseArray(12);
    protected static final Executor SERIAL_EXECUTOR = new SerialExecutor();
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    protected volatile boolean enableProgress = false;
    protected boolean mCallbackInMainThread = false;
    protected boolean quickProgress = false;

    protected Downloader() {
    }

    void checkIsNullTask(DownloadTask downloadTask) {
        if (null == downloadTask) {
            throw new NullPointerException("downloadTask can't be null.");
        }
        if (null == downloadTask.getContext()) {
            throw new NullPointerException("context can't be null.");
        }
    }

    protected void onPreExecute() {
        DownloadTask downloadTask = this.mDownloadTask;
        if (null == downloadTask) {
            throw new NullPointerException("DownloadTask can't be null ");
        }
        if (null == downloadTask.getFile()) {
            File file = downloadTask.isUniquePath() ? Runtime.getInstance().uniqueFile(downloadTask, null) : Runtime.getInstance().createFile(downloadTask.mContext, downloadTask);
            downloadTask.setFileSafe(file);
        } else if (downloadTask.getFile().isDirectory()) {
            File file = downloadTask.isUniquePath() ? Runtime.getInstance().uniqueFile(downloadTask, downloadTask.getFile()) : Runtime.getInstance().createFile(downloadTask.mContext, downloadTask, downloadTask.getFile());
            downloadTask.setFileSafe(file);
        } else if (!downloadTask.getFile().exists()) {
            try {
                downloadTask.getFile().createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                downloadTask.setFileSafe(null);
            }
        }
        if (null == downloadTask.getFile()) {
            throw new RuntimeException("target file can't be created . ");
        }
        this.createNotifier();
        if (null != this.mDownloadNotifier) {
            this.mDownloadNotifier.onPreDownload();
        }
    }

    private boolean checkSpace() {
        DownloadTask downloadTask = this.mDownloadTask;
        if (downloadTask.getTotalsLength() - downloadTask.getFile().length() > this.getAvailableStorage() - 0x6400000L) {
            Runtime.getInstance().logError(TAG, " \u7a7a\u95f4\u4e0d\u8db3");
            return false;
        }
        return true;
    }

    private long getAvailableStorage() {
        try {
            StatFs stat = new StatFs(Environment.getExternalStorageDirectory().toString());
            if (Build.VERSION.SDK_INT >= 18) {
                return stat.getAvailableBlocksLong() * stat.getBlockSizeLong();
            }
            return (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
        }
        catch (RuntimeException ex) {
            return 0L;
        }
    }

    private boolean checkNet() {
        DownloadTask downloadTask = this.mDownloadTask;
        if (!downloadTask.isForceDownload()) {
            return Runtime.getInstance().checkWifi(downloadTask.getContext());
        }
        return Runtime.getInstance().checkNetwork(downloadTask.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer doInBackground(Void ... params) {
        int result = 1033;
        this.mBeginTime = SystemClock.elapsedRealtime();
        if (!this.checkNet()) {
            Runtime.getInstance().logError(TAG, " Network error,isForceDownload:" + this.mDownloadTask.isForceDownload());
            return 1024;
        }
        DownloadTask downloadTask = this.mDownloadTask;
        if (this.mIsPaused.get()) {
            return 1028;
        }
        if (this.mIsCanceled.get()) {
            return 1030;
        }
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName("pool-download-thread-" + Runtime.getInstance().generateGlobalThreadId());
        try {
            downloadTask.setStatus(1002);
            IOException ioException = null;
            for (int i = 0; i <= downloadTask.retry; ++i) {
                block10: {
                    try {
                        result = this.doDownload();
                    }
                    catch (IOException e) {
                        ioException = e;
                        this.mThrowable = ioException;
                        result = 1033;
                        if (!Runtime.getInstance().isDebug()) break block10;
                        e.printStackTrace();
                    }
                }
                if (ioException == null) {
                    break;
                }
                if (i + 1 > downloadTask.retry) continue;
                Runtime.getInstance().logError(TAG, "download error , retry " + (i + 1));
            }
        }
        finally {
            Thread.currentThread().setName(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDownload() throws IOException {
        DownloadTask downloadTask = this.mDownloadTask;
        downloadTask.updateTime(this.mBeginTime);
        downloadTask.resetConnectTimes();
        int redirectionCount = 0;
        URL url = new URL(downloadTask.getUrl());
        HttpURLConnection httpURLConnection = null;
        try {
            int n;
            block26: while (redirectionCount++ <= 7) {
                if (null != httpURLConnection) {
                    httpURLConnection.disconnect();
                }
                if (downloadTask.connectTimes <= 0) {
                    httpURLConnection = this.createUrlConnection(url);
                    this.settingHeaders(downloadTask, httpURLConnection);
                    httpURLConnection.connect();
                } else {
                    httpURLConnection = this.createUrlConnection(url);
                    this.settingHeaders(downloadTask, httpURLConnection);
                    this.rangeHeaders(downloadTask, httpURLConnection);
                    httpURLConnection.connect();
                }
                if (this.mIsPaused.get()) {
                    n = 1028;
                    return n;
                }
                if (this.mIsCanceled.get()) {
                    n = 1030;
                    return n;
                }
                boolean isEncodingChunked = "chunked".equalsIgnoreCase(httpURLConnection.getHeaderField("Transfer-Encoding"));
                long contentLength = -1L;
                contentLength = this.getHeaderFieldLong(httpURLConnection, "Content-Length");
                boolean hasLength = contentLength > 0L;
                boolean finishKnown = isEncodingChunked && hasLength || !isEncodingChunked && !hasLength;
                int responseCode = httpURLConnection.getResponseCode();
                Runtime.getInstance().log(TAG, "responseCode:" + responseCode);
                if (responseCode == 206 && !hasLength) {
                    int n2 = 512;
                    return n2;
                }
                switch (responseCode) {
                    case 200: {
                        if (finishKnown) {
                            Runtime.getInstance().logError(TAG, " error , giving up ,  EncodingChunked:" + isEncodingChunked + "  hasLength:" + hasLength + " response length:" + contentLength + " responseCode:" + responseCode);
                            int n3 = 1033;
                            return n3;
                        }
                        this.mTotals = contentLength;
                        if (downloadTask.connectTimes <= 0) {
                            this.start(httpURLConnection);
                            ++downloadTask.connectTimes;
                            if (downloadTask.getFile().length() > 0L && !isEncodingChunked) {
                                if (downloadTask.getFile().length() == contentLength) {
                                    int compareResult = Runtime.getInstance().getFileComparator().compare(downloadTask.getUrl(), downloadTask.getFile(), downloadTask.getTargetCompareMD5(), Runtime.getInstance().md5(downloadTask.getFile()));
                                    if (compareResult == 1) {
                                        this.mLastLoaded = contentLength;
                                        if (this.mCallbackInMainThread) {
                                            this.publishProgress(new Integer[]{1});
                                        } else {
                                            this.onProgressUpdate(1);
                                        }
                                        int n4 = 512;
                                        return n4;
                                    }
                                    if (compareResult == 2) {
                                        downloadTask.getFile().delete();
                                        downloadTask.getFile().createNewFile();
                                        continue block26;
                                    }
                                    String fileName0 = "(" + (new File(downloadTask.getFile().getParent()).list().length - 1) + ")" + downloadTask.getFile().getName();
                                    String fileName1 = "(" + new File(downloadTask.getFile().getParent()).list().length + ")" + downloadTask.getFile().getName();
                                    File renameTarget0 = new File(downloadTask.getFile().getParent(), fileName0);
                                    File renameTarget1 = new File(downloadTask.getFile().getParent(), fileName1);
                                    if (renameTarget0.exists() && renameTarget0.length() < contentLength) {
                                        downloadTask.setFileSafe(renameTarget0);
                                    } else if (renameTarget1.exists() && renameTarget1.length() >= contentLength) {
                                        renameTarget1.delete();
                                        renameTarget1.createNewFile();
                                        downloadTask.setFileSafe(renameTarget1);
                                    } else {
                                        if (!renameTarget1.exists()) {
                                            renameTarget1.createNewFile();
                                        }
                                        downloadTask.setFileSafe(renameTarget1);
                                    }
                                    Runtime.getInstance().log(TAG, "rename download , new file name:" + downloadTask.getFile().getName());
                                    continue block26;
                                }
                                if (downloadTask.getFile().length() < contentLength) continue block26;
                                Runtime.getInstance().log(TAG, " file length error .");
                                downloadTask.getFile().delete();
                                downloadTask.getFile().createNewFile();
                                continue block26;
                            }
                        }
                        if (isEncodingChunked) {
                            this.mTotals = -1L;
                        } else if (downloadTask.getFile().length() >= contentLength) {
                            this.mTotals = contentLength;
                            int compareResult = 512;
                            return compareResult;
                        }
                        downloadTask.setTotalsLength(this.mTotals);
                        if (!isEncodingChunked && !this.checkSpace()) {
                            int compareResult = 1026;
                            return compareResult;
                        }
                        this.saveEtag(httpURLConnection);
                        downloadTask.setTotalsLength(this.mTotals);
                        int compareResult = this.transferData(this.getInputStream(httpURLConnection), new LoadingRandomAccessFile(downloadTask.getFile()), false);
                        return compareResult;
                    }
                    case 206: {
                        if (finishKnown) {
                            Runtime.getInstance().logError(TAG, " error , giving up ,  EncodingChunked:" + isEncodingChunked + "  hasLength:" + hasLength + " response length:" + contentLength + " responseCode:" + responseCode);
                            int compareResult = 1033;
                            return compareResult;
                        }
                        if (isEncodingChunked) {
                            this.mTotals = -1L;
                        } else {
                            if (this.mTotals > 0L && contentLength + downloadTask.getFile().length() != this.mTotals) {
                                int compareResult = 1033;
                                return compareResult;
                            }
                            if (this.mTotals <= 0L) {
                                this.mTotals = contentLength + downloadTask.getFile().length();
                            }
                        }
                        downloadTask.setTotalsLength(this.mTotals);
                        if (!isEncodingChunked && !this.checkSpace()) {
                            int compareResult = 1026;
                            return compareResult;
                        }
                        int compareResult = this.transferData(this.getInputStream(httpURLConnection), new LoadingRandomAccessFile(downloadTask.getFile()), !isEncodingChunked);
                        return compareResult;
                    }
                    case 416: {
                        if (null == downloadTask.getFile()) break;
                        Runtime.getInstance().log(TAG, " range not satisfiable .");
                        downloadTask.getFile().delete();
                        downloadTask.getFile().createNewFile();
                        break;
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: {
                        String location = httpURLConnection.getHeaderField("Location");
                        url = new URL(url, location);
                        continue block26;
                    }
                    case 404: {
                        int n5 = 1040;
                        return n5;
                    }
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: {
                        int n6 = 1283;
                        return n6;
                    }
                    default: {
                        int n7 = 1025;
                        return n7;
                    }
                }
            }
            n = 1032;
            return n;
        }
        finally {
            if (null != httpURLConnection) {
                httpURLConnection.disconnect();
            }
        }
    }

    private void rangeHeaders(DownloadTask downloadTask, HttpURLConnection httpURLConnection) {
        if (null != downloadTask.getFile() && downloadTask.getFile().length() > 0L) {
            this.mLastLoaded = downloadTask.getFile().length();
            httpURLConnection.setRequestProperty("Range", "bytes=" + this.mLastLoaded + "-");
        }
        httpURLConnection.setRequestProperty("Connection", "close");
    }

    private final void start(HttpURLConnection httpURLConnection) throws IOException {
        DownloadTask downloadTask = this.mDownloadTask;
        if (TextUtils.isEmpty((CharSequence)downloadTask.getContentDisposition())) {
            downloadTask.setContentDisposition(httpURLConnection.getHeaderField("Content-Disposition"));
            String fileName = Runtime.getInstance().getFileNameByContentDisposition(downloadTask.getContentDisposition());
            if (!TextUtils.isEmpty((CharSequence)fileName) && !downloadTask.getFile().getName().equals(fileName)) {
                File renameTarget = new File(downloadTask.getFile().getParent(), fileName);
                if (renameTarget.exists()) {
                    downloadTask.setFileSafe(renameTarget);
                    this.updateNotifierTitle();
                } else {
                    boolean success = downloadTask.getFile().renameTo(renameTarget);
                    if (success) {
                        downloadTask.setFileSafe(renameTarget);
                        this.updateNotifierTitle();
                    }
                }
            }
        }
        if (TextUtils.isEmpty((CharSequence)downloadTask.getMimetype())) {
            downloadTask.setMimetype(httpURLConnection.getHeaderField("Content-Type"));
        }
        if (TextUtils.isEmpty((CharSequence)downloadTask.getUserAgent())) {
            String ua = httpURLConnection.getHeaderField("User-Agent");
            if (ua == null) {
                ua = "";
            }
            downloadTask.setUserAgent(ua);
        }
        downloadTask.setContentLength(this.getHeaderFieldLong(httpURLConnection, "Content-Length"));
        this.onStart();
    }

    private void updateNotifierTitle() {
        DownloadTask downloadTask = this.mDownloadTask;
        if (null != this.mDownloadNotifier && null != downloadTask) {
            this.mDownloadNotifier.updateTitle(downloadTask);
        }
    }

    protected void onStart() throws IOException {
        final DownloadTask downloadTask = this.mDownloadTask;
        if (null != downloadTask && null != downloadTask.getDownloadListener()) {
            HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    downloadTask.getDownloadListener().onStart(downloadTask.mUrl, downloadTask.mUserAgent, downloadTask.mContentDisposition, downloadTask.mMimetype, downloadTask.mTotalsLength, downloadTask);
                }
            });
        }
    }

    private InputStream getInputStream(HttpURLConnection httpURLConnection) throws IOException {
        if ("gzip".equalsIgnoreCase(httpURLConnection.getContentEncoding())) {
            return new GZIPInputStream(httpURLConnection.getInputStream());
        }
        if ("deflate".equalsIgnoreCase(httpURLConnection.getContentEncoding())) {
            return new InflaterInputStream(httpURLConnection.getInputStream(), new Inflater(true));
        }
        return httpURLConnection.getInputStream();
    }

    private long getHeaderFieldLong(HttpURLConnection httpURLConnection, String name) {
        String field = httpURLConnection.getHeaderField(name);
        try {
            return null == field ? -1L : Long.parseLong(field);
        }
        catch (NumberFormatException e) {
            if (Runtime.getInstance().isDebug()) {
                e.printStackTrace();
            }
            return -1L;
        }
    }

    private void saveEtag(HttpURLConnection httpURLConnection) {
        String etag = httpURLConnection.getHeaderField("ETag");
        if (TextUtils.isEmpty((CharSequence)etag)) {
            return;
        }
        String url = this.mDownloadTask.getUrl();
        String urlMD5 = Runtime.getInstance().md5(url);
        Runtime.getInstance().log(TAG, "save etag:" + etag);
        StorageEngine storageEngine = Runtime.getInstance().getStorageEngine(this.mDownloadTask.mContext);
        storageEngine.save(urlMD5, etag);
    }

    private String getEtag() {
        String url = this.mDownloadTask.getUrl();
        String urlMD5 = Runtime.getInstance().md5(url);
        String mEtag = Runtime.getInstance().getStorageEngine(this.mDownloadTask.mContext).get(urlMD5, "-1");
        if (!TextUtils.isEmpty((CharSequence)mEtag) && !"-1".equals(mEtag)) {
            return mEtag;
        }
        return null;
    }

    private HttpURLConnection createUrlConnection(URL url) throws IOException {
        DownloadTask downloadTask = this.mDownloadTask;
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout((int)this.mConnectTimeOut);
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setReadTimeout((int)downloadTask.getBlockMaxTime());
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.setRequestProperty("Accept-Encoding", "deflate,gzip");
        return httpURLConnection;
    }

    private void settingHeaders(DownloadTask downloadTask, HttpURLConnection httpURLConnection) {
        Map<String, String> headers = null;
        headers = downloadTask.getHeaders();
        if (null != headers && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        String eTag = "";
        eTag = this.getEtag();
        if (!TextUtils.isEmpty((CharSequence)eTag)) {
            Runtime.getInstance().log(TAG, "Etag:" + eTag);
            httpURLConnection.setRequestProperty("If-Match", this.getEtag());
        }
        Runtime.getInstance().log(TAG, "settingHeaders");
    }

    protected void onProgressUpdate(Integer ... values) {
        DownloadTask downloadTask = this.mDownloadTask;
        try {
            long currentTime = SystemClock.elapsedRealtime();
            this.mUsedTime = currentTime - this.mBeginTime;
            this.mAverageSpeed = this.mUsedTime == 0L ? 0L : this.mLoaded * 1000L / this.mUsedTime;
            if (values != null && values.length > 0 && values[0] == 1 && null != this.mDownloadNotifier) {
                if (this.mTotals > 0L) {
                    int mProgress = (int)((float)(this.mLastLoaded + this.mLoaded) / Float.valueOf(this.mTotals).floatValue() * 100.0f);
                    this.mDownloadNotifier.onDownloading(mProgress);
                } else {
                    this.mDownloadNotifier.onDownloaded(this.mLastLoaded + this.mLoaded);
                }
            }
            if (null != downloadTask.getDownloadListener()) {
                downloadTask.getDownloadingListener().onProgress(downloadTask.getUrl(), this.mLastLoaded + this.mLoaded, this.mTotals, downloadTask.getUsedTime());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPostExecute(Integer integer) {
        DownloadTask downloadTask = this.mDownloadTask;
        try {
            if (null != downloadTask.getDownloadingListener()) {
                downloadTask.getDownloadingListener().onProgress(downloadTask.getUrl(), this.mLastLoaded + this.mLoaded, this.mTotals, this.mUsedTime);
            }
            if (integer == 1028) {
                downloadTask.setStatus(1003);
                downloadTask.pause();
                if (null != downloadTask.getDownloadListener()) {
                    this.doCallback(integer);
                }
                if (null != this.mDownloadNotifier) {
                    this.mDownloadNotifier.onDownloadPaused();
                }
                return;
            }
            if (integer == 1030) {
                downloadTask.setStatus(1005);
                downloadTask.completed();
            } else if (integer == 1033) {
                downloadTask.setStatus(1006);
                downloadTask.completed();
            } else {
                downloadTask.completed();
                downloadTask.setStatus(1004);
            }
            boolean isCancelDispose = this.doCallback(integer);
            if (integer > 512) {
                if (null != this.mDownloadNotifier) {
                    this.mDownloadNotifier.cancel();
                }
                return;
            }
            if (downloadTask.isEnableIndicator()) {
                if (isCancelDispose) {
                    this.mDownloadNotifier.cancel();
                    return;
                }
                if (null != this.mDownloadNotifier) {
                    this.mDownloadNotifier.onDownloadFinished();
                }
            }
            if (!downloadTask.isAutoOpen()) {
                return;
            }
            Intent mIntent = Runtime.getInstance().getCommonFileIntentCompat(downloadTask.getContext(), downloadTask);
            if (null == mIntent) {
                return;
            }
            if (!(downloadTask.getContext() instanceof Activity)) {
                mIntent.addFlags(0x10000000);
            }
            downloadTask.getContext().startActivity(mIntent);
        }
        catch (Throwable throwable) {
            if (Runtime.getInstance().isDebug()) {
                throwable.printStackTrace();
            }
        }
        finally {
            Class<Downloader> clazz = Downloader.class;
            synchronized (Downloader.class) {
                ExecuteTasksMap.getInstance().removeTask(downloadTask.getUrl());
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.destroyTask();
            }
        }
    }

    protected void destroyTask() {
        if (this.mIsCanceled.get() || this.mIsPaused.get()) {
            return;
        }
        DownloadTask downloadTask = this.mDownloadTask;
        if (null != downloadTask) {
            downloadTask.destroy();
        }
    }

    private boolean doCallback(Integer code) {
        DownloadListener mDownloadListener = null;
        DownloadTask downloadTask = this.mDownloadTask;
        mDownloadListener = downloadTask.getDownloadListener();
        if (null == mDownloadListener) {
            return false;
        }
        if (Runtime.getInstance().isDebug() && null != this.mThrowable) {
            this.mThrowable.printStackTrace();
        }
        return mDownloadListener.onResult(code <= 512 ? null : new DownloadException(code, "failed , cause:" + (String)DOWNLOAD_MESSAGE.get(code.intValue())), downloadTask.getFileUri(), downloadTask.getUrl(), this.mDownloadTask);
    }

    private void createNotifier() {
        DownloadTask downloadTask = this.mDownloadTask;
        Context mContext = downloadTask.getContext().getApplicationContext();
        if (null != mContext && downloadTask.isEnableIndicator()) {
            this.mDownloadNotifier = new DownloadNotifier(mContext, downloadTask.getId());
            this.mDownloadNotifier.initBuilder(downloadTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferData(InputStream inputStream, RandomAccessFile randomAccessFile, boolean isSeek) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedInputStream bis = new BufferedInputStream(inputStream, 8192);
        RandomAccessFile out = randomAccessFile;
        DownloadTask downloadTask = this.mDownloadTask;
        try {
            int n;
            if (isSeek) {
                out.seek(out.length());
            } else {
                out.seek(0L);
                this.mLastLoaded = 0L;
            }
            int bytes = 0;
            while (!(this.mIsCanceled.get() || this.mIsShutdown.get() || this.mIsPaused.get() || (n = bis.read(buffer, 0, 8192)) == -1)) {
                out.write(buffer, 0, n);
                bytes += n;
                if (SystemClock.elapsedRealtime() - this.mBeginTime <= this.mDownloadTimeOut) continue;
                int n2 = 1027;
                return n2;
            }
            if (this.mIsPaused.get()) {
                n = 1028;
                return n;
            }
            if (this.mIsCanceled.get()) {
                n = 1030;
                return n;
            }
            if (this.mIsShutdown.get()) {
                n = 1031;
                return n;
            }
            if (!TextUtils.isEmpty((CharSequence)downloadTask.getTargetCompareMD5())) {
                String md5 = Runtime.getInstance().md5(this.mDownloadTask.mFile);
                this.mDownloadTask.setFileMD5(md5);
                if (!downloadTask.getTargetCompareMD5().equalsIgnoreCase(downloadTask.getFileMD5())) {
                    int n3 = 1041;
                    return n3;
                }
            }
            int n4 = 512;
            return n4;
        }
        finally {
            this.closeIO(out);
            this.closeIO(bis);
            this.closeIO(inputStream);
        }
    }

    public void closeIO(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final DownloadTask cancel() {
        try {
            DownloadTask downloadTask = this.mDownloadTask;
            return downloadTask;
        }
        finally {
            this.mIsCanceled.set(true);
        }
    }

    @Override
    public int status() {
        DownloadTask downloadTask = this.mDownloadTask;
        return downloadTask == null ? 1000 : downloadTask.getStatus();
    }

    @Override
    public boolean download(DownloadTask downloadTask) {
        return this.downloadInternal(downloadTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean downloadInternal(final DownloadTask downloadTask) {
        Class<Downloader> clazz = Downloader.class;
        synchronized (Downloader.class) {
            if (TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            if (ExecuteTasksMap.getInstance().exist(downloadTask.getUrl())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            ExecuteTasksMap.getInstance().addTask(downloadTask.getUrl(), this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (Looper.getMainLooper() != Looper.myLooper()) {
                HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        Downloader.this.run(downloadTask);
                    }
                });
                return true;
            }
            this.run(downloadTask);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void run(DownloadTask downloadTask) {
        this.checkIsNullTask(downloadTask);
        try {
            this.mDownloadTask = downloadTask;
            this.mTotals = this.mDownloadTask.getTotalsLength();
            this.mDownloadTimeOut = this.mDownloadTask.getDownloadTimeOut();
            this.mConnectTimeOut = this.mDownloadTask.getConnectTimeOut();
            this.quickProgress = this.mDownloadTask.isQuickProgress();
            this.enableProgress = this.mDownloadTask.isEnableIndicator() || null != this.mDownloadTask.getDownloadingListener();
            Runtime.getInstance().log(TAG, " enableProgress:" + this.enableProgress + " quickProgress:" + this.quickProgress);
            if (null != this.mDownloadTask.getDownloadingListener()) {
                try {
                    DownloadingListener.MainThread annotation = this.mDownloadTask.getDownloadingListener().getClass().getDeclaredMethod("onProgress", String.class, Long.TYPE, Long.TYPE, Long.TYPE).getAnnotation(DownloadingListener.MainThread.class);
                    this.mCallbackInMainThread = null != annotation;
                    Runtime.getInstance().log(TAG, " callback in main-Thread:" + this.mCallbackInMainThread);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (downloadTask.getStatus() != 1003) {
                downloadTask.resetTime();
            }
            downloadTask.setStatus(1001);
            if (downloadTask.isParallelDownload()) {
                this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
                return;
            }
            this.executeOnExecutor(SERIAL_EXECUTOR, new Void[0]);
            return;
        }
        catch (Throwable throwable) {
            if (null != downloadTask && !TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
                Class<Downloader> clazz = Downloader.class;
                // MONITORENTER : com.download.library.Downloader.class
                if (!TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
                    ExecuteTasksMap.getInstance().removeTask(downloadTask.getUrl());
                }
                // MONITOREXIT : clazz
            }
            throwable.printStackTrace();
            throw throwable;
        }
    }

    private final DownloadTask pause() {
        try {
            DownloadTask downloadTask = this.mDownloadTask;
            return downloadTask;
        }
        finally {
            this.mIsPaused.set(true);
        }
    }

    @Override
    public DownloadTask cancelDownload() {
        return this.cancel();
    }

    @Override
    public DownloadTask pauseDownload() {
        return this.pause();
    }

    @Override
    public DownloadTask getDownloadTask() {
        return this.mDownloadTask;
    }

    static {
        DOWNLOAD_MESSAGE.append(1024, (Object)"Network connection error . ");
        DOWNLOAD_MESSAGE.append(1025, (Object)"Response code non-200 or non-206 . ");
        DOWNLOAD_MESSAGE.append(1026, (Object)"Insufficient memory space . ");
        DOWNLOAD_MESSAGE.append(1031, (Object)"Shutdown . ");
        DOWNLOAD_MESSAGE.append(1027, (Object)"Download time is overtime . ");
        DOWNLOAD_MESSAGE.append(1030, (Object)"The user canceled the download . ");
        DOWNLOAD_MESSAGE.append(1040, (Object)"Resource not found . ");
        DOWNLOAD_MESSAGE.append(1028, (Object)"paused . ");
        DOWNLOAD_MESSAGE.append(1033, (Object)"IO Error . ");
        DOWNLOAD_MESSAGE.append(1283, (Object)"Service Unavailable . ");
        DOWNLOAD_MESSAGE.append(1032, (Object)"Too many redirects . ");
        DOWNLOAD_MESSAGE.append(1041, (Object)"Md5 check fails . ");
        DOWNLOAD_MESSAGE.append(512, (Object)"Download successful . ");
    }

    private final class LoadingRandomAccessFile
    extends RandomAccessFile {
        public LoadingRandomAccessFile(File file) throws FileNotFoundException {
            super(file, "rw");
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            super.write(buffer, offset, count);
            Downloader.this.mLoaded = Downloader.this.mLoaded + (long)count;
            DownloadTask downloadTask = Downloader.this.mDownloadTask;
            if (null != downloadTask) {
                downloadTask.setLoaded(Downloader.this.mLastLoaded + Downloader.this.mLoaded);
            }
            if (!Downloader.this.enableProgress) {
                return;
            }
            if (Downloader.this.quickProgress) {
                long currentTime = SystemClock.elapsedRealtime();
                if (currentTime - Downloader.this.mLastTime < 1200L) {
                    if (Downloader.this.mCallbackInMainThread) {
                        Downloader.this.publishProgress(new Integer[]{0});
                    } else {
                        Downloader.this.onProgressUpdate(0);
                    }
                } else {
                    Downloader.this.mLastTime = currentTime;
                    if (Downloader.this.mCallbackInMainThread) {
                        Downloader.this.publishProgress(new Integer[]{1});
                    } else {
                        Downloader.this.onProgressUpdate(1);
                    }
                }
            } else {
                long currentTime = SystemClock.elapsedRealtime();
                if (currentTime - Downloader.this.mLastTime < 1200L) {
                    return;
                }
                Downloader.this.mLastTime = currentTime;
                if (Downloader.this.mCallbackInMainThread) {
                    Downloader.this.publishProgress(new Integer[]{1});
                } else {
                    Downloader.this.onProgressUpdate(1);
                }
            }
        }
    }
}

