/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.content.Context;
import android.net.Uri;
import android.os.SystemClock;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.download.library.DownloadListener;
import com.download.library.DownloadListenerAdapter;
import com.download.library.DownloadTask;
import com.download.library.DownloadingListener;
import com.download.library.Extra;
import com.download.library.Runtime;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadTask
extends Extra
implements Serializable,
Cloneable {
    static final String TAG = "Download-" + DownloadTask.class.getSimpleName();
    int mId = Runtime.getInstance().generateGlobalId();
    long mTotalsLength;
    protected Context mContext;
    protected File mFile;
    protected DownloadListener mDownloadListener;
    protected DownloadingListener mDownloadingListener;
    protected String authority = "";
    public static final int STATUS_NEW = 1000;
    public static final int STATUS_PENDDING = 1001;
    public static final int STATUS_DOWNLOADING = 1002;
    public static final int STATUS_PAUSED = 1003;
    public static final int STATUS_COMPLETED = 1004;
    long beginTime = 0L;
    long pauseTime = 0L;
    long endTime = 0L;
    long detalTime = 0L;
    boolean isCustomFile = false;
    boolean uniquePath = true;
    int connectTimes = 0;
    private AtomicInteger status = new AtomicInteger(1000);

    void resetConnectTimes() {
        this.connectTimes = 0;
    }

    public int getStatus() {
        return this.status.get();
    }

    void setStatus(@DownloadTaskStatus int status) {
        this.status.set(status);
    }

    void resetTime() {
        this.beginTime = 0L;
        this.pauseTime = 0L;
        this.endTime = 0L;
        this.detalTime = 0L;
    }

    public int getId() {
        return this.mId;
    }

    public Context getContext() {
        return this.mContext;
    }

    protected DownloadTask setContext(Context context) {
        this.mContext = context.getApplicationContext();
        return this;
    }

    protected DownloadTask setEnableIndicator(boolean enableIndicator) {
        if (enableIndicator && this.mFile != null && TextUtils.isEmpty((CharSequence)this.authority)) {
            Runtime.getInstance().logError(TAG, "Custom file path, you must specify authority, otherwise the notification should not be turned on. ");
            this.mEnableIndicator = false;
        } else {
            this.mEnableIndicator = enableIndicator;
        }
        return this;
    }

    public File getFile() {
        return this.mFile;
    }

    public Uri getFileUri() {
        return Uri.fromFile((File)this.mFile);
    }

    String getAuthority() {
        return this.authority;
    }

    DownloadTask setFileSafe(@NonNull File file) {
        this.mFile = file;
        return this;
    }

    protected DownloadTask setFile(@NonNull File file) {
        this.mFile = file;
        this.authority = "";
        this.checkCustomFilePath(file);
        return this;
    }

    private void checkCustomFilePath(File file) {
        if (file == null || file.getAbsolutePath().startsWith(Runtime.getInstance().getDefaultDir(this.getContext()).getAbsolutePath())) {
            this.isCustomFile = false;
        } else if (!TextUtils.isEmpty((CharSequence)this.authority)) {
            this.setEnableIndicator(true);
            this.isCustomFile = true;
        } else {
            this.setEnableIndicator(false);
            this.isCustomFile = true;
        }
    }

    boolean isCustomFile() {
        return this.isCustomFile;
    }

    protected DownloadTask setFile(@NonNull File file, @NonNull String authority) {
        this.mFile = file;
        this.authority = authority;
        this.checkCustomFilePath(file);
        return this;
    }

    void updateTime(long beginTime) {
        if (this.beginTime == 0L) {
            this.beginTime = beginTime;
            return;
        }
        if (this.beginTime != beginTime) {
            this.detalTime += Math.abs(beginTime - this.pauseTime);
        }
    }

    public long getUsedTime() {
        if (this.status.get() == 1002) {
            return this.beginTime > 0L ? SystemClock.elapsedRealtime() - this.beginTime - this.detalTime : 0L;
        }
        if (this.status.get() == 1004) {
            return this.endTime - this.beginTime - this.detalTime;
        }
        return 0L;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    protected void pause() {
        this.pauseTime = SystemClock.elapsedRealtime();
        this.connectTimes = 0;
    }

    protected void completed() {
        this.endTime = SystemClock.elapsedRealtime();
    }

    protected void destroy() {
        this.mId = -1;
        this.mUrl = null;
        this.mContext = null;
        this.mFile = null;
        this.mIsParallelDownload = false;
        this.mIsForceDownload = false;
        this.mEnableIndicator = true;
        this.mDownloadIcon = 0x1080081;
        this.mDownloadDoneIcon = 17301634;
        this.mIsParallelDownload = true;
        this.mIsBreakPointDownload = true;
        this.mUserAgent = "";
        this.mContentDisposition = "";
        this.mMimetype = "";
        this.mContentLength = -1L;
        if (this.mHeaders != null) {
            this.mHeaders.clear();
            this.mHeaders = null;
        }
        this.retry = 3;
        this.fileMD5 = "";
        this.targetCompareMD5 = "";
        this.status.set(1000);
    }

    DownloadingListener getDownloadingListener() {
        return this.mDownloadingListener;
    }

    protected DownloadTask setDownloadingListener(DownloadingListener downloadingListener) {
        this.mDownloadingListener = downloadingListener;
        return this;
    }

    public DownloadListener getDownloadListener() {
        return this.mDownloadListener;
    }

    protected DownloadTask setDownloadListener(DownloadListener downloadListener) {
        this.mDownloadListener = downloadListener;
        return this;
    }

    protected DownloadTask setDownloadListenerAdapter(DownloadListenerAdapter downloadListenerAdapter) {
        this.setDownloadListener(downloadListenerAdapter);
        this.setDownloadingListener(downloadListenerAdapter);
        return this;
    }

    void setTotalsLength(long totalsLength) {
        this.mTotalsLength = totalsLength;
    }

    protected long getTotalsLength() {
        return this.mTotalsLength;
    }

    protected DownloadTask setBreakPointDownload(boolean breakPointDownload) {
        this.mIsBreakPointDownload = breakPointDownload;
        return this;
    }

    protected DownloadTask setForceDownload(boolean force) {
        this.mIsForceDownload = force;
        return this;
    }

    protected DownloadTask setIcon(@DrawableRes int icon) {
        this.mDownloadIcon = icon;
        return this;
    }

    protected DownloadTask setParallelDownload(boolean parallelDownload) {
        this.mIsParallelDownload = parallelDownload;
        return this;
    }

    protected DownloadTask addHeader(String key, String value) {
        if (this.mHeaders == null) {
            this.mHeaders = new ArrayMap();
        }
        this.mHeaders.put(key, value);
        return this;
    }

    protected DownloadTask autoOpenIgnoreMD5() {
        this.mAutoOpen = true;
        if (this.mFile != null && TextUtils.isEmpty((CharSequence)this.authority)) {
            Runtime.getInstance().logError(TAG, "Custom file path, you must specify authority, otherwise the auto open should be closed. ");
            this.mAutoOpen = false;
        }
        return this;
    }

    protected DownloadTask autoOpenWithMD5(String md5) {
        if (TextUtils.isEmpty((CharSequence)md5)) {
            return this;
        }
        this.mAutoOpen = true;
        if (this.mFile != null && TextUtils.isEmpty((CharSequence)this.authority)) {
            Runtime.getInstance().logError(TAG, "Custom file path, you must specify authority, otherwise the auto open should be closed. ");
            this.mAutoOpen = false;
        }
        this.targetCompareMD5 = md5;
        return this;
    }

    protected DownloadTask closeAutoOpen() {
        this.mAutoOpen = false;
        return this;
    }

    protected DownloadTask setDownloadTimeOut(long downloadTimeOut) {
        this.downloadTimeOut = downloadTimeOut;
        return this;
    }

    protected DownloadTask setConnectTimeOut(long connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
        return this;
    }

    protected DownloadTask setBlockMaxTime(long blockMaxTime) {
        this.blockMaxTime = blockMaxTime;
        return this;
    }

    protected DownloadTask setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
        return this;
    }

    DownloadTask setContentLength(long contentLength) {
        this.mContentLength = contentLength;
        return this;
    }

    DownloadTask setMimetype(String mimetype) {
        this.mMimetype = mimetype;
        return this;
    }

    DownloadTask setContentDisposition(String contentDisposition) {
        this.mContentDisposition = contentDisposition;
        return this;
    }

    protected DownloadTask setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    protected DownloadTask setDownloadDoneIcon(@DrawableRes int icon) {
        this.mDownloadDoneIcon = icon;
        return this;
    }

    protected DownloadTask setQuickProgress(boolean quickProgress) {
        this.quickProgress = quickProgress;
        return this;
    }

    protected DownloadTask setTargetCompareMD5(String targetCompareMD5) {
        this.targetCompareMD5 = targetCompareMD5;
        return this;
    }

    DownloadTask setFileMD5(String fileMD5) {
        this.fileMD5 = fileMD5;
        return this;
    }

    @Override
    public String getFileMD5() {
        if (TextUtils.isEmpty((CharSequence)this.fileMD5)) {
            this.fileMD5 = Runtime.getInstance().md5(this.mFile);
            if (this.fileMD5 == null) {
                this.fileMD5 = "";
            }
        }
        return super.getFileMD5();
    }

    protected DownloadTask setRetry(int retry) {
        if (retry > 5) {
            retry = 5;
        }
        if (retry < 0) {
            retry = 0;
        }
        this.retry = retry;
        return this;
    }

    @Override
    public DownloadTask clone() {
        try {
            DownloadTask downloadTask = (DownloadTask)super.clone();
            downloadTask.mId = Runtime.getInstance().generateGlobalId();
            return downloadTask;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new DownloadTask();
        }
    }

    public boolean isUniquePath() {
        return this.uniquePath;
    }

    protected void setUniquePath(boolean uniquePath) {
        this.uniquePath = uniquePath;
    }
}

