/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.download.library.DownloadTask;
import com.download.library.NotificationCancelReceiver;
import com.download.library.R;
import com.download.library.Rumtime;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Locale;

public class DownloadNotifier {
    private static final int FLAG = 4;
    int requestCode;
    private int mNotificationId;
    private NotificationManager mNotificationManager;
    private Notification mNotification;
    private NotificationCompat.Builder mBuilder;
    private Context mContext;
    private String mChannelId;
    private volatile boolean mAddedCancelAction;
    private static final String TAG = "Download-" + DownloadNotifier.class.getSimpleName();
    private NotificationCompat.Action mAction;
    private DownloadTask mDownloadTask;

    DownloadNotifier(Context context, int id) {
        block4: {
            this.requestCode = (int)SystemClock.uptimeMillis();
            this.mChannelId = "";
            this.mAddedCancelAction = false;
            this.mNotificationId = id;
            Rumtime.getInstance().log(TAG, " DownloadNotifier:" + this.mNotificationId);
            this.mContext = context;
            this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            try {
                if (Build.VERSION.SDK_INT >= 26) {
                    this.mChannelId = this.mContext.getPackageName().concat(Rumtime.getInstance().getVersion());
                    this.mBuilder = new NotificationCompat.Builder(this.mContext, this.mChannelId);
                    NotificationChannel mNotificationChannel = new NotificationChannel(this.mChannelId, (CharSequence)Rumtime.getInstance().getApplicationName(context), 2);
                    NotificationManager mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
                    mNotificationManager.createNotificationChannel(mNotificationChannel);
                    mNotificationChannel.enableLights(false);
                    mNotificationChannel.enableVibration(false);
                    mNotificationChannel.setSound(null, null);
                } else {
                    this.mBuilder = new NotificationCompat.Builder(this.mContext);
                }
            }
            catch (Throwable ignore) {
                if (!Rumtime.getInstance().isDebug()) break block4;
                ignore.printStackTrace();
            }
        }
    }

    void initBuilder(DownloadTask downloadTask) {
        String title;
        String string2 = title = null == downloadTask.getFile() || TextUtils.isEmpty((CharSequence)downloadTask.getFile().getName()) ? this.mContext.getString(R.string.download_file_download) : downloadTask.getFile().getName();
        if (title.length() > 20) {
            title = "..." + title.substring(title.length() - 20, title.length());
        }
        this.mDownloadTask = downloadTask;
        this.mBuilder.setContentIntent(PendingIntent.getActivity((Context)this.mContext, (int)200, (Intent)new Intent(), (int)0x8000000));
        this.mBuilder.setSmallIcon(this.mDownloadTask.getDownloadIcon());
        this.mBuilder.setTicker((CharSequence)this.mContext.getString(R.string.download_trickter));
        this.mBuilder.setContentTitle((CharSequence)title);
        this.mBuilder.setContentText((CharSequence)this.mContext.getString(R.string.download_coming_soon_download));
        this.mBuilder.setWhen(System.currentTimeMillis());
        this.mBuilder.setAutoCancel(true);
        this.mBuilder.setPriority(-1);
        int defaults = 0;
        this.mBuilder.setDeleteIntent(this.buildCancelContent(this.mContext, downloadTask.getId(), downloadTask.getUrl()));
        this.mBuilder.setDefaults(defaults);
    }

    private PendingIntent buildCancelContent(Context context, int id, String url) {
        Intent intentCancel = new Intent(context, NotificationCancelReceiver.class);
        intentCancel.setAction("com.download.cancelled");
        intentCancel.putExtra("TAG", url);
        PendingIntent pendingIntentCancel = PendingIntent.getBroadcast((Context)context, (int)(id * 1000), (Intent)intentCancel, (int)0x8000000);
        Rumtime.getInstance().log(TAG, "buildCancelContent id:" + id * 1000);
        return pendingIntentCancel;
    }

    private void setProgress(int maxprogress, int currentprogress, boolean exc) {
        this.mBuilder.setProgress(maxprogress, currentprogress, exc);
        this.sent();
    }

    private boolean hasDeleteContent() {
        return this.mBuilder.getNotification().deleteIntent != null;
    }

    private void setDelecte(PendingIntent intent) {
        this.mBuilder.getNotification().deleteIntent = intent;
    }

    private void sent() {
        this.mNotification = this.mBuilder.build();
        this.mNotificationManager.notify(this.mNotificationId, this.mNotification);
    }

    void onPreDownload() {
        this.sent();
    }

    void onDownloading(int progress) {
        if (!this.hasDeleteContent()) {
            this.setDelecte(this.buildCancelContent(this.mContext, this.mNotificationId, this.mDownloadTask.mUrl));
        }
        if (!this.mAddedCancelAction) {
            this.mAddedCancelAction = true;
            this.mAction = new NotificationCompat.Action(17170445, (CharSequence)this.mContext.getString(0x1040000), this.buildCancelContent(this.mContext, this.mNotificationId, this.mDownloadTask.mUrl));
            this.mBuilder.addAction(this.mAction);
        }
        this.mBuilder.setContentText((CharSequence)this.mContext.getString(R.string.download_current_downloading_progress, new Object[]{progress + "%"}));
        this.setProgress(100, progress, false);
        this.sent();
    }

    void onDownloaded(long loaded) {
        if (!this.hasDeleteContent()) {
            this.setDelecte(this.buildCancelContent(this.mContext, this.mNotificationId, this.mDownloadTask.mUrl));
        }
        if (!this.mAddedCancelAction) {
            this.mAddedCancelAction = true;
            this.mAction = new NotificationCompat.Action(this.mDownloadTask.getDownloadIcon(), (CharSequence)this.mContext.getString(0x1040000), this.buildCancelContent(this.mContext, this.mNotificationId, this.mDownloadTask.mUrl));
            this.mBuilder.addAction(this.mAction);
        }
        this.mBuilder.setContentText((CharSequence)this.mContext.getString(R.string.download_current_downloaded_length, new Object[]{DownloadNotifier.byte2FitMemorySize(loaded)}));
        this.setProgress(100, 20, true);
        this.sent();
    }

    private static String byte2FitMemorySize(long byteNum) {
        if (byteNum < 0L) {
            return "shouldn't be less than zero!";
        }
        if (byteNum < 1024L) {
            return String.format(Locale.getDefault(), "%.1fB", (double)byteNum);
        }
        if (byteNum < 0x100000L) {
            return String.format(Locale.getDefault(), "%.1fKB", (double)byteNum / 1024.0);
        }
        if (byteNum < 0x40000000L) {
            return String.format(Locale.getDefault(), "%.1fMB", (double)byteNum / 1048576.0);
        }
        return String.format(Locale.getDefault(), "%.1fGB", (double)byteNum / 1.073741824E9);
    }

    void onDownloadFinished() {
        block6: {
            try {
                Class<?> clazz = this.mBuilder.getClass();
                Field mField = clazz.getDeclaredField("mActions");
                ArrayList mActions = null;
                if (null != mField) {
                    mActions = (ArrayList)mField.get(this.mBuilder);
                }
                int index = -1;
                if (null != mActions && (index = mActions.indexOf(this.mAction)) != -1) {
                    mActions.remove(index);
                }
            }
            catch (Throwable ignore) {
                if (!Rumtime.getInstance().isDebug()) break block6;
                ignore.printStackTrace();
            }
        }
        Intent mIntent = Rumtime.getInstance().getCommonFileIntentCompat(this.mContext, this.mDownloadTask);
        this.setDelecte(null);
        if (null != mIntent) {
            if (!(this.mContext instanceof Activity)) {
                mIntent.addFlags(0x10000000);
            }
            PendingIntent rightPendIntent = PendingIntent.getActivity((Context)this.mContext, (int)(this.mNotificationId * 10000), (Intent)mIntent, (int)0x8000000);
            this.mBuilder.setSmallIcon(this.mDownloadTask.getDownloadDoneIcon());
            this.mBuilder.setContentText((CharSequence)this.mContext.getString(R.string.download_click_open));
            this.mBuilder.setProgress(100, 100, false);
            this.mBuilder.setContentIntent(rightPendIntent);
            this.sent();
        }
    }

    void cancel() {
        this.mNotificationManager.cancel(this.mNotificationId);
    }
}

