/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.filechooser;

import android.app.Activity;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.Action;
import com.just.agentweb.AgentActionFragment;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebPermissions;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.PermissionInterceptor;
import com.just.agentweb.filechooser.FileCompressor;
import com.just.agentweb.filechooser.FileParcel;
import com.just.agentweb.filechooser.R;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileChooser {
    private final Activity mActivity;
    private ValueCallback<Uri> mUriValueCallback;
    private ValueCallback<Uri[]> mUriValueCallbacks;
    public static final int REQUEST_CODE = 596;
    private final WebChromeClient.FileChooserParams mFileChooserParams;
    private JsChannelCallback mJsChannelCallback;
    private boolean mJsChannel = false;
    private static final String TAG = FileChooser.class.getSimpleName();
    private final WebView mWebView;
    private boolean mCameraState = false;
    private boolean mVideoState = false;
    private final PermissionInterceptor mPermissionInterceptor;
    private final int FROM_INTENTION_CODE = 21;
    private WeakReference<AbsAgentWebUIController> mAgentWebUIController = null;
    private String mAcceptType = "*/*";
    public static int MAX_WAIT_PHOTO_MS = 8000;
    private AgentActionFragment.PermissionListener mPermissionListener = new AgentActionFragment.PermissionListener(){

        public void onRequestPermissionsResult(@NonNull String[] permissions, @NonNull int[] grantResults, Bundle extras) {
            boolean tag = true;
            tag = AgentWebUtils.hasPermission((Context)FileChooser.this.mActivity, Arrays.asList(permissions));
            FileChooser.this.permissionResult(tag, extras.getInt("KEY_FROM_INTENTION"));
        }
    };

    public FileChooser(Builder builder) {
        this.mActivity = builder.mActivity;
        this.mUriValueCallback = builder.mUriValueCallback;
        this.mUriValueCallbacks = builder.mUriValueCallbacks;
        this.mJsChannel = builder.mJsChannel;
        this.mFileChooserParams = builder.mFileChooserParams;
        if (this.mJsChannel) {
            this.mJsChannelCallback = JsChannelCallback.create(builder.mJsChannelCallback);
        }
        this.mWebView = builder.mWebView;
        this.mPermissionInterceptor = builder.mPermissionInterceptor;
        this.mAcceptType = builder.mAcceptType;
        this.mAgentWebUIController = new WeakReference<AbsAgentWebUIController>(AgentWebUtils.getAgentWebUIControllerByWebView((WebView)this.mWebView));
    }

    public void openFileChooser() {
        if (!AgentWebUtils.isUIThread()) {
            AgentWebUtils.runInUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    FileChooser.this.openFileChooser();
                }
            });
            return;
        }
        this.openFileChooserInternal();
    }

    private void fileChooser() {
        Object permission = null;
        if (AgentWebUtils.getDeniedPermissions((Activity)this.mActivity, (String[])AgentWebPermissions.STORAGE).isEmpty()) {
            this.touchOffFileChooserAction();
        } else {
            Action mAction = Action.createPermissionsAction((String[])AgentWebPermissions.STORAGE);
            mAction.setFromIntention(5);
            mAction.setPermissionListener(this.mPermissionListener);
            AgentActionFragment.start((Activity)this.mActivity, (Action)mAction);
        }
    }

    private void touchOffFileChooserAction() {
        block2: {
            Action mAction = new Action();
            mAction.setAction(2);
            mAction.setChooserListener(this.getChooserListener());
            try {
                mAction.setIntent(this.getFileChooserIntent());
                AgentActionFragment.start((Activity)this.mActivity, (Action)mAction);
            }
            catch (Throwable throwable) {
                if (!AgentWebConfig.DEBUG) break block2;
                throwable.printStackTrace();
            }
        }
    }

    private Intent getFileChooserIntent() {
        Intent mIntent = null;
        if (Build.VERSION.SDK_INT >= 21 && this.mFileChooserParams != null && (mIntent = this.mFileChooserParams.createIntent()) != null) {
            if (this.mFileChooserParams.getMode() == 1) {
                mIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
            }
            if (this.mFileChooserParams.getAcceptTypes() != null && this.mFileChooserParams.getAcceptTypes().length > 1) {
                mIntent.putExtra("android.intent.extra.MIME_TYPES", this.mFileChooserParams.getAcceptTypes());
            }
            if (Objects.equals(mIntent.getAction(), "android.intent.action.GET_CONTENT")) {
                mIntent.setAction("android.intent.action.OPEN_DOCUMENT");
            }
            return mIntent;
        }
        Intent i = new Intent();
        if (Build.VERSION.SDK_INT >= 19) {
            i.setAction("android.intent.action.OPEN_DOCUMENT");
        } else {
            i.setAction("android.intent.action.GET_CONTENT");
        }
        i.addCategory("android.intent.category.OPENABLE");
        if (TextUtils.isEmpty((CharSequence)this.mAcceptType)) {
            i.setType("*/*");
        } else {
            i.setType(this.mAcceptType);
        }
        i.addFlags(1);
        mIntent = Intent.createChooser((Intent)i, (CharSequence)"");
        return mIntent;
    }

    private AgentActionFragment.ChooserListener getChooserListener() {
        return new AgentActionFragment.ChooserListener(){

            public void onChoiceResult(int requestCode, int resultCode, Intent data) {
                FileChooser.this.onIntentResult(requestCode, resultCode, data);
            }
        };
    }

    private void openFileChooserInternal() {
        boolean needVideo = false;
        if (Build.VERSION.SDK_INT >= 21 && this.mFileChooserParams != null && this.mFileChooserParams.getAcceptTypes() != null) {
            String[] types;
            boolean needCamera = false;
            for (String typeTmp : types = this.mFileChooserParams.getAcceptTypes()) {
                if (TextUtils.isEmpty((CharSequence)typeTmp)) continue;
                if (typeTmp.contains("*/") || typeTmp.contains("image/")) {
                    needCamera = true;
                    break;
                }
                if (!typeTmp.contains("video/")) continue;
                needCamera = true;
                this.mVideoState = true;
            }
            if (!needCamera && !needVideo) {
                this.touchOffFileChooserAction();
                return;
            }
        }
        if (!(TextUtils.isEmpty((CharSequence)this.mAcceptType) || this.mAcceptType.contains("*/") || this.mAcceptType.contains("image/"))) {
            this.touchOffFileChooserAction();
            return;
        }
        if (this.mAgentWebUIController.get() != null) {
            ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onSelectItemsPrompt(this.mWebView, this.mWebView.getUrl(), new String[]{this.mActivity.getString(R.string.agentweb_camera), this.mActivity.getString(R.string.agentweb_file_chooser)}, this.getCallBack());
        }
    }

    private Handler.Callback getCallBack() {
        return new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        FileChooser.this.mCameraState = true;
                        FileChooser.this.onCameraAction();
                        break;
                    }
                    case 1: {
                        FileChooser.this.mCameraState = false;
                        FileChooser.this.fileChooser();
                        break;
                    }
                    default: {
                        FileChooser.this.cancel();
                    }
                }
                return true;
            }
        };
    }

    private void onCameraAction() {
        if (this.mActivity == null) {
            return;
        }
        if (this.mPermissionInterceptor != null && this.mPermissionInterceptor.intercept(this.mWebView.getUrl(), AgentWebPermissions.CAMERA, "camera")) {
            this.cancel();
            return;
        }
        Action mAction = new Action();
        List<String> deniedPermissions = null;
        if (Build.VERSION.SDK_INT >= 23 && !(deniedPermissions = this.checkNeedPermission()).isEmpty()) {
            mAction.setAction(1);
            mAction.setPermissions(deniedPermissions.toArray(new String[0]));
            mAction.setFromIntention(2);
            mAction.setPermissionListener(this.mPermissionListener);
            AgentActionFragment.start((Activity)this.mActivity, (Action)mAction);
        } else {
            this.openCameraAction();
        }
    }

    private List<String> checkNeedPermission() {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        if (!AgentWebUtils.hasPermission((Context)this.mActivity, (String[])AgentWebPermissions.CAMERA)) {
            deniedPermissions.add(AgentWebPermissions.CAMERA[0]);
        }
        if (!AgentWebUtils.hasPermission((Context)this.mActivity, (String[])AgentWebPermissions.STORAGE)) {
            deniedPermissions.addAll(Arrays.asList(AgentWebPermissions.STORAGE));
        }
        return deniedPermissions;
    }

    private void openCameraAction() {
        Action mAction = new Action();
        if (this.mVideoState) {
            mAction.setAction(4);
        } else {
            mAction.setAction(3);
        }
        mAction.setChooserListener(this.getChooserListener());
        AgentActionFragment.start((Activity)this.mActivity, (Action)mAction);
    }

    private void permissionResult(boolean grant, int fromIntention) {
        if (fromIntention == 5) {
            if (grant) {
                this.touchOffFileChooserAction();
            } else {
                this.cancel();
                if (null != this.mAgentWebUIController.get()) {
                    ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onPermissionsDeny(AgentWebPermissions.STORAGE, "Storage", "Open file chooser");
                }
            }
        } else if (fromIntention == 2) {
            if (grant) {
                this.openCameraAction();
            } else {
                this.cancel();
                if (null != this.mAgentWebUIController.get()) {
                    ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onPermissionsDeny(AgentWebPermissions.CAMERA, "Camera", "Take photo");
                }
            }
        }
    }

    public void onIntentResult(int requestCode, int resultCode, Intent data) {
        if (596 != requestCode) {
            return;
        }
        if (resultCode == 0 || data == null) {
            this.cancel();
            return;
        }
        if (resultCode != -1) {
            this.cancel();
            return;
        }
        if (this.mJsChannel) {
            Uri[] uriArray;
            if (this.mCameraState) {
                Uri[] uriArray2 = new Uri[1];
                uriArray = uriArray2;
                uriArray2[0] = (Uri)data.getParcelableExtra("KEY_URI");
            } else {
                uriArray = this.processData(data);
            }
            this.convertFileAndCallback(uriArray);
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Uri[] uriArray;
            if (this.mCameraState) {
                Uri[] uriArray3 = new Uri[1];
                uriArray = uriArray3;
                uriArray3[0] = (Uri)data.getParcelableExtra("KEY_URI");
            } else {
                uriArray = this.processData(data);
            }
            this.aboveLollipopCheckFilesAndCallback(uriArray, this.mCameraState);
            return;
        }
        if (this.mUriValueCallback == null) {
            this.cancel();
            return;
        }
        if (this.mCameraState) {
            FileChooser.fileCompressAndValuesCallback((Uri)data.getParcelableExtra("KEY_URI"), this.mUriValueCallback);
            this.mUriValueCallback = null;
        } else {
            this.belowLollipopUriCallback(data);
        }
    }

    private void cancel() {
        block8: {
            block7: {
                if (this.mJsChannel) {
                    this.mJsChannelCallback.call(null);
                    return;
                }
                if (this.mUriValueCallback != null) {
                    try {
                        this.mUriValueCallback.onReceiveValue(null);
                        this.mUriValueCallback = null;
                    }
                    catch (Throwable ignored) {
                        if (!AgentWebConfig.DEBUG) break block7;
                        ignored.printStackTrace();
                    }
                }
            }
            if (this.mUriValueCallbacks != null) {
                try {
                    this.mUriValueCallbacks.onReceiveValue(null);
                    this.mUriValueCallbacks = null;
                }
                catch (Throwable ignored) {
                    if (!AgentWebConfig.DEBUG) break block8;
                    ignored.printStackTrace();
                }
            }
        }
    }

    private void belowLollipopUriCallback(Intent data) {
        if (data == null) {
            if (this.mUriValueCallback != null) {
                this.mUriValueCallback.onReceiveValue((Object)Uri.EMPTY);
                this.mUriValueCallback = null;
            }
            return;
        }
        Uri mUri = data.getData();
        if (this.mUriValueCallback != null) {
            FileChooser.fileCompressAndValuesCallback(mUri, this.mUriValueCallback);
            this.mUriValueCallback = null;
        }
    }

    private Uri[] processData(Intent data) {
        Uri[] datas = null;
        if (data == null) {
            return datas;
        }
        String target = data.getDataString();
        if (!TextUtils.isEmpty((CharSequence)target)) {
            datas = new Uri[]{Uri.parse((String)target)};
            return datas;
        }
        ClipData mClipData = null;
        if (Build.VERSION.SDK_INT >= 16) {
            mClipData = data.getClipData();
        }
        if (mClipData != null && mClipData.getItemCount() > 0) {
            datas = new Uri[mClipData.getItemCount()];
            for (int i = 0; i < mClipData.getItemCount(); ++i) {
                ClipData.Item mItem = mClipData.getItemAt(i);
                datas[i] = mItem.getUri();
            }
        }
        return datas;
    }

    private void convertFileAndCallback(Uri[] uris) {
        String[] paths = null;
        if (uris == null || uris.length == 0 || (paths = AgentWebUtils.uriToPath((Activity)this.mActivity, (Uri[])uris)) == null || paths.length == 0) {
            this.mJsChannelCallback.call(null);
            return;
        }
        FileCompressor.getInstance().fileCompress("customize", uris, new ValueCallback<Uri[]>(){

            public void onReceiveValue(Uri[] value) {
                String[] compressFilePath = AgentWebUtils.uriToPath((Activity)FileChooser.this.mActivity, (Uri[])value);
                if (compressFilePath == null || compressFilePath.length == 0) {
                    FileChooser.this.mJsChannelCallback.call(null);
                    return;
                }
                int sum = 0;
                for (String path : compressFilePath) {
                    File mFile;
                    if (TextUtils.isEmpty((CharSequence)path) || !(mFile = new File(path)).exists()) continue;
                    sum = (int)((long)sum + mFile.length());
                }
                if (sum > AgentWebConfig.MAX_FILE_LENGTH) {
                    if (FileChooser.this.mAgentWebUIController.get() != null) {
                        ((AbsAgentWebUIController)FileChooser.this.mAgentWebUIController.get()).onShowMessage(FileChooser.this.mActivity.getString(R.string.agentweb_max_file_length_limit, new Object[]{AgentWebConfig.MAX_FILE_LENGTH / 1024 / 1024 + ""}), "convertFileAndCallback");
                    }
                    FileChooser.this.mJsChannelCallback.call(null);
                    return;
                }
                AsyncTask.THREAD_POOL_EXECUTOR.execute(new CovertFileThread(FileChooser.this.mJsChannelCallback, compressFilePath));
            }
        });
    }

    private static void fileCompressAndValuesCallback(Uri[] datas, final ValueCallback<Uri[]> valueCallback) {
        FileCompressor.getInstance().fileCompress("system", datas, new ValueCallback<Uri[]>(){

            public void onReceiveValue(Uri[] value) {
                if (valueCallback != null) {
                    valueCallback.onReceiveValue((Object)value);
                }
            }
        });
    }

    private static void fileCompressAndValuesCallback(Uri datas, final ValueCallback<Uri> valueCallback) {
        FileCompressor.getInstance().fileCompress("system", new Uri[]{datas}, new ValueCallback<Uri[]>(){

            public void onReceiveValue(Uri[] value) {
                if (valueCallback != null) {
                    if (value != null && value.length > 0) {
                        valueCallback.onReceiveValue((Object)value[0]);
                    } else {
                        valueCallback.onReceiveValue((Object)Uri.EMPTY);
                    }
                }
            }
        });
    }

    private void aboveLollipopCheckFilesAndCallback(Uri[] datas, boolean isCamera) {
        if (this.mUriValueCallbacks == null) {
            return;
        }
        if (null != datas && datas.length > 0 && Build.VERSION.SDK_INT >= 19) {
            ContentResolver contentResolver = this.mActivity.getContentResolver();
            int takeFlags = 3;
            for (int i = 0; i < datas.length; ++i) {
                try {
                    contentResolver.takePersistableUriPermission(datas[i], 3);
                    continue;
                }
                catch (Throwable throwable) {
                    if (!AgentWebConfig.DEBUG) continue;
                    throwable.printStackTrace();
                }
            }
        }
        if (!isCamera) {
            FileChooser.fileCompressAndValuesCallback(datas == null ? new Uri[]{} : datas, this.mUriValueCallbacks);
            this.mUriValueCallbacks = null;
            return;
        }
        if (this.mAgentWebUIController.get() == null) {
            this.mUriValueCallbacks.onReceiveValue(null);
            this.mUriValueCallbacks = null;
            return;
        }
        String[] paths = AgentWebUtils.uriToPath((Activity)this.mActivity, (Uri[])datas);
        if (paths == null || paths.length == 0) {
            this.mUriValueCallbacks.onReceiveValue(null);
            this.mUriValueCallbacks = null;
            return;
        }
        String path = paths[0];
        ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onLoading(this.mActivity.getString(R.string.agentweb_loading));
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new WaitPhotoRunnable(path, new AboveLCallback(this.mUriValueCallbacks, datas, this.mAgentWebUIController)));
        this.mUriValueCallbacks = null;
    }

    public static Queue<FileParcel> convertFile(String[] paths) throws Exception {
        if (paths == null || paths.length == 0) {
            return null;
        }
        int tmp = Runtime.getRuntime().availableProcessors() + 1;
        int result = paths.length > tmp ? tmp : paths.length;
        ExecutorService mExecutor = Executors.newFixedThreadPool(result);
        LinkedBlockingQueue<FileParcel> mQueue = new LinkedBlockingQueue<FileParcel>();
        CountDownLatch mCountDownLatch = new CountDownLatch(paths.length);
        int i = 1;
        for (String path : paths) {
            if (TextUtils.isEmpty((CharSequence)path)) {
                mCountDownLatch.countDown();
                continue;
            }
            mExecutor.execute(new EncodeFileRunnable(path, mQueue, mCountDownLatch, i++));
        }
        mCountDownLatch.await();
        if (!((ThreadPoolExecutor)mExecutor).isShutdown()) {
            ((ThreadPoolExecutor)mExecutor).shutdownNow();
        }
        return mQueue;
    }

    static String convertFileParcelObjectsToJson(Collection<FileParcel> collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Iterator<FileParcel> mFileParcels = collection.iterator();
        JSONArray mJSONArray = new JSONArray();
        try {
            while (mFileParcels.hasNext()) {
                JSONObject jo = new JSONObject();
                FileParcel mFileParcel = mFileParcels.next();
                jo.put("contentPath", (Object)mFileParcel.getContentPath());
                jo.put("fileBase64", (Object)mFileParcel.getFileBase64());
                jo.put("mId", mFileParcel.getId());
                mJSONArray.put((Object)jo);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return mJSONArray + "";
    }

    public static Builder newBuilder(Activity activity, WebView webView) {
        return new Builder().setActivity(activity).setWebView(webView);
    }

    public static final class Builder {
        private Activity mActivity;
        private ValueCallback<Uri> mUriValueCallback;
        private ValueCallback<Uri[]> mUriValueCallbacks;
        private WebChromeClient.FileChooserParams mFileChooserParams;
        private boolean mJsChannel = false;
        private WebView mWebView;
        private PermissionInterceptor mPermissionInterceptor;
        private String mAcceptType = "*/*";
        private Handler.Callback mJsChannelCallback;

        public Builder setAcceptType(String acceptType) {
            this.mAcceptType = acceptType;
            return this;
        }

        public Builder setPermissionInterceptor(PermissionInterceptor permissionInterceptor) {
            this.mPermissionInterceptor = permissionInterceptor;
            return this;
        }

        public Builder setActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        public Builder setUriValueCallback(ValueCallback<Uri> uriValueCallback) {
            this.mUriValueCallback = uriValueCallback;
            this.mJsChannel = false;
            this.mUriValueCallbacks = null;
            return this;
        }

        public Builder setUriValueCallbacks(ValueCallback<Uri[]> uriValueCallbacks) {
            this.mUriValueCallbacks = uriValueCallbacks;
            this.mUriValueCallback = null;
            this.mJsChannel = false;
            return this;
        }

        public Builder setFileChooserParams(WebChromeClient.FileChooserParams fileChooserParams) {
            this.mFileChooserParams = fileChooserParams;
            return this;
        }

        public Builder setJsChannelCallback(Handler.Callback jsChannelCallback) {
            this.mJsChannelCallback = jsChannelCallback;
            this.mJsChannel = true;
            this.mUriValueCallback = null;
            this.mUriValueCallbacks = null;
            return this;
        }

        public Builder setWebView(WebView webView) {
            this.mWebView = webView;
            return this;
        }

        public FileChooser build() {
            return new FileChooser(this);
        }
    }

    static class JsChannelCallback {
        WeakReference<Handler.Callback> callback = null;

        JsChannelCallback(Handler.Callback callback) {
            this.callback = new WeakReference<Handler.Callback>(callback);
        }

        public static JsChannelCallback create(Handler.Callback callback) {
            return new JsChannelCallback(callback);
        }

        void call(String value) {
            if (this.callback != null && this.callback.get() != null) {
                ((Handler.Callback)this.callback.get()).handleMessage(Message.obtain(null, (int)"JsChannelCallback".hashCode(), (Object)value));
            }
        }
    }

    static class CovertFileThread
    implements Runnable {
        private WeakReference<JsChannelCallback> mJsChannelCallback;
        private String[] paths;

        private CovertFileThread(JsChannelCallback JsChannelCallback2, String[] paths) {
            this.mJsChannelCallback = new WeakReference<JsChannelCallback>(JsChannelCallback2);
            this.paths = paths;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String name = Thread.currentThread().getName();
            Thread.currentThread().setName("agentweb-thread");
            try {
                Queue<FileParcel> mQueue = FileChooser.convertFile(this.paths);
                String result = FileChooser.convertFileParcelObjectsToJson(mQueue);
                if (this.mJsChannelCallback != null && this.mJsChannelCallback.get() != null) {
                    ((JsChannelCallback)this.mJsChannelCallback.get()).call(result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Thread.currentThread().setName(name);
            }
        }
    }

    static class EncodeFileRunnable
    implements Runnable {
        private String filePath;
        private Queue<FileParcel> mQueue;
        private CountDownLatch mCountDownLatch;
        private int id;

        public EncodeFileRunnable(String filePath, Queue<FileParcel> queue, CountDownLatch countDownLatch, int id) {
            this.filePath = filePath;
            this.mQueue = queue;
            this.mCountDownLatch = countDownLatch;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            File mFile;
            ByteArrayOutputStream os;
            FileInputStream is;
            block7: {
                is = null;
                os = null;
                mFile = new File(this.filePath);
                Log.e((String)TAG, (String)("encode file:" + mFile.length()));
                if (!mFile.exists()) return;
                is = new FileInputStream(mFile);
                if (is != null) break block7;
                AgentWebUtils.closeIO((Closeable)is);
                AgentWebUtils.closeIO(os);
                this.mCountDownLatch.countDown();
                return;
            }
            try {
                int len;
                os = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                while ((len = ((InputStream)is).read(b, 0, 1024)) != -1) {
                    os.write(b, 0, len);
                }
                this.mQueue.offer(new FileParcel(this.id, mFile.getAbsolutePath(), Base64.encodeToString((byte[])os.toByteArray(), (int)0)));
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                AgentWebUtils.closeIO(is);
                AgentWebUtils.closeIO(os);
                this.mCountDownLatch.countDown();
            }
        }
    }

    private static final class WaitPhotoRunnable
    implements Runnable {
        private String path;
        private Handler.Callback mCallback;

        private WaitPhotoRunnable(String path, Handler.Callback callback) {
            this.path = path;
            this.mCallback = callback;
        }

        @Override
        public void run() {
            int ms;
            if (TextUtils.isEmpty((CharSequence)this.path) || !new File(this.path).exists()) {
                if (this.mCallback != null) {
                    this.mCallback.handleMessage(Message.obtain(null, (int)-1));
                }
                return;
            }
            for (ms = 0; ms <= MAX_WAIT_PHOTO_MS; ms += 300) {
                SystemClock.sleep((long)300L);
                File mFile = new File(this.path);
                if (mFile.length() <= 0L) continue;
                if (this.mCallback == null) break;
                this.mCallback.handleMessage(Message.obtain(null, (int)1));
                this.mCallback = null;
                break;
            }
            if (ms > MAX_WAIT_PHOTO_MS && this.mCallback != null) {
                this.mCallback.handleMessage(Message.obtain(null, (int)-1));
            }
            this.mCallback = null;
            this.path = null;
        }
    }

    private static final class AboveLCallback
    implements Handler.Callback {
        private ValueCallback<Uri[]> mValueCallback;
        private Uri[] mUris;
        private WeakReference<AbsAgentWebUIController> controller;

        private AboveLCallback(ValueCallback<Uri[]> valueCallbacks, Uri[] uris, WeakReference<AbsAgentWebUIController> controller) {
            this.mValueCallback = valueCallbacks;
            this.mUris = uris;
            this.controller = controller;
        }

        public boolean handleMessage(final Message msg) {
            AgentWebUtils.runInUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    this.safeHandleMessage(msg);
                }
            });
            return false;
        }

        private void safeHandleMessage(Message msg) {
            if (this.mValueCallback != null) {
                FileChooser.fileCompressAndValuesCallback(this.mUris, (ValueCallback<Uri[]>)this.mValueCallback);
            }
            if (this.controller != null && this.controller.get() != null) {
                ((AbsAgentWebUIController)this.controller.get()).onCancelLoading();
            }
        }
    }
}

