/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;

public class CustomArgument<T>
extends Argument {
    private CustomArgumentParser<T> parser;
    private boolean keyed;

    public CustomArgument(String nodeName, CustomArgumentParser<T> parser) {
        this(nodeName, parser, false);
    }

    public CustomArgument(String nodeName, CustomArgumentParser<T> parser, boolean keyed) {
        super(nodeName, keyed ? CommandAPIHandler.getInstance().getNMS()._ArgumentMinecraftKeyRegistered() : StringArgumentType.string());
        this.keyed = keyed;
        this.parser = parser;
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public Class<T> getPrimitiveType() {
        return null;
    }

    public CustomArgumentParser<T> getParser() {
        return this.parser;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.CUSTOM;
    }

    @FunctionalInterface
    public static interface CustomArgumentParser<T> {
        public T apply(String var1) throws CustomArgumentException;
    }

    public static class CustomArgumentException
    extends Exception {
        final String errorMessage;
        final MessageBuilder errorMessageBuilder;

        public CustomArgumentException(String errorMessage) {
            this.errorMessage = errorMessage;
            this.errorMessageBuilder = null;
        }

        public CustomArgumentException(MessageBuilder errorMessage) {
            this.errorMessage = null;
            this.errorMessageBuilder = errorMessage;
        }

        public CommandSyntaxException toCommandSyntax(String result, CommandContext<?> cmdCtx) {
            if (this.errorMessage == null) {
                String errorMsg = this.errorMessageBuilder.toString().replace("%input%", result).replace("%finput%", cmdCtx.getInput());
                return new SimpleCommandExceptionType(() -> errorMsg).create();
            }
            return new SimpleCommandExceptionType((Message)new LiteralMessage(this.errorMessage)).create();
        }
    }

    public static class MessageBuilder {
        StringBuilder builder;

        public MessageBuilder() {
            this.builder = new StringBuilder();
        }

        public MessageBuilder(String str) {
            this.builder = new StringBuilder(str);
        }

        public MessageBuilder appendArgInput() {
            this.builder.append("%input%");
            return this;
        }

        public MessageBuilder appendFullInput() {
            this.builder.append("%finput%");
            return this;
        }

        public MessageBuilder appendHere() {
            this.builder.append("<--[HERE]");
            return this;
        }

        public MessageBuilder append(String str) {
            this.builder.append(str);
            return this;
        }

        public MessageBuilder append(Object obj) {
            this.builder.append(obj);
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

