/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.StringTooltip;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.IOverrideableSuggestions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;

public abstract class Argument
implements IOverrideableSuggestions {
    private final String nodeName;
    private final ArgumentType<?> rawType;
    private Optional<BiFunction<CommandSender, Object[], IStringTooltip[]>> suggestions = Optional.empty();
    private CommandPermission permission = CommandPermission.NONE;
    private Predicate<CommandSender> requirements = s -> true;
    private boolean isListed = true;

    public abstract Class<?> getPrimitiveType();

    public abstract CommandAPIArgumentType getArgumentType();

    protected Argument(String nodeName, ArgumentType<?> rawType) {
        this.nodeName = nodeName;
        this.rawType = rawType;
    }

    public final ArgumentType<?> getRawType() {
        return this.rawType;
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    private final StringTooltip[] fromSuggestions(String[] suggestions) {
        return (StringTooltip[])Arrays.stream(suggestions).map(StringTooltip::none).toArray(StringTooltip[]::new);
    }

    @Override
    @Deprecated
    public final Argument overrideSuggestions(String ... suggestions) {
        this.suggestions = Optional.of((c, m) -> this.fromSuggestions(suggestions));
        return this;
    }

    @Override
    @Deprecated
    public final Argument overrideSuggestions(Collection<String> suggestions) {
        this.suggestions = Optional.of((c, m) -> this.fromSuggestions(suggestions.toArray(new String[0])));
        return this;
    }

    @Override
    public final Argument overrideSuggestions(Function<CommandSender, String[]> suggestions) {
        this.suggestions = Optional.of((c, m) -> this.fromSuggestions((String[])suggestions.apply((CommandSender)c)));
        return this;
    }

    @Override
    public final Argument overrideSuggestions(BiFunction<CommandSender, Object[], String[]> suggestions) {
        this.suggestions = Optional.of((c, m) -> this.fromSuggestions((String[])suggestions.apply((CommandSender)c, (Object[])m)));
        return this;
    }

    @Override
    @Deprecated
    public final Argument overrideSuggestionsT(Collection<IStringTooltip> suggestions) {
        this.suggestions = Optional.of((c, m) -> suggestions.toArray(new IStringTooltip[0]));
        return this;
    }

    @Override
    @Deprecated
    public final Argument overrideSuggestionsT(IStringTooltip ... suggestions) {
        this.suggestions = Optional.of((c, m) -> suggestions);
        return this;
    }

    @Override
    public final Argument overrideSuggestionsT(Function<CommandSender, IStringTooltip[]> suggestions) {
        this.suggestions = Optional.of((c, m) -> (IStringTooltip[])suggestions.apply((CommandSender)c));
        return this;
    }

    @Override
    public final Argument overrideSuggestionsT(BiFunction<CommandSender, Object[], IStringTooltip[]> suggestions) {
        this.suggestions = Optional.of(suggestions);
        return this;
    }

    @Override
    public final Optional<BiFunction<CommandSender, Object[], IStringTooltip[]>> getOverriddenSuggestions() {
        return this.suggestions;
    }

    public final Argument withPermission(CommandPermission permission) {
        this.permission = permission;
        return this;
    }

    public final Argument withPermission(String permission) {
        this.permission = CommandPermission.fromString(permission);
        return this;
    }

    public final CommandPermission getArgumentPermission() {
        return this.permission;
    }

    public final Predicate<CommandSender> getRequirements() {
        return this.requirements;
    }

    public final Argument withRequirement(Predicate<CommandSender> requirement) {
        this.requirements = this.requirements.and(requirement);
        return this;
    }

    public boolean isListed() {
        return this.isListed;
    }

    public Argument setListed(boolean listed) {
        this.isListed = listed;
        return this;
    }
}

