/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

public class CommandPermission {
    public static CommandPermission OP = new CommandPermission(PermissionNode.OP);
    public static CommandPermission NONE = new CommandPermission(PermissionNode.NONE);
    private String permission;
    private PermissionNode permissionNode;
    private boolean negated = false;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandPermission other = (CommandPermission)obj;
        if (this.permission == null ? other.permission != null : !this.permission.equals(other.permission)) {
            return false;
        }
        return this.permissionNode == other.permissionNode;
    }

    public static CommandPermission fromString(String permission) {
        return new CommandPermission(permission);
    }

    private CommandPermission(String permission) {
        this.permission = permission;
        this.permissionNode = null;
    }

    private CommandPermission(PermissionNode permissionNode) {
        this.permission = null;
        this.permissionNode = permissionNode;
    }

    String getPermission() {
        return this.permission;
    }

    PermissionNode getPermissionNode() {
        return this.permissionNode;
    }

    boolean isNegated() {
        return this.negated;
    }

    CommandPermission negate() {
        this.negated = true;
        return this;
    }

    public String toString() {
        String result = this.permissionNode != null ? (this.permissionNode == PermissionNode.OP ? "OP" : "NONE") : this.permission;
        return (this.negated ? "not " : "") + result;
    }

    private static enum PermissionNode {
        OP,
        NONE;

    }
}

