/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.sync;

import com.github.jonathanxd.iutils.arguments.Argument;
import com.github.jonathanxd.iutils.arguments.Arguments;
import com.github.jonathanxd.iutils.sync.HashSetLock;
import com.github.jonathanxd.iutils.workers.PersistWorker;
import com.github.jonathanxd.iutils.workers.WorkRunnable;
import java.util.Iterator;

public class SyncWorker
implements PersistWorker {
    HashSetLock<Arguments> queue = new HashSetLock();
    boolean isWorking = false;

    public boolean isLocked() {
        return this.queue.isLocked();
    }

    @Override
    public boolean isWorking() {
        return this.isWorking;
    }

    @Override
    public synchronized void addToQueue(WorkRunnable work, Boolean persist) {
        this.queue.add(new Arguments().registerArgument("work", Argument.of(work)).registerArgument("persist", Argument.of(persist)));
    }

    @Override
    public synchronized void addToQueue(WorkRunnable work) {
        this.addToQueue(work, Boolean.FALSE);
    }

    @Override
    public synchronized void startWork() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (SyncWorker.this.isWorking()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                SyncWorker.this.isWorking = true;
                SyncWorker.this.queue.lock();
                for (Arguments args : SyncWorker.this.queue) {
                    WorkRunnable work = (WorkRunnable)args.getLastestArgument("work").getValue();
                    work.doWork();
                }
                SyncWorker.this.queue.unlock();
                SyncWorker.this.isWorking = false;
                SyncWorker.this.transfer();
            }
        }).start();
    }

    protected void transfer() {
        Iterator<Arguments> args = this.queue.iterator();
        while (args.hasNext()) {
            Arguments arg = args.next();
            Boolean persist = (Boolean)arg.getLastestArgument("persist").getValue();
            if (persist.booleanValue()) continue;
            args.remove();
        }
        boolean b = this.queue.transfer();
        if (b) {
            this.startWork();
        }
    }
}

