/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.sync;

import com.github.jonathanxd.iutils.arguments.Argument;
import com.github.jonathanxd.iutils.arguments.Arguments;
import com.github.jonathanxd.iutils.sync.QueueLock;
import com.github.jonathanxd.iutils.workers.PersistWorker;
import com.github.jonathanxd.iutils.workers.WorkRunnable;
import java.util.Iterator;

public class QueueSyncWorker
implements PersistWorker {
    QueueLock<Arguments> queue = new QueueLock();
    boolean isWorking = false;

    public boolean isLocked() {
        return this.queue.isLocked();
    }

    @Override
    public boolean isWorking() {
        return this.isWorking;
    }

    @Override
    public synchronized void addToQueue(WorkRunnable work, Boolean persist) {
        this.queue.offer(new Arguments().registerArgument("work", Argument.of(work)).registerArgument("persist", Argument.of(persist)));
    }

    @Override
    public synchronized void addToQueue(WorkRunnable work) {
        this.addToQueue(work, Boolean.FALSE);
    }

    @Override
    public synchronized void startWork() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (QueueSyncWorker.this.isWorking()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                QueueSyncWorker.this.isWorking = true;
                QueueSyncWorker.this.queue.lock();
                for (Arguments args : QueueSyncWorker.this.queue) {
                    WorkRunnable work = (WorkRunnable)args.getLastestArgument("work").getValue();
                    work.doWork();
                }
                QueueSyncWorker.this.queue.unlock();
                QueueSyncWorker.this.isWorking = false;
                QueueSyncWorker.this.transfer();
            }
        }).start();
    }

    protected void transfer() {
        Iterator<Arguments> args = this.queue.iterator();
        while (args.hasNext()) {
            Arguments arg = args.next();
            Boolean persist = (Boolean)arg.getLastestArgument("persist").getValue();
            if (persist.booleanValue()) continue;
            args.remove();
        }
        boolean b = this.queue.transfer();
        if (b) {
            this.startWork();
        }
    }
}

