/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.sync;

import com.github.jonathanxd.iutils.exceptions.ElementLockedException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Spliterator;

public class QueueLock<E>
extends LinkedList<E> {
    private static final long serialVersionUID = -8630709456520761213L;
    Queue<E> queueQueue = new LinkedList();
    private boolean isLocked = false;

    public void doLock() {
        this.lock();
    }

    void lock() {
        if (this.isLocked()) {
            throw new ElementLockedException(this);
        }
        this.isLocked = true;
    }

    public void doUnlock() {
        this.unlock();
        this.transfer();
    }

    void unlock() {
        this.isLocked = false;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public boolean offer(E e) {
        return this.offer(e, true);
    }

    public boolean offer(E e, boolean addIfLocked) {
        if (this.isLocked()) {
            if (addIfLocked) {
                return this.queueQueue.offer(e);
            }
            return false;
        }
        return super.offer(e);
    }

    @Override
    public boolean remove(Object o) {
        if (this.isLocked()) {
            return this.queueQueue.remove(o);
        }
        return super.remove(o);
    }

    @Override
    public void clear() {
        if (this.isLocked()) {
            throw new ElementLockedException(this);
        }
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.isLocked()) {
            return this.queueQueue.addAll(c);
        }
        return super.addAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return super.iterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.isLocked()) {
            throw new ElementLockedException(this);
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.isLocked()) {
            throw new ElementLockedException(this);
        }
        return super.retainAll(c);
    }

    @Override
    public Spliterator<E> spliterator() {
        if (this.isLocked()) {
            throw new ElementLockedException(this);
        }
        return super.spliterator();
    }

    protected boolean transfer() {
        boolean empty = !this.queueQueue.isEmpty();
        super.addAll(this.queueQueue);
        this.queueQueue.clear();
        return empty;
    }
}

