/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.sequence;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public interface ByteSequence {
    public int length();

    public Byte byteAt(int var1);

    public ByteSequence subSequence(int var1, int var2);

    public String toString();

    default public IntStream ints() {
        return StreamSupport.intStream(() -> {
            class ByteIterator
            implements PrimitiveIterator.OfInt {
                int cur = 0;

                ByteIterator() {
                }

                @Override
                public boolean hasNext() {
                    return this.cur < ByteSequence.this.length();
                }

                @Override
                public int nextInt() {
                    if (this.hasNext()) {
                        return Byte.toUnsignedInt(ByteSequence.this.byteAt(this.cur++));
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void forEachRemaining(IntConsumer block) {
                    while (this.cur < ByteSequence.this.length()) {
                        block.accept(Byte.toUnsignedInt(ByteSequence.this.byteAt(this.cur)));
                        ++this.cur;
                    }
                }
            }
            return Spliterators.spliterator(new ByteIterator(), (long)this.length(), 16);
        }, 16464, false);
    }
}

