/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.reflection;

import com.github.jonathanxd.iutils.reflection.MethodSpecification;
import com.github.jonathanxd.iutils.reflection.RClass;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Reflection {
    public static Object callDeclaredMethod(RClass rclass, String methodName, Object[] args, Class<?> ... arguments) throws Exception {
        Class<?> classRef = rclass.getClassRef();
        Object obj = rclass.getObjectRef();
        Method m = classRef.getDeclaredMethod(methodName, arguments);
        if (!m.isAccessible()) {
            m.setAccessible(!m.isAccessible());
        }
        if (args == null) {
            return m.invoke(obj != null ? obj : null, new Object[0]);
        }
        return m.invoke(obj != null ? obj : null, args);
    }

    public static Object callNonDeclaredMethod(RClass rclass, String methodName, Object[] args, Class<?> ... arguments) throws Exception {
        Class<?> classRef = rclass.getClassRef();
        Object obj = rclass.getObjectRef();
        Method m = classRef.getMethod(methodName, arguments);
        if (!m.isAccessible()) {
            m.setAccessible(!m.isAccessible());
        }
        if (args == null) {
            return m.invoke(obj != null ? obj : null, new Object[0]);
        }
        return m.invoke(obj != null ? obj : null, args);
    }

    public static void changeFinalField(RClass rclass, String fieldName, Object newValue) throws Exception {
        Field field;
        Class<?> classRef = rclass.getClassRef();
        Object obj = rclass.getObjectRef();
        try {
            field = classRef.getField(fieldName);
        }
        catch (Exception e) {
            field = classRef.getDeclaredField(fieldName);
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if (Modifier.isFinal(field.getModifiers())) {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        field.set(obj, newValue);
    }

    public static <T> T constructEmpty(Class<? super T> clazz) throws ReflectiveOperationException {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterCount() != 0) continue;
                return (T)constructor.newInstance(new Object[0]);
            }
            return null;
        }
    }

    public static boolean isOnClassInit(Class<?> classI) {
        StackTraceElement[] elem;
        for (StackTraceElement e : elem = Thread.currentThread().getStackTrace()) {
            if (!e.getClassName().equals(classI.getName()) || !e.getMethodName().equals("<init>")) continue;
            return true;
        }
        return false;
    }

    public static StackTraceElement getCallInformations(Class<?> classI) {
        StackTraceElement[] elem;
        for (StackTraceElement e : elem = Thread.currentThread().getStackTrace()) {
            if (!e.getClassName().equals(classI.getName())) continue;
            return e;
        }
        return null;
    }

    public static boolean methodExists(MethodSpecification method, Class<?> clazz) {
        return Reflection.findMethod(method, clazz) != null;
    }

    public static Method findDeclaredMethods(MethodSpecification method, Class<?> clazz) {
        return Reflection.findMethodsArray(method, clazz.getDeclaredMethods());
    }

    public static Method findMethod(MethodSpecification method, Class<?> clazz) {
        return Reflection.findMethodsArray(method, clazz.getMethods());
    }

    private static Method findMethodsArray(MethodSpecification method, Method[] methods) {
        for (Method m : methods) {
            if (!method.match(m)) continue;
            return m;
        }
        return null;
    }

    public static <T> T tryTranslate(Class<T> tClass, Object value) {
        return Reflection.discovery(tClass, value, tClass.getDeclaredMethods());
    }

    private static <T> T discovery(Class<T> tClass, Object value, Method[] methods) {
        for (Method method : methods) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().startsWith("parse") && !method.getName().startsWith("valueOf")) continue;
            for (Class<?> type : method.getParameterTypes()) {
                if (!type.isAssignableFrom(value.getClass())) continue;
                try {
                    Object invokeResult = method.invoke(null, value);
                    if (invokeResult == null) continue;
                    System.out.println(invokeResult);
                    return (T)invokeResult;
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static <T> T tryClone(T objectToClone) {
        Class<?> classToClone = objectToClone.getClass();
        try {
            Method method = classToClone.getMethod("clone", new Class[0]);
            if (Modifier.isPublic(method.getModifiers())) {
                return (T)method.invoke(objectToClone, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return objectToClone;
    }

    public static <T> T findStaticField(Class<?> classToFind, String fieldName) {
        try {
            Field field = classToFind.getDeclaredField(fieldName);
            return (T)field.get(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static <T extends Annotation> T[] getAnnotation(Class<?> aClass, Class<T> annotationClass) {
        Class<?>[] interfaces;
        Annotation[] annotations;
        ArrayList list = new ArrayList();
        Class<?> superClass = aClass.getSuperclass();
        if (superClass != null && (annotations = Reflection.getAnnotation(superClass, annotationClass)).length > 0) {
            Reflection.addAll(list, (Annotation[])annotations);
        }
        if ((interfaces = aClass.getInterfaces()) != null && interfaces.length > 0) {
            for (Class<?> sub : aClass.getInterfaces()) {
                Annotation[] annotations2 = Reflection.getAnnotation(sub, annotationClass);
                if (annotations2.length <= 0) continue;
                Reflection.addAll(list, (Annotation[])annotations2);
            }
        }
        Reflection.addAll(list, (Annotation[])aClass.getDeclaredAnnotationsByType(annotationClass));
        Annotation[] t = (Annotation[])Array.newInstance(annotationClass, list.size());
        return list.toArray(t);
    }

    private static <T extends Annotation> void addAll(List<T> list, T[] array) {
        if (array == null || array.length <= 0) {
            return;
        }
        for (T t : array) {
            if (list.contains(t)) continue;
            list.add(t);
        }
    }

    public static Collection<Field> fieldCollection(Object object, boolean semiRecursive, boolean statics, boolean transients) {
        Class<?> clazz = object.getClass();
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Reflection.toCollection(clazz.getDeclaredFields(), statics, transients));
        if (semiRecursive) {
            fields.addAll(Reflection.toCollection(clazz.getFields(), statics, transients));
        }
        return fields;
    }

    public static Collection<Field> toCollection(Field[] fields, boolean statics, boolean transients) {
        HashSet<Field> fieldSet = new HashSet<Field>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) && !statics || Modifier.isTransient(field.getModifiers()) && !transients) continue;
            fieldSet.add(field);
        }
        return fieldSet;
    }
}

