/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.reflection;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

public class MethodSpecification {
    private final Optional<String> name;
    private final Optional<Class<?>[]> parameterTypes;
    private final Optional<Class<?>> returnType;

    public MethodSpecification(String name, Class<?>[] parameterTypes, Class<?> returnType) {
        this.name = Optional.ofNullable(name);
        this.parameterTypes = Optional.ofNullable(parameterTypes);
        this.returnType = Optional.ofNullable(returnType);
    }

    public boolean match(Method m) {
        m.setAccessible(true);
        if (this.name.isPresent() && !m.getName().equals(this.name.get())) {
            return false;
        }
        if (this.parameterTypes.isPresent() && !Arrays.deepEquals(m.getParameterTypes(), this.parameterTypes.get())) {
            return false;
        }
        return !this.returnType.isPresent() || m.getReturnType().equals(this.returnType.get());
    }
}

