/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.object;

import com.github.jonathanxd.iutils.object.Reference;
import com.github.jonathanxd.iutils.optional.Optional;
import com.github.jonathanxd.iutils.optional.Required;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ReferenceBuilder<T> {
    private Class<? extends T> aClass;
    private List<Reference> related = new ArrayList<Reference>();
    private Object hold = null;

    ReferenceBuilder() {
    }

    @Required
    public ReferenceBuilder<T> a(Class<? extends T> aClass) {
        this.aClass = aClass;
        return this;
    }

    @Optional
    public ReferenceBuilder<T> hold(Object object) {
        this.hold = object;
        return this;
    }

    @Optional
    public <E> ReferenceBuilder<T> of(List<Reference<E>> related) {
        this.related.addAll(related);
        return this;
    }

    @SafeVarargs
    @Optional
    public final <E> ReferenceBuilder<T> of(Reference<E> ... related) {
        this.of(Arrays.asList(related));
        return this;
    }

    @Optional
    public ReferenceBuilder<T> of(ReferenceBuilder ... builders) {
        for (ReferenceBuilder builder : builders) {
            this.of(builder.build());
        }
        return this;
    }

    @SafeVarargs
    @Optional
    public final <E> ReferenceBuilder<T> of(Class<? extends E> ... classes) {
        ArrayList<Reference<Reference<? extends E>>> references = new ArrayList<Reference<Reference<? extends E>>>();
        for (Class<? extends E> classz : classes) {
            references.add(new ReferenceBuilder<E>().a(classz).build());
        }
        this.of(references);
        return this;
    }

    @Optional
    public <E> ReferenceBuilder<T> and(List<Reference<E>> related) {
        this.andCheck();
        this.of(related);
        return this;
    }

    @SafeVarargs
    @Optional
    public final <E> ReferenceBuilder<T> and(Reference<E> ... related) {
        this.andCheck();
        this.of(related);
        return this;
    }

    @Optional
    public ReferenceBuilder<T> and(ReferenceBuilder ... builders) {
        this.andCheck();
        this.of(builders);
        return this;
    }

    @Optional
    public ReferenceBuilder<T> and(Class<?> ... classes) {
        this.andCheck();
        this.of(classes);
        return this;
    }

    private void andCheck() {
        if (this.related.size() == 0) {
            throw new IllegalStateException("'and' cannot be used here! Usage ex: referenceTo().a(Object.class).of(String.class).and(Class.class)");
        }
    }

    public Reference<T> build() {
        return new Reference<T>(this.aClass, this.related.toArray(new Reference[this.related.size()]), this.hold);
    }
}

