/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.map;

import com.github.jonathanxd.iutils.arrays.Arrays;
import com.github.jonathanxd.iutils.extra.Container;
import com.github.jonathanxd.iutils.extra.SetOf;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ObjectMap
implements Map<Object, Object> {
    Arrays<Node<Object, Object>> nodes = new Arrays<Node>(new Node[0]);

    @Override
    public int size() {
        return this.nodes.length();
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.length() > 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getNode(ObjectMap.hash(key), key).isPresent();
    }

    @Override
    public boolean containsValue(Object value) {
        Optional<Node> opt = this.nodes.stream().filter(entry -> entry.value == value).findFirst();
        return opt.isPresent();
    }

    @Override
    public Object get(Object key) {
        return this.getNode(ObjectMap.hash(key), key).getValue();
    }

    @Override
    public Object put(Object key, Object value) {
        this.nodes.add(new Node<Object, Object>(ObjectMap.hash(key), key, value, null));
        return key;
    }

    @Override
    public Object remove(Object key) {
        Container<Node<Object, Object>> node = this.getNode(ObjectMap.hash(key), key);
        if (!node.isPresent()) {
            return null;
        }
        this.nodes.remove((Node<Object, Object>)node.get());
        return ((Node)node.get()).value;
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> m) {
        m.forEach((k, v) -> this.put(k, v));
    }

    @Override
    public void clear() {
        this.nodes = new Arrays<Node>(new Node[0]);
    }

    @Override
    public Set<Object> keySet() {
        HashSet<Object> set = new HashSet<Object>();
        this.nodes.forEach((? super T node) -> set.add(node.key));
        return set;
    }

    @Override
    public Collection<Object> values() {
        Arrays<Object> arr = new Arrays<Object>(new Object[0]);
        this.nodes.forEach((? super T node) -> arr.add(node.value));
        return arr.toCollection();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return SetOf.setOf(this.nodes.toGenericArray());
    }

    public Container<Node<Object, Object>> getNode(int hash, Object key) {
        Container result = (Container)Container.empty();
        Optional<Node> opt = this.nodes.stream().filter(entry -> entry.hash == hash && entry.key.equals(key)).findFirst();
        if (opt.isPresent()) {
            result.set(opt.get());
        }
        return result;
    }

    protected static final int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    protected static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Node<K, V> next;

        Node(int hash, K key, V value, Node<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && Objects.equals(this.key, (e = (Map.Entry)o).getKey()) && Objects.equals(this.value, e.getValue());
        }
    }
}

